package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKeyApply;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKey;
import com.xunlei.niux.data.giftcenter.vo.PackageWebgameGiftKeyApply;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class PackageWebgameGiftKeyApplyManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public PackageWebgameGiftKeyApplyManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        PackageWebgameGiftKeyApply query = findBean(PackageWebgameGiftKeyApply.class, "packagewebgamegiftkeyapply");
        String packageIdStr = findParameter("query_packageId");
        if(StringUtils.isNotEmpty(packageIdStr)){
            query.setPackageId(Long.valueOf(packageIdStr));
        }

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<PackageWebgameGiftKeyApply> list = new ArrayList<PackageWebgameGiftKeyApply>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("seqid", OrderType.ESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<PackageWebgameGiftKeyApply> sheet = new Sheet<PackageWebgameGiftKeyApply>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

   
    public int getRownum() {
        return rownum;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }
}
