package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackagePlatforms;
import com.xunlei.niux.manager.web.cache.GiftCenterCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class PackagePlatformsManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public PackagePlatformsManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        PackagePlatforms query = findBean(PackagePlatforms.class,"packageplatforms");
        if(query.getSeqid()==null||query.getSeqid()==0){
            query = new PackagePlatforms();
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<PackagePlatforms> list = new ArrayList<PackagePlatforms>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("editTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<PackagePlatforms> sheet = new Sheet<PackagePlatforms>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            PackagePlatforms req = findBean(PackagePlatforms.class,"packageplatforms");
            if(StringUtils.isEmpty(req.getPlatName())){
                throw new XLRuntimeException("名称为空");
            }

            PackagePlatforms query = new PackagePlatforms();
            query.setPlatName(req.getPlatName());

            if(baseSo.countObject(query)>0){
                throw new XLRuntimeException(req.getPlatName()+"已经存在，请不要重复添加");
            }

            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.addObject(req);
            updateCache();
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            PackagePlatforms req = findBean(PackagePlatforms.class,"packageplatforms");
            if(StringUtils.isEmpty(req.getPlatName())){
                throw new XLRuntimeException("名称为空");
            }

            PackagePlatforms query1 = new PackagePlatforms();
            query1.setSeqid(req.getSeqid());
            if(baseSo.countObject(query1)==0){
                throw new XLRuntimeException("不存在，修改失败！");
            }

            PackagePlatforms query2 = new PackagePlatforms();
            query2.setPlatName(req.getPlatName());
            PackagePlatforms res = baseSo.findObject(query2);
            if(res!=null && !res.getSeqid().equals(req.getSeqid())){
                throw new XLRuntimeException(req.getPlatName()+"已存在！");
            }



            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.updateObjectById(req);
            updateCache();
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(PackagePlatforms.class, id);
            }
            updateCache();
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    public List<SelectItem> getPlatformsSelectItemList() {
        return GiftCenterCache.getInstance().getPlatformsSelectItemList();
    }
    public Map<Long, String> getPlatformsMap() {
        return GiftCenterCache.getInstance().getPlatformsMap();
    }

    private void updateCache(){
        GiftCenterCache.getInstance().updatePlatforms();
    }



}
