package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;


public class PackageMobilegameGiftManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;
    private UploadedFile importGiftKeyValue;
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");

    public PackageMobilegameGiftManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        PackageMobilegameGift query = new PackageMobilegameGift();
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<PackageMobilegameGift> list = new ArrayList<PackageMobilegameGift>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("applyTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<PackageMobilegameGift> sheet = new Sheet<PackageMobilegameGift>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            PackageMobilegameGift req = findBean(PackageMobilegameGift.class,"packagemobilegamegift");
            checkParams();

            PackageMobilegameGift query = new PackageMobilegameGift();
            query.setPackageName(req.getPackageName());

            if(baseSo.countObject(query)>0){
                throw new XLRuntimeException(req.getPackageName()+"已经存在，请不要重复添加");
            }

            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            FacadeFactory.INSTANCE.getGiftCenterBo().addPackageMobilegameGift(req);

        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            PackageMobilegameGift req = findBean(PackageMobilegameGift.class,"packagemobilegamegift");
            checkParams();

            req.setEditTime(now());
            req.setEditBy(this.currentUserLogo());

            baseSo.updateObjectById(req);

        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    private void checkParams() throws Exception{
        PackageMobilegameGift req = findBean(PackageMobilegameGift.class,"packagemobilegamegift");

        if(req.getGameId()==null||req.getGameId()==0){
            throw new XLRuntimeException("游戏为空");
        }
        if(req.getPlatformId()==null||req.getPlatformId()==0){
            throw new XLRuntimeException("平台为空");
        }
        if(StringUtils.isEmpty(req.getPackageName())){
            throw new XLRuntimeException("礼包名称为空");
        }
        if(StringUtils.isEmpty(req.getPackageContent())){
            throw new XLRuntimeException("礼包内容为空");
        }
        if(StringUtils.isEmpty(req.getStartTime().trim())
                || req.getStartTime().trim().length()!=19){
            throw new XLRuntimeException("使用开始日期错误");
        }
        if(StringUtils.isEmpty(req.getEndTime().trim())
            || req.getEndTime().trim().length()!=19){
            throw new XLRuntimeException("使用结束日期错误");
        }
    }


    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(PackageMobilegameGift.class, id);
            }
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }

    public String allow(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                PackageMobilegameGift byId = baseSo.getBaseDao().findById(PackageMobilegameGift.class, id);
                //当所处的状态为 已申请、已拒绝  时可以审批为通过
                if(byId.getPackageStatus()==0||byId.getPackageStatus()==-1){
                    byId.setEditBy(this.currentUserLogo());
                    byId.setEditTime(now());
                    byId.setPackageStatus(1);
                    baseSo.updateObjectById(byId);

                    //此处需要生成模板文件

                }else{
                    continue;
                }
            }
        }catch(Exception e){
            logger.error("审批失败", e);
            mergeJsmessage("审批失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String refuse(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                PackageMobilegameGift byId = baseSo.getBaseDao().findById(PackageMobilegameGift.class, id);
                //当所处的状态为 已申请  时可以审批为已拒绝
                if(byId.getPackageStatus()==0){
                    byId.setEditBy(this.currentUserLogo());
                    byId.setEditTime(now());
                    byId.setPackageStatus(-1);
                    baseSo.updateObjectById(byId);
                }else{
                    continue;
                }
            }
        }catch(Exception e){
            logger.error("审批失败", e);
            mergeJsmessage("审批失败，原因：" + e.getMessage());
        }
        return "";
    }

    public void importGiftKey(){
        this.authenticateAdd();//新增权限
        String curUer = this.currentUserLogo();
        String seqidstr = findParameter("import_seqid");
        Long packageId  = Long.valueOf(seqidstr);

        if(importGiftKeyValue==null || packageId==0){
            alertJS("导入数据异常");
            return ;
        }
        try {
            String fname = importGiftKeyValue.getName();
            String prefix=fname.substring(fname.lastIndexOf(".")+1);
            List<String> list;
            if("txt".equals(prefix)){
                list = importTxt();
            }else if("xlsx".equals(prefix) || "xls".equals(prefix)){
                list = importXls();
            }else{
                alertJS("只能导入txt或者excel文件");
                return ;
            }

            if(list.size()>0){
                FacadeFactory.INSTANCE.getGiftCenterBo().importPackageMobilegameKey(list,packageId);
            }

        } catch (Exception e) {
            e.printStackTrace();
            alertJS("导入异常："+e.getMessage());
            return;
        }

        return ;
    }

    private List<String> importTxt() throws Exception{
        BufferedReader reader = null;
        List<String> list = new ArrayList<String>();
        try {
            String filename = FileUploadUtil.upLoadFile(importGiftKeyValue);
            filename = FILEPATH + filename;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));
            String str;
            while ((str = reader.readLine()) != null) {
                if(StringUtils.isNotEmpty(str)){
                    list.add(str.trim());
                }
            }
        }finally {
            if(reader!=null){
                reader.close();
            }
        }
        return list;
    }
    private List<String> importXls() throws Exception{
        FileInputStream fis = null;
        List<String> list = new ArrayList<String>();
        try {

            String filename= FileUploadUtil.upLoadFile(importGiftKeyValue);
            filename = FILEPATH+filename;
            fis = new FileInputStream(new File(filename));
            Workbook wb = WorkbookFactory.create(fis);
            org.apache.poi.ss.usermodel.Sheet sheet = wb.getSheetAt(0);

            for(Row row: sheet){
                Cell cell0 = row.getCell(0);
                if(cell0!=null && StringUtils.isNotEmpty(cell0.toString())){
                    list.add(cell0.toString().trim());
                }
            }
        }finally{
            if(fis != null){
                fis.close();
            }
        }
        return list;
    }



    public UploadedFile getImportGiftKeyValue() {
        return importGiftKeyValue;
    }

    public void setImportGiftKeyValue(UploadedFile importGiftKeyValue) {
        this.importGiftKeyValue = importGiftKeyValue;
    }
}
