package com.xunlei.niux.manager.web.model.giftcenter;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftKey;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class PackageMobilegameGiftKeyManagedBean extends BaseManagedBean {

    public PackageMobilegameGiftKeyManagedBean() {
    }

    public String getQueryData(){
        this.authenticateRun();

        try {
            String packageIdStr = findParameter("query_packageId");
            String gameIdStr = findParameter("query_gameId");
            String platformIdStr = findParameter("query_platformId");
            Long gameId= null;
            Long platformId= null;
            if (StringUtils.isEmpty(packageIdStr)) {
                throw new XLRuntimeException("礼包ID必填");
            }
            Long packageId = Long.valueOf(packageIdStr);
            if (StringUtils.isNotEmpty(gameIdStr)) {
                gameId = Long.valueOf(gameIdStr);
            }
            if (StringUtils.isNotEmpty(platformIdStr)) {
                platformId = Long.valueOf(platformIdStr);
            }


            PagedFliper pagedFliper = this.getFliper();
            int count = FacadeFactory.INSTANCE.getGiftCenterBo().countPackageMobilegameGiftKey(packageId, gameId, platformId);
            pagedFliper.setRecordCount(count);

            List<PackageMobilegameGiftKey> list = new ArrayList<PackageMobilegameGiftKey>();
            if(count>0){
                int pageNo = pagedFliper.getPageNo();
                int pageSize = pagedFliper.getPageSize();
                list = FacadeFactory.INSTANCE.getGiftCenterBo().getPackageMobilegameGiftKey(packageId, gameId, platformId, (pageNo - 1) * pageSize, pageSize);
            }
            Sheet<PackageMobilegameGiftKey> sheet = new Sheet<PackageMobilegameGiftKey>(count, list);
            this.mergePagedDataModel(sheet, pagedFliper);
        } catch (NumberFormatException e) {
            logger.error("数据异常", e);
            mergeJsmessage("数据异常，原因：" + e.getMessage());
        }
        return "";
    }


}
