package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftKey;
import com.xunlei.niux.data.giftcenter.vo.PackageMobilegameGiftKeyApply;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class PackageMobilegameGiftKeyApplyManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public PackageMobilegameGiftKeyApplyManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        try {
            PackageMobilegameGiftKeyApply query = findBean(PackageMobilegameGiftKeyApply.class, "packagemobilegamegiftkeyapply");
            String packageIdStr = findParameter("query_packageId");
            if(StringUtils.isNotEmpty(packageIdStr)){
                query.setPackageId(Long.valueOf(packageIdStr));
            }

            PagedFliper pagedFliper = this.getFliper();
            int count = baseSo.countObject(query);
            pagedFliper.setRecordCount(count);

            List<PackageMobilegameGiftKeyApply> list = new ArrayList<PackageMobilegameGiftKeyApply>();
            if(count>0){
                rownum = 1;
                Page page=new Page();
                page.setPageNo(pagedFliper.getPageNo());
                page.setPageSize(pagedFliper.getPageSize());
                page.addOrder("seqid", OrderType.ESC);
                list = baseSo.findObjects(query, page);
            }
            Sheet<PackageMobilegameGiftKeyApply> sheet = new Sheet<PackageMobilegameGiftKeyApply>(count, list);
            this.mergePagedDataModel(sheet, pagedFliper);
        } catch (NumberFormatException e) {
            logger.error("数据异常", e);
            mergeJsmessage("数据异常，原因：" + e.getMessage());
        }
        return "";
    }

    public int getRownum() {
        return rownum;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }
}
