package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturer;
import com.xunlei.niux.data.giftcenter.vo.PackageManufacturerApply;
import com.xunlei.niux.manager.web.cache.GiftCenterCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class PackageManufacturerApplyManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;


    public PackageManufacturerApplyManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }


    public Map<Long,String> getAllManufacturers(){
          return GiftCenterCache.getInstance().getManufactorerMap();
    }

    public List<SelectItem> getAllManufacturersList(){
        return GiftCenterCache.getInstance().getManufactorerSelectItemList();
    }

    public String getQueryData(){
        this.authenticateRun();

        PackageManufacturerApply query = findBean(PackageManufacturerApply.class,"packagemanufacturerapply");
        if(query.getSeqid()==null||query.getSeqid()==0) {
            query = new PackageManufacturerApply();
        }
        PagedFliper pagedFliper = this.getFliper();

        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<PackageManufacturerApply> list = new ArrayList<PackageManufacturerApply>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("applydate", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<PackageManufacturerApply> sheet = new Sheet<PackageManufacturerApply>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    private void check(PackageManufacturerApply req){

    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            PackageManufacturerApply req = findBean(PackageManufacturerApply.class,"packagemanufacturerapply");
            check(req);
            baseSo.addObject(req);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，请务必截图联系管理员！原因：" + e.getMessage());
        }
        return "";
    }
    public String refuse(){
        this.authenticateEdit();
        try{
            PackageManufacturerApply req = findBean(PackageManufacturerApply.class,"packagemanufacturerapply");
            check(req);
            req.setApprovedate(now());
            req.setApproveid(currentUserLogo());
            req.setStatus(-1);
            baseSo.updateObjectById(req);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        getQueryData();
        return "";
    }

    /**
     * 使用原来的删除方法当作审批通过的方法
     * @return
     */
    public String allow(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                PackageManufacturerApply apply = baseSo.findById(PackageManufacturerApply.class, Long.valueOf(id));
                if(apply.getStatus()!=0)
                    continue;
                PackageManufacturer manufacturer = baseSo.findById(PackageManufacturer.class, apply.getManufacturerid());
                if(manufacturer==null){
                    continue;
                }

                manufacturer.setUserid(apply.getApplyid());
                manufacturer.setStatus(1);
                baseSo.updateObjectById(manufacturer);
                apply.setStatus(1);
                apply.setApprovedate(now());
                apply.setApproveid(currentUserLogo());
                baseSo.updateObjectById(apply);
            }
            getQueryData();
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }


}
