package com.xunlei.niux.manager.web.model.giftcenter;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.giftcenter.bo.BaseSo;
import com.xunlei.niux.data.giftcenter.facade.FacadeFactory;
import com.xunlei.niux.data.giftcenter.vo.IndexPageLinks;
import com.xunlei.niux.data.giftcenter.vo.PackageGames;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class IndexPageLinksManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private int rownum = 0;

    public IndexPageLinksManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public String getQueryData(){
        this.authenticateRun();

        IndexPageLinks query = findBean(IndexPageLinks.class,"indexpagelinks");
        if(query.getSeqid()==null||query.getSeqid()==0) {
            query = new IndexPageLinks();
        }
        PagedFliper pagedFliper = this.getFliper();

        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);

        List<IndexPageLinks> list = new ArrayList<IndexPageLinks>();
        if(count>0){
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("displayOrder", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<IndexPageLinks> sheet = new Sheet<IndexPageLinks>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        this.authenticateAdd();//新增权限
        try{
            IndexPageLinks req = findBean(IndexPageLinks.class,"indexpagelinks");
            if(StringUtils.isEmpty(req.getLinkName())){
                throw new XLRuntimeException("名称为空");
            }
            baseSo.addObject(req);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，请务必截图联系管理员！原因：" + e.getMessage());
        }
        return "";
    }
    public String edit(){
        this.authenticateEdit();
        try{
            IndexPageLinks req = findBean(IndexPageLinks.class,"indexpagelinks");
            if(StringUtils.isEmpty(req.getLinkName())){
                throw new XLRuntimeException("名称为空");
            }
            baseSo.updateObjectById(req);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids){
                baseSo.deleteById(IndexPageLinks.class, id);
            }
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";

    }


}
