package com.xunlei.niux.manager.web.model.gift;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import com.xunlei.common.util.FunRef;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackage;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackageDetail;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackageGame;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.PageUtil;

@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GIFTPACKAGE)
public class GiftPackageManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(GiftPackageManagedBean.class.getName());
	public  List<SelectItem> getGiftPackageSiList(){
		GiftPackage giftPackage=new GiftPackage();
		giftPackage.setIsValid(true);
		List<SelectItem> silist=new ArrayList<SelectItem>();
		List<GiftPackage> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(giftPackage, new Page());
		for(int i=0;i<list.size();i++){
			GiftPackage gp=list.get(i);
			SelectItem si=new SelectItem();
			si.setValue(gp.getPackageId());
			si.setLabel(gp.getPackageId()+"-"+gp.getPackageName());
			silist.add(si);
		}
		return silist;
	}
	public List<SelectItem> getBaseGiftList(){
		Gift query=new Gift();
		query.setIsValid(true);
		List<SelectItem> silist=new ArrayList<SelectItem>();
		List<Gift> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
		for(int i=0;i<list.size();i++){
			Gift g=list.get(i);
			if(g.getGiftType().equals("niuxgift")){
				continue;
			}
			SelectItem si=new SelectItem();
			si.setValue(g.getGiftId());
			si.setLabel(g.getGiftId()+"-"+g.getGiftName());
			silist.add(si);
		}
		return silist;
	}
	public Map<Long,String> getBaseGiftMap(){
		Gift query=new Gift();
		Map<Long,String> map=new HashMap<Long,String>();
		List<Gift> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
		for(int i=0;i<list.size();i++){
			Gift g=list.get(i);
			if(g.equals("niuxgift")){
				continue;
			}
			if(g.equals("gift")){
				continue;
			}
			map.put(g.getGiftId(), g.getGiftName());
		}
		return map;
	}
	public Map<Long,String> getGiftPackageMap(){
		GiftPackage giftPackage=new GiftPackage();
		Map<Long,String> map=new HashMap<Long,String>();
		List<GiftPackage> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(giftPackage, new Page());
		for(int i=0;i<list.size();i++){
			GiftPackage gp=list.get(i);
			map.put(gp.getPackageId(), gp.getPackageName());
		}
		return map;
	}
	public String addGiftPackage(){
		this.authenticateAdd();//添加权限
		GiftPackage giftpackage=this.findBean(GiftPackage.class,"giftPackage");
		try{
			if(giftpackage.getParentPackageId()!=null&&giftpackage.getParentPackageId()==0){
				giftpackage.setParentPackageId(null);
			}
			if(giftpackage.getParentPackageId()!=null&&giftpackage.getParentPackageId().longValue()==giftpackage.getPackageId()){
				giftpackage.setParentPackageId(null);
			}
			if(giftpackage.getParentPackageId()==null){
				giftpackage.setInheritParentGameServerType("NOT");
			}
			FacadeFactory.INSTANCE.getBaseSo().addObject(giftpackage);
		}catch(Exception e){
			logger.error("添加giftpackage失败",e);
			this.mergeJsmessage("添加失败，原因："+e.getMessage());
		}
		return "";
	}
	public String editGiftPackage(){
		this.authenticateEdit();//添加权限
		GiftPackage giftpackage=this.findBean(GiftPackage.class,"giftPackage");
		try{
			if(giftpackage.getParentPackageId()!=null&&giftpackage.getParentPackageId()==0){
				giftpackage.setParentPackageId(null);
			}
			if(giftpackage.getParentPackageId()!=null&&giftpackage.getParentPackageId().longValue()==giftpackage.getPackageId()){
				giftpackage.setParentPackageId(null);
			}
			if(giftpackage.getParentPackageId()==null){
				giftpackage.setInheritParentGameServerType("NOT");
			}
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(giftpackage);
		}catch(Exception e){
			logger.error("编辑gift失败",e);
			this.mergeJsmessage("编辑失败，原因："+e.getMessage());
		}
		return "";
	}
	public String getQueryGiftPackages(){
		this.authenticateRun();
		GiftPackage giftpackage=this.findBean(GiftPackage.class,"giftPackage");
		if(giftpackage.getPackageId()!=null&&giftpackage.getPackageId()==0){
			giftpackage.setPackageId(null);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(giftpackage);
		List<GiftPackage> list=new ArrayList<GiftPackage>();
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper, "packageId","desc");
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(giftpackage, page);
		}
		Sheet<GiftPackage> sheet=new Sheet<GiftPackage>(count, list);
		this.mergePagedDataModel(sheet , pagedFliper);
		return "";
	}
	public String getQueryGiftPackageDetails(){
		this.authenticateRun();
		String packageId=this.findParameter("packageId");
		GiftPackageDetail detail=this.findBean(GiftPackageDetail.class,"giftPackageDetail");
		if(packageId!=null&&!"".equals(packageId)){
			detail.setPackageId(Long.valueOf(packageId));
		}
		if(detail.getPackageId()!=null&detail.getPackageId()==0){
			detail.setPackageId(null);
		}
		if(detail.getPackageDetailId()!=null&&detail.getPackageDetailId()==0){
			detail.setPackageDetailId(null);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(detail);
		List<GiftPackageDetail> list=new ArrayList<GiftPackageDetail>();
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper, "packageDetailId","desc");
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(detail, page);
		}
		Sheet<GiftPackageDetail> sheet=new Sheet<GiftPackageDetail>(count, list);
		this.mergePagedDataModel(sheet , pagedFliper);
		return "";
	}
	public String addGiftPackageDetail(){
		this.authenticateAdd();//添加权限
		GiftPackageDetail giftpackageDetail=this.findBean(GiftPackageDetail.class,"giftPackageDetail");
		try{
			FacadeFactory.INSTANCE.getBaseSo().addObject(giftpackageDetail);
		}catch(Exception e){
			logger.error("添加giftpackagedetail失败",e);
			this.mergeJsmessage("添加失败，原因："+e.getMessage());
		}
		return "";
	}
	public String editGiftPackageDetail(){
		this.authenticateAdd();//添加权限
		GiftPackageDetail giftpackageDetail=this.findBean(GiftPackageDetail.class,"giftPackageDetail");
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(giftpackageDetail);
		}catch(Exception e){
			logger.error("添加giftpackagedetail失败",e);
			this.mergeJsmessage("添加失败，原因："+e.getMessage());
		}
		return "";
	}
	public String getQueryGiftPackageGames(){
		this.authenticateRun();
		String packageId=this.findParameter("packageId");
		GiftPackageGame detail=this.findBean(GiftPackageGame.class,"giftPackageGame");
		if(packageId!=null&&!"".equals(packageId)){
			detail.setPackageId(Long.valueOf(packageId));
		}
		if(detail.getPackageId()!=null&detail.getPackageId()==0){
			detail.setPackageId(null);
		}
		if(detail.getSeqId()!=null&&detail.getSeqId()==0){
			detail.setSeqId(null);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(detail);
		List<GiftPackageGame> list=new ArrayList<GiftPackageGame>();
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper, "seqId","desc");
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(detail, page);
		}
		Sheet<GiftPackageGame> sheet=new Sheet<GiftPackageGame>(count, list);
		this.mergePagedDataModel(sheet , pagedFliper);
		return "";
	}
	public String addGiftPackageGame(){
		this.authenticateAdd();//添加权限
		GiftPackageGame giftpackageGame=this.findBean(GiftPackageGame.class,"giftPackageGame");
		try{
			FacadeFactory.INSTANCE.getBaseSo().addObject(giftpackageGame);
		}catch(Exception e){
			logger.error("添加giftpackagedetail失败",e);
			this.mergeJsmessage("添加失败，原因："+e.getMessage());
		}
		return "";
	}
	public String editGiftPackageGame(){
		this.authenticateEdit();//添加权限
		GiftPackageGame giftpackageGame=this.findBean(GiftPackageGame.class,"giftPackageGame");
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(giftpackageGame);
		}catch(Exception e){
			logger.error("添加giftpackagedetail失败",e);
			this.mergeJsmessage("添加失败，原因："+e.getMessage());
		}
		return "";
	}
}
