package com.xunlei.niux.manager.web.model.gift;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.GiftFlow;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;
import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: jia
 * Date: 13-10-10
 * Time: 下午2:37
 * To change this template use File | Settings | File Templates.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GIFTFLOW)
public class GiftFlowManagedBean extends BaseManagedBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * 查询用户返利信息
     * @return
     */
    public String getGiftFlowList(){
        logger.debug("开始用户返利查询");
        this.authenticateRun();//验证运行权限
        GiftFlow giftFlow=this.findBean(GiftFlow.class,"giftflow");
        if(giftFlow!=null){
            logger.debug("Gift Record "+giftFlow.getFlowId());
            if(giftFlow.getFlowId()!=null && giftFlow.getFlowId()==0){
                giftFlow.setFlowId(null);
            }
            if(giftFlow.getGiftId()!=null && giftFlow.getGiftId()==0){
                giftFlow.setGiftId(null);
            }
        }
        PagedFliper pagedFliper =this.getFliper();
        int count= FacadeFactory.INSTANCE.getBaseSo().countObject(giftFlow);
        List<GiftFlow> list=new ArrayList<GiftFlow>();

        if(count>0){
            Page page= PageUtil.formatPage(pagedFliper, "flowId", "desc");
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list=FacadeFactory.INSTANCE.getBaseSo().findObjects(giftFlow,page);
        }
        Sheet<GiftFlow> sheet=new Sheet<GiftFlow>(count,list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

}
