package com.xunlei.niux.manager.web.model.gamexlvip;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.springframework.beans.BeanUtils;

/**
 * @author Administrator
 */
public class AgentGameXLVipManagedBean extends BaseManagedBean {
//	private static String databasepassword = "sd-9898w";
//	private static String databaseusername = "root";
//	private static String databaseurl = "10.10.10.203:3306";
    private static String databasepassword = "t14284";
    private static String databaseusername = "root";
    private static String databaseurl = "10.1.2.84:3306";

    public String add() {
        this.authenticateAdd();
        AgentGameSendVipConfig agentGameSendVipConfig = this.findBean(AgentGameSendVipConfig.class, "agentGameSendVipConfig");
        String fenQuNums=findParameter("fenQuNums");
        logger.info("fenQuNums:"+fenQuNums);

        List<AgentGameSendVipConfig> configList = new ArrayList<AgentGameSendVipConfig>();
        String[] fenQuNumArray=fenQuNums.split("\\|");
        for(String fenQuNum:fenQuNumArray){
            AgentGameSendVipConfig sendVipConfig = new AgentGameSendVipConfig();
            BeanUtils.copyProperties(agentGameSendVipConfig,sendVipConfig);
            if(fenQuNum==null||"".equals(fenQuNum)){
                continue;
            }
            sendVipConfig.setServerId(fenQuNum);
            configList.add(sendVipConfig);
        }
        try {
            addAgentGameSendVipConfig(configList);
        } catch (Exception e) {
            logger.error("add gamesendvipconfig exception", e);
        }


        return "";
    }

    public String edit() {
        this.authenticateEdit();
        AgentGameSendVipConfig agentGameSendVipConfig = this.findBean(AgentGameSendVipConfig.class, "agentGameSendVipConfig");
        try {
            updateAgentGameSendVipConfig(agentGameSendVipConfig);
        } catch (Exception e) {
            logger.error("update gamesendvipconfig exception", e);
        }
        return "";
    }

    public String getQueryAgentGameSendVipConfigs() {
        this.authenticateRun();
        AgentGameSendVipConfig agentGameSendVipConfig = this.findBean(AgentGameSendVipConfig.class, "agentGameSendVipConfig");
        try {
            List<AgentGameSendVipConfig> list = getAgentGameSendVipConfigs(agentGameSendVipConfig.getAgentId(), agentGameSendVipConfig.getGameId());
            list = list == null ? new ArrayList<AgentGameSendVipConfig>() : list;
            Sheet<AgentGameSendVipConfig> sheet = new Sheet<AgentGameSendVipConfig>(list.size(), list);
            this.mergePagedDataModel(sheet, this.getFliper());
        } catch (Exception e) {
            logger.error("query gamesendvipconfig exception", e);
        }
        return "";
    }

    public String getQueryAgentGameSendVipRecords() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        AgentGameSendVipRecord agentGameSendVipRecords = this.findBean(AgentGameSendVipRecord.class, "agentGameSendVipRecord");
        try {
            List<AgentGameSendVipRecord> list = getAgentGameSendVipRecords(agentGameSendVipRecords, fliper.getPageSize(), fliper.getPageNo());
            list = list == null ? new ArrayList<AgentGameSendVipRecord>() : list;
            Sheet<AgentGameSendVipRecord> sheet = new Sheet<AgentGameSendVipRecord>(list.size(), list);
            this.mergePagedDataModel(sheet, this.getFliper());
        } catch (Exception e) {
            logger.error("query gamesendvipconfig exception", e);
        }
        return "";
    }

    private static List<AgentGameSendVipRecord> getAgentGameSendVipRecords(AgentGameSendVipRecord agentGameSendVipRecord, int pageSize, int pageNo) throws Exception {
//		int fromIndex=(pageSize-1)*pageNo;
//		int toIndex=pageSize*pageNo-1;
        List<Object> paramList = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder("select * from GameSendVipRecord where 1=1 ");
        if (StringTools.isEmpty(agentGameSendVipRecord.getAgentId()) == false) {
            sb.append(" and agentId=?");
            paramList.add(agentGameSendVipRecord.getAgentId());
        }
        
        if (StringTools.isEmpty(agentGameSendVipRecord.getGameId()) == false) {
            sb.append(" and gameId=?");
            paramList.add(agentGameSendVipRecord.getGameId());
        }
        
        if (StringTools.isEmpty(agentGameSendVipRecord.getUserId()) == false) {
            sb.append(" and userId=?");
            paramList.add(agentGameSendVipRecord.getUserId());
        }
        
        Connection conn = getConnection();
        ResultSet rs = query(sb.toString(), paramList, conn);
        return formatAgentGameSendVipRecord(rs);
    }

    private static ResultSet query(String prepareSql, List<Object> paramList, Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(prepareSql);
        paramList = paramList == null ? new ArrayList<Object>() : paramList;
        for (int i = 0; i < paramList.size(); i++) {
            ps.setObject(i + 1, paramList.get(i));
        }
        return ps.executeQuery();
    }

    private static List<AgentGameSendVipRecord> formatAgentGameSendVipRecord(ResultSet rs) throws Exception {
        List<AgentGameSendVipRecord> list = new ArrayList<AgentGameSendVipRecord>();
        while (rs.next()) {
            AgentGameSendVipRecord record = new AgentGameSendVipRecord();
            record.setSeqId(rs.getLong("SeqId"));
            record.setAgentId(rs.getString("AgentId"));
            record.setGameId(rs.getString("GameId"));
            record.setServerId(rs.getString("ServerId"));
            record.setUserId(rs.getString("Userid"));
            record.setCustomerId(rs.getString("CustomerId"));
            record.setSendDays(rs.getInt("senddays"));
            record.setSendType(rs.getString("sendtype"));
            record.setSendTime(rs.getString("sendTime"));
            list.add(record);
        }
        return list;
    }

    private static void updateAgentGameSendVipConfig(AgentGameSendVipConfig config) throws Exception {
        AgentGameSendVipConfig oldAgentGameSendVipConfig = getAgentGameSendVipConfigById(config.getSeqId());
        if (oldAgentGameSendVipConfig.getCurrentNum() > config.getMaxNum()) {
            throw new RuntimeException("当前数量超过最大数量");
        }
        StringBuilder sb = new StringBuilder(
                "update gamesendvipconfig set StartTime=?,endTime=?,open=?,maxnum=? where seqId=?");
        Connection conn = getConnection();
        PreparedStatement ps = conn.prepareStatement(sb.toString());
        ps.setObject(1, config.getStartTime());
        ps.setObject(2, config.getEndTime());
        ps.setObject(3, config.getOpen());
        ps.setObject(4, config.getMaxNum());
        ps.setObject(5, config.getSeqId());
        ps.execute();
    }

    private static List<AgentGameSendVipConfig> getAgentGameSendVipConfigs(String agentId, String gameId) throws Exception {
        String sql = "select * from gamesendvipconfig where AgentId=? and GameId=?";
        Connection conn = getConnection();
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setObject(1, agentId);
        ps.setObject(2, gameId);
        ResultSet rs = ps.executeQuery();
        return formatAgentGameSendVipConfig(rs);
    }

    private static AgentGameSendVipConfig getAgentGameSendVipConfigById(long seqid) throws Exception {
        String sql = "select * from gamesendvipconfig where seqid=?";
        Connection conn = getConnection();
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setObject(1, seqid);
        ResultSet rs = ps.executeQuery();
        List<AgentGameSendVipConfig> configList = formatAgentGameSendVipConfig(rs);
        return (configList == null || configList.size() == 0) ? null : configList.get(0);
    }

    private static List<AgentGameSendVipConfig> formatAgentGameSendVipConfig(ResultSet rs) throws Exception {
        List<AgentGameSendVipConfig> list = new ArrayList<AgentGameSendVipConfig>();
        while (rs.next()) {
            AgentGameSendVipConfig config = new AgentGameSendVipConfig();
            config.setSeqId(rs.getLong("SeqId"));
            config.setAgentId(rs.getString("AgentId"));
            config.setGameId(rs.getString("GameId"));
            config.setServerId(rs.getString("ServerId"));
            config.setCurrentNum(rs.getInt("currentnum"));
            config.setMaxNum(rs.getInt("maxnum"));
            config.setOpen(rs.getString("open"));
            config.setEndTime(rs.getString("endTime"));
            config.setStartTime(rs.getString("StartTime"));
            config.setType(rs.getString("type"));
            list.add(config);
        }
        return list;
    }

    private static void addAgentGameSendVipConfig(List<AgentGameSendVipConfig> configList) throws Exception {
        if(CollectionUtils.isEmpty(configList)){
            return;
        }
        StringBuilder sb = new StringBuilder(
                "insert into gamesendvipconfig(AgentId,GameId,Serverid,type,StartTime,endTime,open,maxnum,currentnum) values(?,?,?,?,?,?,?,?,?)");

        Connection conn = getConnection();
		conn.setAutoCommit(false);
        PreparedStatement ps = conn.prepareStatement(sb.toString());
        for(AgentGameSendVipConfig config : configList){
            ps.setObject(1, config.getAgentId());
            ps.setObject(2, config.getGameId());
            ps.setObject(3, config.getServerId());
            ps.setObject(4, config.getType());
            ps.setObject(5, config.getStartTime());
            ps.setObject(6, config.getEndTime());
            ps.setObject(7, config.getOpen());
            ps.setObject(8, config.getMaxNum());
            ps.setObject(9, 0);
            ps.addBatch();
        }

        ps.executeBatch();
        conn.commit();
        conn.close();
    }

    /**
     * 获取游戏对应的数据库链接
     *
     * @param gameId
     * @return
     * @throws Exception
     */
    private static Connection getConnection() throws Exception {
        String url = "jdbc:mysql://" + databaseurl + "/xlyouxi" + "?useUnicode=true&amp;characterEncoding=utf8";
        BasicDataSource dataSource = createDatasource(url);
        return dataSource.getConnection();
    }

    /**
     * 创建数据链接
     *
     * @param url
     * @return
     * @throws Exception
     */
    private static BasicDataSource createDatasource(String url) throws Exception {
        Properties p = new Properties();
        p.setProperty("driverClassName", "com.mysql.jdbc.Driver");
        p.setProperty("url", url);
        p.setProperty("password", databasepassword);
        p.setProperty("username", databaseusername);
        return (BasicDataSource) BasicDataSourceFactory.createDataSource(p);
    }

    public static void main(String[] args) {
        AgentGameSendVipConfig config = new AgentGameSendVipConfig();
        config.setGameId("000113");
        config.setServerId("2");
        config.setType("type1");
        config.setStartTime("2013-12-20 02:00:00");
        config.setEndTime("2013-12-22 03:00:00");
        config.setOpen("0");
        config.setMaxNum(0);
        config.setCurrentNum(1);
        config.setSeqId(3L);
//		config.set
        try {
            updateAgentGameSendVipConfig(config);
//			AgentGameSendVipConfig config1=getAgentGameSendVipConfigById(3, "000113");
//			System.out.println(config1.getServerId());
//			addAgentGameSendVipConfig(config);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
