package com.xunlei.niux.manager.web.model.gamepay;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.util.DataSourceUtil;
import com.xunlei.gamepay.util.Md5Encrypt;
import com.xunlei.gamepay.util.http.HttpRequest;
import com.xunlei.gamepay.util.http.IRequest;
import com.xunlei.gamepay.vo.PayDetailOK;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@FunRef("paydetailoperate")
public class PayDetailOKOperateManagedBean extends BaseManagedBean {

	private static Logger log = Logger.getLogger(PayDetailOKOperateManagedBean.class);
	
	private static IFacade facade = IFacade.INSTANCE;
	private static SelectItem[] dsitems = null;
	private static Map<String,String> orderStatusMap;
	private static SelectItem[] orderStatusItems;
	private static Map<String,String> paytypeMap=null;
	private static SelectItem[] paytypeItems;
	
	public String edit(){
		log.debug("edit ...");
		this.authenticateEdit();
		PayDetailOK data = this.findBean(PayDetailOK.class, "paydetailok_data");
		data.setEditby(currentUserLogo());
        data.setEdittime(now()); 
        data.setDsname("1");
        if("".equals(data.getPayMondey())||"NULL".equals(data.getPayMondey())){
        	data.setPayMondey(null);
        }
        if("".equals(data.getVouchersMoney())||"NULL".equals(data.getVouchersMoney())){
        	data.setVouchersMoney(null);
        }
        if("".equals(data.getVouchers())||"NULL".equals(data.getVouchers())){
        	data.setVouchers(null);
        }
      //如果是魔域，则必须分为50 、10份
		if("00001".equals(data.getGameid())||"000001".equals(data.getGameid())){
			double total = Double.parseDouble(data.getTotalmoney());
			if(total%50==0){
				data.setGoodstimes((total/50)+"");
				data.setUnitprice("50");
			}else{
				data.setGoodstimes((total/10)+"");
				data.setUnitprice("10");
			}
		}            
		facade.updatePayDetailOK(data);
		this.getQuery();
		return "";
	}
	
	public String repay(){
		log.debug("repay ...");
		String one_orderidstatus = findParameter("one_orderidstatus");//订单状态
		if("S".equals(one_orderidstatus)){//如果是已经充值成功的订单，是不允许补单的
			alertJS("充值成功的订单不允许补单");
			return "";
		}
		String orderid = this.findParameter("orderid_repay");
		IRequest request = HttpRequest.getInstance();
		String sign = Md5Encrypt.md5(orderid + DataSourceUtil.REPAY_KEY);
		String url = DataSourceUtil.REPAY_URL+"?action=recharge&orderid="+orderid+"&sign="+sign;
		log.info("repay url:"+url);
		String result = request.execute(url);
		log.debug("Repay result:"+result);
		this.getQuery();
		return "";
	}
	
	public String getQuery(){
		log.debug("query ...");
		this.authenticateRun();
		PayDetailOK query = this.findBean(PayDetailOK.class, "paydetailok_query");
		if(null != query){
			if(isEmpty(query.getFromOrderTime())){
				query.setFromOrderTime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -1));
			}
			if(isEmpty(query.getToOrderTime())){
				query.setToOrderTime(com.xunlei.common.util.DatetimeUtil.today());
			}
			
			query.setDsname("1");
		}
		PagedFliper fliper = this.getFliper();
		fliper.setSortColumn(" ordertime desc");
		Sheet<PayDetailOK> sheet = facade.queryPayDetailOK(query, fliper);
		if(sheet.getRowcount() > 0){
			PayDetailOK sum = facade.queryPayDetailOKSum(query);
			sheet.getDatas().add(sum);
		}
		Collection<PayDetailOK> collection = sheet.getDatas();
		for(Iterator<PayDetailOK> iter = collection.iterator();iter.hasNext();){
			PayDetailOK pdok = iter.next();
			if("0".equals(pdok.getGiftFlag())){
				pdok.setPayMondey(new Double(pdok.getTotalmoney()));
			}
		}
		this.mergePagedDataModel(sheet, fliper);
		log.debug("Query end.");
		return "";
	}
	
	public SelectItem[] getDsitems(){
		if(dsitems == null){
			dsitems = new SelectItem[DataSourceUtil.DATASOURCENAMEMAP.size()];
			int i = 0;
			for(String key: DataSourceUtil.DATASOURCENAMEMAP.keySet()){
				dsitems[i] = new SelectItem(key, DataSourceUtil.DATASOURCENAMEMAP.get(key));
				i++;
			}
		}
		return dsitems;
	}
	
	public Map<String,String> getOrderStatusMap(){
		if(null == orderStatusMap){
			orderStatusMap = new HashMap<String,String>();
			orderStatusMap.put("Y", "充值未成功");
			orderStatusMap.put("S", "充值成功");
		}
		return orderStatusMap;
	}
	
	public SelectItem[] getOrderStatusItems(){
		if(null == orderStatusItems){
			orderStatusItems = new SelectItem[2];
			orderStatusItems[0] = new SelectItem("Y", "充值未成功");
			orderStatusItems[1] = new SelectItem("S", "充值成功");
		}
		return orderStatusItems;
	}
	
	public Map<String,String> getPaytypeMap(){
		if(paytypeMap == null){
			paytypeMap = new HashMap<String,String>();
			paytypeMap.put("B", "网银");
			paytypeMap.put("E", "支付宝");
			paytypeMap.put("A1", "雷点账户");
			paytypeMap.put("S", "迅雷一卡通");
			paytypeMap.put("S1", "骏卡充值");
			paytypeMap.put("E2", "财付通");
			paytypeMap.put("C", "神州行");
		}
		return paytypeMap;
	}
	
	public SelectItem[] getPaytypeItems(){
		if( paytypeItems == null){
			paytypeItems = new SelectItem[7];
			paytypeItems[0] = new SelectItem("B", "网银");
			paytypeItems[1] = new SelectItem("E", "支付宝");
			paytypeItems[2] = new SelectItem("A1", "雷点账户");
			paytypeItems[3] = new SelectItem("S", "迅雷一卡通");
			paytypeItems[4] = new SelectItem("S1", "骏卡充值");
			paytypeItems[5] = new SelectItem("E2", "财付通");
			paytypeItems[6] = new SelectItem("C", "神州行");
		}
		return paytypeItems;
	}
}
