package com.xunlei.niux.manager.web.model.gamepay;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.util.DataSourceUtil;
import com.xunlei.gamepay.vo.PayDetailOK;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.HashMap;
import java.util.Map;

@FunRef("paydetailok")
public class PayDetailOKManagedBean extends BaseManagedBean {

	private static Logger log = Logger.getLogger(PayDetailOKManagedBean.class);
	private static IFacade facade = IFacade.INSTANCE;
	private static SelectItem[] dsitems = null;
	private static Map<String,String> orderStatusMap;
	private static Map<String,String> paytypeMap=null;
	private static SelectItem[] paytypeItems;
	
	private static SelectItem[] orderStatusItems;
	
	public String getQuery(){
		log.debug("query ...");
		this.authenticateRun();
		PayDetailOK query = this.findBean(PayDetailOK.class, "paydetailok_query");
		if(null != query){
			if(isEmpty(query.getFromOrderTime())){
				query.setFromOrderTime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -1));
			}
			if(isEmpty(query.getToOrderTime())){
				query.setToOrderTime(com.xunlei.common.util.DatetimeUtil.today());
			}
		
			query.setDsname("3");
		}
		PagedFliper fliper = this.getFliper();
		fliper.setSortColumn(" ordertime desc");
		Sheet<PayDetailOK> sheet = facade.queryPayDetailOK(query, fliper);
		if(sheet.getRowcount() > 0){
			PayDetailOK sum = facade.queryPayDetailOKSum(query);
			sheet.getDatas().add(sum);
		}
//		Collection<PayDetailOK> collection = sheet.getDatas();
//		for(Iterator<PayDetailOK> iter = collection.iterator();iter.hasNext();){
//			PayDetailOK pdok = iter.next();
//			if("0".equals(pdok.getGiftFlag())){
//				pdok.setPayMondey(new Double(pdok.getTotalmoney()));
//			}
//		}
		this.mergePagedDataModel(sheet, fliper);
		log.debug("Query end.");
		return "";
	}
	
	public SelectItem[] getDsitems(){
		if(dsitems == null){
			dsitems = new SelectItem[DataSourceUtil.DATASOURCENAMEMAP.size()];
			int i = 0;
			for(String key: DataSourceUtil.DATASOURCENAMEMAP.keySet()){
				dsitems[i] = new SelectItem(key, DataSourceUtil.DATASOURCENAMEMAP.get(key));
				i++;
			}
		}
		return dsitems;
	}
	
	public Map<String,String> getOrderStatusMap(){
		if(null == orderStatusMap){
			orderStatusMap = new HashMap<String,String>();
			orderStatusMap.put("Y", "充值未成功");
			orderStatusMap.put("S", "充值成功");
		}
		return orderStatusMap;
	}
	
	public SelectItem[] getOrderStatusItems(){
		if(null == orderStatusItems){
			orderStatusItems = new SelectItem[2];
			orderStatusItems[0] = new SelectItem("Y", "充值未成功");
			orderStatusItems[1] = new SelectItem("S", "充值成功");
		}
		return orderStatusItems;
	}
	
	public Map<String,String> getPaytypeMap(){
		if(paytypeMap == null){
			paytypeMap = new HashMap<String,String>();
			paytypeMap.put("B", "网银支付");
			paytypeMap.put("E", "支付宝账户");
			paytypeMap.put("A1", "雷点账户(密码)");
			paytypeMap.put("S", "迅雷支付(一卡通)");
			paytypeMap.put("S1", "迅雷支付(直充)");
			paytypeMap.put("E2", "财付通账户");
			paytypeMap.put("C", "神州行");
			paytypeMap.put("N1", "安全支付");
			paytypeMap.put("N2", "Wap支付");
			paytypeMap.put("W2", "微信Web扫码");
			paytypeMap.put("ES", "支付宝扫码支付");
			paytypeMap.put("B1", "网银快钱支付");
			paytypeMap.put("J2", "捷迅");
			paytypeMap.put("SP", "支付宝极简支付(SDK)");
		}
		return paytypeMap;
	}
	
	public SelectItem[] getPaytypeItems(){
		if( paytypeItems == null){
			paytypeItems = new SelectItem[11];
			paytypeItems[0] = new SelectItem("B", "网银支付");
			paytypeItems[1] = new SelectItem("E", "支付宝账户");
			paytypeItems[2] = new SelectItem("A1", "雷点账户(密码)");
			paytypeItems[3] = new SelectItem("S", "迅雷支付(一卡通)");
			paytypeItems[4] = new SelectItem("S1", "迅雷支付(直充)");
			paytypeItems[5] = new SelectItem("E2", "财付通账户");
			paytypeItems[6] = new SelectItem("C", "神州行");
			paytypeItems[7] = new SelectItem("N1", "安全支付");
			paytypeItems[8] = new SelectItem("N2", "Wap支付");
			paytypeItems[9] = new SelectItem("W2", "微信Web扫码");
			paytypeItems[10] = new SelectItem("ES", "支付宝扫码支付");
			paytypeItems[10] = new SelectItem("B1", "网银快钱支付");
			paytypeItems[10] = new SelectItem("J2", "捷迅");
			paytypeItems[10] = new SelectItem("SP", "支付宝极简支付(SDK)");
		}
		return paytypeItems;
	}
}
