package com.xunlei.niux.manager.web.model.gamepay;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.GiftVipCard;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.PageUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-10-23
 * Time: 下午3:31
 * To change this template use File | Settings | File Templates.
 */
public class GiftVipCardManagedBean extends BaseManagedBean {
    private final Logger logger = Logger.getLogger(this.getClass());

    public String getGiftVipCardList(){
        logger.debug("开始用户返利查询");
        this.authenticateRun();//验证运行权限
        GiftVipCard giftVipCard=this.findBean(GiftVipCard.class,"giftvipcard");
        if(giftVipCard!=null){
            if(giftVipCard.getToEndtime()!=null && StringUtils.isNotEmpty(giftVipCard.getToEndtime())){
                giftVipCard.setToEndtime(giftVipCard.getToEndtime()+" 23:59:59");
            }
            logger.debug("user Rebate Date Record "+giftVipCard.getSeqId());
        }
        PagedFliper pagedFliper =this.getFliper();
        int count= IFacade.INSTANCE.getBaseSo().countObject(giftVipCard);
        List<GiftVipCard> list=new ArrayList<GiftVipCard>();

        if(count>0){
            Page page= PageUtil.formatPage(pagedFliper, "seqId", "desc");
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list=IFacade.INSTANCE.getBaseSo().findObjects(giftVipCard,page);
        }
        Sheet<GiftVipCard> sheet=new Sheet<GiftVipCard>(count,list);
        if(sheet.getRowcount()>0){
            GiftVipCard giftVipCardSum = IFacade.INSTANCE.getBoFactory().getGiftVipCardBo().queryForSum(giftVipCard);
            sheet.getDatas().add(giftVipCardSum);
        }
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

}
