package com.xunlei.niux.manager.web.model.gamepay;

import com.weizhi.common.export.ExportExcelUtil;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.ChargeMonthEnd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@FunRef("chargemonthend")
public class ChargeMonthEndManagedBean extends BaseManagedBean
{
	private static IFacade facade = IFacade.INSTANCE;

	public String getQuery() {
		authenticateRun();
		ChargeMonthEnd query = (ChargeMonthEnd)findBean(ChargeMonthEnd.class, "chargemonthend_query");
		if (query != null) {
			if (isEmpty(query.getFrommonth())) {
				query.setFrommonth(DatetimeUtil.addDate(DatetimeUtil.today(), "M", -1));
			}
			query.setFrommonth(query.getFrommonth().substring(0, 7));
			if (isEmpty(query.getTomonth())) {
				query.setTomonth(DatetimeUtil.today());
			}
			query.setTomonth(query.getTomonth().substring(0, 7));
			query.setDsname("3");
		}
		PagedFliper fliper = getFliper();
		fliper.setPageSize(1000);
		fliper.setSortColumn(" balancemonth desc ");
		Sheet sheet = facade.queryChargeMonthEnd(query, fliper);
		if (sheet.getRowcount() > 0) {
			ChargeMonthEnd sum = facade.queryChargeMonthEndForSum(query);
			sheet.getDatas().add(sum);
		}
		mergePagedDataModel(sheet, new PagedFliper[] { fliper });
		return "";
	}

	public String exportToExcel() {
		authenticateRun();
		ChargeMonthEnd query = (ChargeMonthEnd)findBean(ChargeMonthEnd.class, "chargemonthend_query");
		if (query != null) {
			if (isEmpty(query.getFrommonth())) {
				query.setFrommonth(DatetimeUtil.addDate(DatetimeUtil.today(), "M", -1));
			}
			query.setFrommonth(query.getFrommonth().substring(0, 7));
			if (isEmpty(query.getTomonth())) {
				query.setTomonth(DatetimeUtil.today());
			}
			query.setTomonth(query.getTomonth().substring(0, 7));
			query.setDsname("3");
		}
		PagedFliper fliper = new PagedFliper();
		fliper.setSortColumn(" balancemonth desc ");
		fliper.setPageSize(10000);
		fliper.setPageNo(1);
		Sheet<ChargeMonthEnd> sheet = facade.queryChargeMonthEnd(query, fliper);

		if (sheet.getRowcount() > 0) {
			ChargeMonthEnd sum = facade.queryChargeMonthEndForSum(query);
			sheet.getDatas().add(sum);
		}
		Map gamesmap = new DbConfigManagedBean().getGamesmap();
		ArrayList list = new ArrayList();
		int i = 0;
		for (ChargeMonthEnd data : sheet.getDatas()) {
			i++;
			System.out.println("i=" + i);
			data.setGameid((String)gamesmap.get(data.getGameid()));
			list.add(data);
		}
		if ((list == null) || (list.size() < 1)) {
			mergePagedDataModel(sheet, new PagedFliper[] { fliper });
			return "";
		}
		String excelPath = getHttpServletRequest().getSession().getServletContext()
				.getRealPath("") + File.separator + "WEB-INF" + File.separator + "download" + File.separator +
				"ChargeMonthEnd.xls";

		File excelFile = new File(excelPath);
		try
		{
			if (excelFile.exists()) {
				excelFile.delete();
				excelFile.createNewFile();
			} else {
				excelFile.createNewFile();
			}

			List listProperties = new ArrayList();
			listProperties.add("balancemonth");
			listProperties.add("gameid");
			listProperties.add("testamt");
			listProperties.add("incomeamt");
			listProperties.add("allamt");
			listProperties.add("giftamt");
			listProperties.add("vouchersMoney");
			listProperties.add("notSuccessMoney");
			listProperties.add("userpayamt");
			ExportExcelUtil.setTitle(new String[] { "月份", "游戏", "测试金额", "营收金额(含返利)", "总金额", "返利金额(不含测试)", "代金券金额", "支付成功充值未成功金额","用户实际支付金额" });
			ExportExcelUtil.setProperties(listProperties);
			ExportExcelUtil.transferModelToExcel(excelFile, list);
			alertJS("导出Excel(" + excelPath + ")文件完成");
		}
		catch (Exception e) {
			alertJS("导出文件出错，错误信息：" + e.getMessage());
		}

		getQuery();
		return "";
	}
}