package com.xunlei.niux.manager.web.model.gamepay;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.ThundercurrencyoutdetailReq;
import com.xunlei.niux.client.paysvr.AccountChangeClient;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@FunRef("chargereq")
public class ChargeManagedBean extends BaseManagedBean {

	private static Logger log = Logger.getLogger(ChargeManagedBean.class);
	private static IFacade facade = IFacade.INSTANCE;
	public String getQuery(){
		log.debug("query...");
        String beforeAccount = findParameter("beforeAccount");
		ThundercurrencyoutdetailReq query = this.findBean(ThundercurrencyoutdetailReq.class, "chargereq_query");
		
		if(null != query){

            if (StringUtils.isEmpty(query.getUserId()) &&
                    StringUtils.isNotEmpty(query.getGameid()) &&
                    StringUtils.isNotEmpty(beforeAccount)) {
                try {
                    String userId = AccountChangeClient.getAfterChangeAccout((new StringBuilder()).append(
                                    "0").append(query.getGameid()).toString(),
                            "200", beforeAccount);
                    query.setAssociateUserId(userId);
                } catch (Exception e) {
                    log.error("AccountChangeClient.getAfterChangeAccout Error",
                            e);
                }
            }

			if(isEmpty(query.getFromOrderTime())){
				query.setFromOrderTime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -1));
			}
			if(isEmpty(query.getToOrderTime())){
				query.setToOrderTime(com.xunlei.common.util.DatetimeUtil.today());
			}
		}
		if(query == null || isEmpty(query.getGameid())){
			query.setGameid("00075");
		}
		PagedFliper fliper = this.getFliper();
		fliper.setSortColumnIfEmpty(" ThunderCurrencyOutTime desc");
		this.mergePagedDataModel(facade.query(query, fliper), fliper);
		log.debug("query end.");
		return "";
	}
}
