package com.xunlei.niux.manager.web.model.gameofficial;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gamepoint.GamePoint;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-11-17.
 */
@FunRef("gamepointinitial")
public class GamePointInitialManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(GamePointInitialManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

    public GamePointInitialManagedBean(){
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }


    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }
    /**
     * 查询抽奖活动
     * @return
     */
    public String getQueryGamePointInitialList(){
        logger.info("开始活动扩展信息查询");
        this.authenticateRun();//验证运行权限
        GamePoint gamePoint = findBean(GamePoint.class, "gamepoint");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(gamePoint);
        pagedFliper.setRecordCount(count);
        List<GamePoint> list = new ArrayList<GamePoint>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(gamePoint, page);
        }
        Sheet<GamePoint> sheet = new Sheet<GamePoint>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    /**
     * 新增抽奖活动
     * @return
     */
    public String add(){
        logger.info("开始活动扩展信息添加");
        GamePoint gamePoint = findBean(GamePoint.class, "gamepoint");
        try{
            if(gamePoint==null){
                logger.info("活动扩展信息为空");
                throw new XLRuntimeException("活动扩展信息为空");
            }
            gamePoint.setInputBy(this.currentUserLogo());
            gamePoint.setInputTime(now());
            baseSo.addObject(gamePoint);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 修改抽奖活动
     * @return
     */
    public String edit(){
        logger.info("开始活动扩展信息修改");
        this.authenticateEdit();//编辑权限
        GamePoint gamePoint = findBean(GamePoint.class, "gamepoint");
        try{
            if(gamePoint==null){
                logger.info("活动扩展信息为空");
                throw new XLRuntimeException("活动扩展信息为空");
            }
            gamePoint.setEditBy(this.currentUserLogo());
            gamePoint.setEditTime(now());
            baseSo.updateObjectById(gamePoint);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 删除抽奖活动
     * @return
     */
    public String delete(){
        logger.info("开始抽奖活动信息删除");
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids)
                baseSo.deleteById(GamePoint.class, id);
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}
