package com.xunlei.niux.manager.web.model.gamebox;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gamebox.GameBoxDownLoadInfo;
import com.xunlei.niux.data.vipgame.vo.tourist.TouristGameWebActivityConfig;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-11-26
 * Time: 下午2:29
 * To change this template use File | Settings | File Templates.
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMEBOXINFO)
public class GameBoxInfoManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(GameBoxInfoManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

    public GameBoxInfoManagedBean(){
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }


    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }
    /**
     * 查询业务信息
     * @return
     */
    public String getQueryGameBoxInfoList(){
        logger.info("开始盒子信息查询");
        this.authenticateRun();//验证运行权限
        GameBoxDownLoadInfo gameBoxDownLoadInfo = findBean(GameBoxDownLoadInfo.class, "gameboxinfo");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(gameBoxDownLoadInfo);
        pagedFliper.setRecordCount(count);
        List<GameBoxDownLoadInfo> list = new ArrayList<GameBoxDownLoadInfo>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(gameBoxDownLoadInfo, page);
        }
        Sheet<GameBoxDownLoadInfo> sheet = new Sheet<GameBoxDownLoadInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    /**
     * 新增业务信息
     * @return
     */
    public String add(){
        logger.info("开始盒子信息添加");
        this.authenticateAdd();//添加权限
        GameBoxDownLoadInfo gameBoxDownLoadInfo = findBean(GameBoxDownLoadInfo.class, "gameboxinfo");
        try{
            if(gameBoxDownLoadInfo==null){
                logger.info("盒子信息为空");
                throw new XLRuntimeException("盒子信息为空");
            }
            gameBoxDownLoadInfo.setInputBy(currentUserLogo());
            gameBoxDownLoadInfo.setInputTime(now());

            baseSo.addObject(gameBoxDownLoadInfo);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 修改业务信息
     * @return
     */
    public String edit(){
        logger.info("开始盒子信息修改");
        this.authenticateEdit();//编辑权限
        GameBoxDownLoadInfo gameBoxDownLoadInfo = findBean(GameBoxDownLoadInfo.class, "gameboxinfo");
        try{
            if(gameBoxDownLoadInfo==null){
                logger.info("盒子信息为空");
                throw new XLRuntimeException("盒子信息为空");
            }
            gameBoxDownLoadInfo.setEditBy(this.currentUserLogo());
            gameBoxDownLoadInfo.setEditTime(now());
            baseSo.updateObjectById(gameBoxDownLoadInfo);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete(){
        logger.info("开始盒子信息删除");
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids)
                baseSo.deleteById(GameBoxDownLoadInfo.class, id);
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}
