package com.xunlei.niux.manager.web.model.game;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.dto.game.CpsGamesDTO;
import com.xunlei.niux.data.vipgame.enums.game.CPSGameSouceType;
import com.xunlei.niux.data.vipgame.enums.game.MobileGameNetType;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CpsGames;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.games.MobileGamePic;
import com.xunlei.niux.manager.template.builder.gameofficial.thread.GameTask;
import com.xunlei.niux.manager.template.builder.gameofficial.thread.ThreadPoolGame;
import com.xunlei.niux.manager.web.client.XiaoMiMobileGameLeadInClient;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.QRCodeUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.util.CollectionUtils;

import javax.faces.model.SelectItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;


/**
 * cps游戏处理类
 * @author lisu
 * 2015-03-11
 */
public class CpsGamesManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CpsGamesManagedBean.class.getName());
	private static  String qcodePath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("qcodePath");	//二维码图片远程存放路径
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//二维码图片本地存放路径
	private static final String SYNCPICCOMMONDPHOTO = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("syncPicCommond");
	private BaseSo baseSo;
    private int rownum = 0;
	private UploadedFile importupfile;
	private static final  int COLUMNSIZE =7;
	private static final int GAMEIDCOUNT  = 6;//默认游戏编号长度
	private static final int MAXROWCount = 100;//玩家个人信息一次最多导入行数
	private static final List<Object> queryList = new ArrayList<Object>();
    private List<SelectItem> allCPSGamesList;
    
	
	public UploadedFile getImportupfile() {
		return importupfile;
	}
	public void setImportupfile(UploadedFile importupfile) {
		this.importupfile = importupfile;
	}
	
	public CpsGamesManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;		

	}
	
     private synchronized long getLongGameId(){
    	 String gameId = getMaxGameId();
    	 return getId(gameId);
     }
     
     
     private String getMaxGameId(){
    	 CpsGames query = new CpsGames();
    	 Page page = new Page();
    	 page.addOrder("gameId", OrderType.DESC);
    	 page.setPageNo(1);
    	 page.setPageSize(1);
    	 List<CpsGames> gamesList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
    	 if(CollectionUtils.isEmpty(gamesList))return"c000001";
    	 return gamesList.get(0).getGameId();
     }
     
     private Long getId(String gameId) {
    	gameId = gameId.substring(1);//截取掉前面的字母
 		for (int i=gameId.length()-1; i>0; i--) {
 			if (gameId.indexOf(getBaseId(i)) != -1) {
 				gameId = gameId.substring(getBaseId(i).length() - 1);
 				return Long.parseLong(gameId);
 			}
 		}
 		return 0L;
 	}

 	private String getBaseId(int i) {
 		StringBuffer sb = new StringBuffer("");
 		for (int j = 0; j < i; j++) {
 			sb.append("0");
 		}
 		return sb.toString();
 	}
     
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 玩家信息导入时文件上传
	 * @return
	 */
	public void importUploadFile(){     
		String filename=null;
		FileInputStream fis = null;
		Workbook wb = null;
		org.apache.poi.ss.usermodel.Sheet sheet = null;
		Row row = null;
		if(importupfile!=null){
			try {
				filename=FileUploadUtil.upLoadFile(importupfile);
				filename = FILEPATH+filename;
                fis = new FileInputStream(new File(filename));
                wb = WorkbookFactory.create(fis);
                sheet = wb.getSheetAt(0);
            	row = sheet.getRow(0);// 得到标题的内容对象。
    			int colNum = row.getPhysicalNumberOfCells(); // 得到标题总列数
    			int rowNum = sheet.getLastRowNum(); // 得到总行数
    			if(colNum!=COLUMNSIZE){
    				alertJS("excel格式不正确");
    				return ;
    			}
    			if(rowNum >MAXROWCount){
    				alertJS("一次最多只能导入"+MAXROWCount+"条记录");
    				return ;
    			}
    			DecimalFormat df = new DecimalFormat("0");  
    			for (int i = 1; i <= rowNum; i++) { // 正文内容应该从第二行开始,第一行为表头的标题
                	 row = sheet.getRow(i);

                    if(row == null){
                        return;
                    }

                	 Cell cell0  = row.getCell(0);
                	 if(cell0 == null)continue;
                	 String gameNo = (cell0.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell0.getNumericCellValue())+"":cell0.getStringCellValue();
                	 if(StringTools.isEmpty(gameNo))continue;
                	 gameNo = gameNo.trim();
                    Cell cell1  = row.getCell(1);
	               	 String gameName = cell1==null?"":((cell1.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell1.getNumericCellValue())+"":cell1.getStringCellValue());
	                 if(!StringTools.isEmpty(gameName)){
	                	 gameName = gameName.trim();
	                 }
                	 Cell cell2  = row.getCell(2);
                	 String downLoadUrl = cell2==null?"":((cell2.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell2.getNumericCellValue())+"":cell2.getStringCellValue());
                     if(!StringTools.isEmpty(downLoadUrl)){
                    	 downLoadUrl = downLoadUrl.trim();
                     }
                     Cell cell3  = row.getCell(3);
                	 String cpsSize =cell3==null?"": ((cell3.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell3.getNumericCellValue())+"":cell3.getStringCellValue());
                     if(!StringTools.isEmpty(cpsSize)){
                    	 cpsSize = cpsSize.trim();
                     }
                     Cell cell4  = row.getCell(4);
                  	 String downloadNum =cell4==null?"": ((cell4.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell4.getNumericCellValue())+"":cell4.getStringCellValue());
                     if(!StringTools.isEmpty(downloadNum)){
                         downloadNum = downloadNum.trim();
                     }
                     Cell cell5  = row.getCell(5);
                     String iconUrl =cell5==null?"": ((cell5.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell5.getNumericCellValue())+"":cell5.getStringCellValue());
                     if(!StringTools.isEmpty(iconUrl)){
                    	 iconUrl = iconUrl.trim();
                     }
                    Cell cell6  = row.getCell(6);
                    String packageName =cell6==null?"": ((cell6.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell6.getNumericCellValue())+"":cell6.getStringCellValue());
                    if(!StringTools.isEmpty(packageName)){
                        packageName = packageName.trim();
                    }
                	 System.out.println("i="+i+",gameNo:"+gameNo+",gameName:"+gameName+",downLoadUrl:"+downLoadUrl+",cpsSize:"+cpsSize+",downloadNum:"
                             +downloadNum+",iconUrl:"+iconUrl+",packageName:"+packageName);

                    int downNum = 10000;
                    if(StringUtils.isNotEmpty(downloadNum)){
                        downNum = Integer.parseInt(downloadNum);
                    }
                    if(StringTools.isEmpty(iconUrl)){
                        iconUrl="http://";
                    }

                    CpsGamesDTO cpsGames = new CpsGamesDTO();
                    cpsGames.setGameNo(gameNo);
                    cpsGames.setGameName(gameName);
                    cpsGames.setDownLoadUrl(downLoadUrl);
                    cpsGames.setDownloadNum(downNum);
                    cpsGames.setIconUrl(iconUrl);
                    cpsGames.setCpsSize(cpsSize);
                    cpsGames.setSourceType(CPSGameSouceType._OTHER);
                    cpsGames.setPackageName(packageName);

                	addCpsGame(cpsGames);
    			}         
			} catch (Exception e) {
				e.printStackTrace();
				alertJS("导入异常："+e.getMessage());
				return;
			}finally{
				try{
					if(fis != null){
						fis.close();
						fis = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
		return ;
	}
	
	private void addCpsGame(CpsGamesDTO inputGames) throws XLRuntimeException{
		CpsGames query = new CpsGames();
        String gameNo = inputGames.getGameNo();
        query.setGameNo(gameNo);
		CpsGames games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(games != null){
            logger.error("gameNo:"+gameNo+",gameName:"+inputGames.getGameName()+"已存在，请不要重复导入");
            return;
//			throw new XLRuntimeException("gameNo:"+gameNo+",gameName:"+inputGames.getGameName()+"已存在，请不要重复导入");
		}

        CpsGames newCpsGames = new CpsGames();
        newCpsGames.setGameNo(gameNo);
        newCpsGames.setGameName(inputGames.getGameName());
        newCpsGames.setGameDesc(inputGames.getGameName());
        newCpsGames.setCpsSize(inputGames.getCpsSize());
        newCpsGames.setDownloadNum(inputGames.getDownloadNum());
        newCpsGames.setDownLoadUrl(inputGames.getDownLoadUrl());
        newCpsGames.setSimpleName(inputGames.getSimpleName());
        newCpsGames.setPackageName(inputGames.getPackageName());
        newCpsGames.setXiaomiappId(inputGames.getXiaomiappId());
        newCpsGames.setIconUrl(inputGames.getIconUrl());
        newCpsGames.setSourceType(inputGames.getSourceType());
        newCpsGames.setSummary(inputGames.getSummary());

        String gameId = "c" + getGameId();
        newCpsGames.setGameId(gameId);
        newCpsGames.setInputBy(this.currentUserLogo());
        newCpsGames.setInputTime(now());
        newCpsGames.setDisplayOrder(200L);
        newCpsGames.setGameFeature(1);
        newCpsGames.setStatus(1);
        newCpsGames.setMobileGameType(MobileGameNetType.NET_GAME);

        newCpsGames.setMulPhotoUrl("");
		FacadeFactory.INSTANCE.getBaseSo().addObject(newCpsGames);

        List<String> picList = inputGames.getPicList();
        if(CollectionUtils.isEmpty(picList)){
            return;
        }

        upsertMobileGamePicList(gameId,picList,0);
	}

    /**
     * 添加或更新截图信息
     * @param gameid
     * @param picList
     * @param updateType 0:insert 1:update
     */
    private void upsertMobileGamePicList(String gameid,List<String> picList,int updateType){

        String pic1="",pic2="",pic3="",pic4="",pic5="";
        int picSize = picList.size();
        if(picSize >=1){
            pic1 = picList.get(0);
        }
        if(picSize >=2){
            pic2 = picList.get(1);
        }
        if(picSize >=3){
            pic3 = picList.get(2);
        }
        if(picSize >=4){
            pic4 = picList.get(3);
        }
        if(picSize >=5){
            pic5 = picList.get(4);
        }

        if(updateType == 0){
            MobileGamePic newMobileGamePic = new MobileGamePic();
            newMobileGamePic.setGameId(gameid);
            newMobileGamePic.setPic1(pic1);
            newMobileGamePic.setPic2(pic2);
            newMobileGamePic.setPic3(pic3);
            newMobileGamePic.setPic4(pic4);
            newMobileGamePic.setPic5(pic5);

            FacadeFactory.INSTANCE.getMobileGamePicBo().addMobileGameScreenPics(newMobileGamePic);
        }else if(updateType == 1){
            MobileGamePic oldGamePic = FacadeFactory.INSTANCE.getMobileGamePicBo().getMobileGameScreenPicsByGameId(gameid);
            if(oldGamePic != null){
                oldGamePic.setPic1(pic1);
                oldGamePic.setPic2(pic2);
                oldGamePic.setPic3(pic3);
                oldGamePic.setPic4(pic4);
                oldGamePic.setPic5(pic5);
                FacadeFactory.INSTANCE.getMobileGamePicBo().updateMobileGameScreenPics(oldGamePic);
                return;
            }

            MobileGamePic newMobileGamePic = new MobileGamePic();
            newMobileGamePic.setGameId(gameid);
            newMobileGamePic.setPic1(pic1);
            newMobileGamePic.setPic2(pic2);
            newMobileGamePic.setPic3(pic3);
            newMobileGamePic.setPic4(pic4);
            newMobileGamePic.setPic5(pic5);

            FacadeFactory.INSTANCE.getMobileGamePicBo().addMobileGameScreenPics(newMobileGamePic);
        }
    }
	
	private String getGameId(){	
		long gameId = getLongGameId()+1;
		String id = String.valueOf(gameId);
		int i = id.length();
		String baseId = getBaseId(GAMEIDCOUNT-i);
		return baseId+id;
	}

	/**
	 * 查询cps游戏
	 * @return
	 */
	public String getQueryCpsGamesList(){		
	    logger.info("开始cps游戏查询");
        this.authenticateRun();//验证运行权限
        CpsGames query = findBean(CpsGames.class, "cpsgames");
        if(query.getSourceType() !=null && query.getSourceType() == -1){
            query.setSourceType(null);
        }
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<CpsGames> list = new ArrayList<CpsGames>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<CpsGames> sheet = new Sheet<CpsGames>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增cps游戏
	 * @return
	 */
	public String add(){
		logger.info("开始cps游戏信息添加");
		this.authenticateAdd();//添加权限
		CpsGames games = findBean(CpsGames.class, "cpsgames");	
		try{
			if(games==null){
				logger.info("cps游戏信息为空");
				throw new XLRuntimeException("cps游戏信息为空");
			}		
			if(games.getGameId().indexOf("c")==-1){
				games.setGameId("c"+games.getGameId());
			}
            CpsGames query = new CpsGames();
            query.setGameId(games.getGameId());
            CpsGames myCpsGames = baseSo.findObject(query);
            if(myCpsGames != null){
            	logger.info("该游戏ID存在");
				throw new XLRuntimeException("该游戏ID存在");
            }
            games.setInputTime(now());
            games.setInputBy(this.currentUserLogo());            
//            String mulPhotoUrl = getMulPhoto(games.getDownLoadUrl(),games.getGameNo(),games.getGameId());
//            games.setMulPhotoUrl(mulPhotoUrl);
			baseSo.addObject(games);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
        addAfterTask(null,true);
		return "";
	}
	
	
	/**
	 * 生成二维码图片
	 * @param content
	 * @return
	 */
	private String getMulPhoto(String content,String gameNo,String gameId){
		String codes [] = qcodePath.split("/");
		String apkcode = codes[codes.length-1];
		String path = FILEPATH+apkcode+"/"+gameId;
		System.out.println("path:"+path);
		 File file = new File(path);
		 if(!file.exists()){
			 file.mkdirs();
		 }
		QRCodeUtil.makeMultiFile(content, gameNo+".png", path, 300, 300);
		synchPhoto();//同步二维码图片
		return qcodePath+gameId+"/"+(gameNo+".png");
	}
	
	public void synchPhoto() {
		try {
			 logger.info("开始同步二维码图片,地址:/usr/local/bin/"+SYNCPICCOMMONDPHOTO);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMONDPHOTO);	
			 logger.info("apk同步成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	}
	
	
	/**
	 * 修改cps游戏信息
	 * @return
	 */
	public String edit(){
		logger.info("开始cps游戏信息修改");
		this.authenticateEdit();//编辑权限
		CpsGames games = findBean(CpsGames.class, "cpsgames");	
		try{
			if(games==null){
				logger.info("cps游戏信息为空");
				throw new XLRuntimeException("cps游戏信息为空");
			}
//			CpsGames query = new CpsGames();
//			 query.setGameId(games.getGameId());
//            CpsGames myCpsGames = baseSo.findObject(query);
//            if(myCpsGames != null){
//            	if(myCpsGames.getSeqId() != games.getSeqId()){
//                	logger.info("该游戏ID存在");
//    				throw new XLRuntimeException("该游戏ID存在");
//            	}
//            }
            games.setEditTime(now());
            games.setEditBy(this.currentUserLogo());
//            String mulPhotoUrl = getMulPhoto(games.getDownLoadUrl(),games.getGameNo(),games.getGameId());
//            games.setMulPhotoUrl(mulPhotoUrl);
			baseSo.updateObjectById(games);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
        addAfterTask(null,true);
		return "";
	}
	
	/**
	 * 删除cps游戏信息
	 * @return
	 */
	public String delete(){
		logger.info("开始cps游戏信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(CpsGames.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
        addAfterTask(null,true);
		return "";
	}


    /**
     * 所有CPS游戏列表
     * @return
     */
    public List<SelectItem> getAllCPSGamesList() {
        if(allCPSGamesList==null){
            CpsGames query = new CpsGames();
            Page page = new Page();
            page.addOrder("simpleName", OrderType.DESC);
            List<CpsGames> gamesList=baseSo.findObjects(query, page);
            List<SelectItem> tempList=new ArrayList<SelectItem>();
            for(CpsGames game:gamesList){
                SelectItem si=new SelectItem();
                si.setLabel(game.getSimpleName()+"-"+game.getGameName());
                si.setValue(game.getGameId());
                tempList.add(si);
            }
            allCPSGamesList=tempList;
        }
        return allCPSGamesList;
    }

    private void addAfterTask(Games game,boolean isAdd){
        //同步渠道
        GameTask task = new GameTask(game,isAdd);
        ThreadPoolGame.getInstance().execute(task);
    }

    public String syncXiaomiMobileGames(){
        logger.info("开始同步小米游戏");
        XiaoMiMobileGameLeadInClient xiaomiClient = new XiaoMiMobileGameLeadInClient();
        List<CpsGamesDTO> cpsGamesList = xiaomiClient.getXiaomiCPSGames();
        if(CollectionUtils.isEmpty(cpsGamesList))
            return "";

        for(CpsGamesDTO cpsGames : cpsGamesList){
            int xiaomiAppId = cpsGames.getXiaomiappId();
            if(xiaomiAppId > 0){
                CpsGames query = new CpsGames();
                query.setXiaomiappId(xiaomiAppId);
                CpsGames games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
                if(games != null){
                    updateXiaoMiMobileGame(games,cpsGames);
                    continue;
                }
            }

            addCpsGame(cpsGames);
        }

        return "";
    }

    private void updateXiaoMiMobileGame(CpsGames oldgame,CpsGamesDTO newGame){
        String gameId = oldgame.getGameId();
        oldgame.setGameName(newGame.getGameName());
        oldgame.setGameNo(newGame.getGameNo());
		oldgame.setSimpleName(newGame.getSimpleName());
        oldgame.setGameDesc(newGame.getGameDesc());
        oldgame.setIconUrl(newGame.getIconUrl());
        oldgame.setDownLoadUrl(newGame.getDownLoadUrl());
        oldgame.setCpsSize(newGame.getCpsSize());
        oldgame.setDownloadNum(newGame.getDownloadNum());
        oldgame.setSourceType(newGame.getSourceType());
        oldgame.setPackageName(newGame.getPackageName());
        oldgame.setXiaomiappId(newGame.getXiaomiappId());
        oldgame.setSummary(newGame.getSummary());

        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(oldgame);

        List<String> picList = newGame.getPicList();
        if(CollectionUtils.isEmpty(picList))
            return;

        upsertMobileGamePicList(gameId,picList,1);
    }
	
}
