package com.xunlei.niux.manager.web.model.expressinfo;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityExtendInfo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.expressinfo.ProductExpressInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-4-2.
 */
public class ProductExpressInfoManagedBean extends BaseManagedBean{

    private int rownum = 0;
    private BaseSo baseSo;

    public ProductExpressInfoManagedBean() {
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQueryProductExpressList(){

        logger.info("开始快递信息查询");
        this.authenticateRun();//验证运行权限
        ProductExpressInfo productExpressInfo = findBean(ProductExpressInfo.class, "productexpressinfo");
        if(productExpressInfo.getUserId()!=null && productExpressInfo.getUserId()==0){
            productExpressInfo.setUserId(null);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(productExpressInfo);
        pagedFliper.setRecordCount(count);
        List<ProductExpressInfo> list = new ArrayList<ProductExpressInfo>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(productExpressInfo, page);
        }
        Sheet<ProductExpressInfo> sheet = new Sheet<ProductExpressInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add(){
        logger.info("开始快递信息添加");
        ProductExpressInfo productExpressInfo = findBean(ProductExpressInfo.class, "productexpressinfo");
        try{
            if(productExpressInfo==null){
                logger.info("快递信息为空");
                throw new XLRuntimeException("快递信息为空");
            }
            productExpressInfo.setInputBy(this.currentUserLogo());
            productExpressInfo.setInputTime(now());
            baseSo.addObject(productExpressInfo);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 修改抽奖活动
     * @return
     */
    public String edit(){
        logger.info("开始快递信息修改");
        this.authenticateEdit();//编辑权限
        ProductExpressInfo productExpressInfo = findBean(ProductExpressInfo.class, "productexpressinfo");
        try{
            if(productExpressInfo==null){
                logger.info("快递信息为空");
                throw new XLRuntimeException("快递信息为空");
            }
            productExpressInfo.setEditBy(this.currentUserLogo());
            productExpressInfo.setEditTime(now());
            baseSo.updateObjectById(productExpressInfo);
        }catch(Exception e){
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 删除抽奖活动
     * @return
     */
    public String delete(){
        logger.info("开始抽奖活动信息删除");
        this.authenticateDel();//删除权限
        String delseqids = findParameter("delseqids");
        try{
            String ids[] = delseqids.split(",");
            for(String id:ids)
                baseSo.deleteById(ActivityExtendInfo.class, id);
        }catch(Exception e){
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }


}
