package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.dto.vic.SmsSendApplyDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.vic.RebateReportOldGameConfig;
import com.xunlei.niux.data.vipgame.vo.vic.SmsSendApply;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.thread.RebateThreadPool;
import com.xunlei.niux.manager.web.model.thread.SmsSendApplyTask;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class SmsSendApplyManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(SmsSendApplyManagedBean.class.getName());


    public String getQuerySmsSendApply() throws Exception {
        this.authenticateRun();//验证运行权限
        PagedFliper pagedFliper = this.getFliper();
        int count = 5;
//        int count = FacadeFactory.INSTANCE.getSmsSendApplyBo().countSmsSendApply();
        pagedFliper.setRecordCount(count);
        List<SmsSendApplyDTO> list = new ArrayList<SmsSendApplyDTO>();
        if (count > 0) {
            int pageNo = pagedFliper.getPageNo();
            int pageSize = pagedFliper.getPageSize();
            list = FacadeFactory.INSTANCE.getSmsSendApplyBo().querySmsSendApply((pageNo-1)*pageSize, pageSize);
        }
        Sheet<SmsSendApplyDTO> sheet = new Sheet<SmsSendApplyDTO>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String doPass() throws Exception {
        this.authenticateRun();//验证运行权限
        try{
            Long sid = findParamLong("one_sid");
            SmsSendApply query = new SmsSendApply();
            query.setSid(sid);
            if(FacadeFactory.INSTANCE.getBaseSo().findObject(query)==null){
                throw new XLRuntimeException("找不到该单号");
            }
            Integer isPass = findParamInt("one_ispass");
            FacadeFactory.INSTANCE.getSmsSendApplyBo().pass(sid,this.currentUserInfo().getTrueName(),isPass);
            if(isPass==1){
                RebateThreadPool.getInstance().execute(new SmsSendApplyTask(sid));
            }
        }catch (Exception e){
            logger.error("操作失败",e);
            mergeJsmessage("操作失败，"+e.getMessage());
        }
        return "";
    }

}
