package com.xunlei.niux.manager.web.model.customer;

import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CustomerQueryUtil {
    protected static Log logger = LogFactory.getLog(CustomerQueryUtil.class);
    private final static String URL="http://dq2.niu.xunlei.com/";
    private final static String URL_TAG="http://tw07598.sandai.net:8080/es/niux_plat/user_tags/%d?_source_exclude=login_tags.latelylately7dayday_logintimequantum&pretty";

    /**
     * VIP状态
     * 0未流失 1已流失
     */
    public static Integer vipStatus(Long uid){
        int log = loginStatus(uid);
        int pay = payStatus(uid);
        if(log==0&&pay==0){
            return 0;
        }
        else if (log==-1 || pay == -1){
            return -1;
        }
        else{
            return 1;
        }
    }
    /**
     * 登陆天数 1活跃 2一般 3不稳定 0无
     * 过去7天内上线天数≥6天为活跃；上线天数<6天但≥3天为一般；上线天数<3天但≥1天为不稳定
     */
    public static Integer loginDays7(Long uid){
        try {
            String acc = "act/getLoginDays?userId=%d&from=%s&to=%s";
            String resp = getDate(String.format(acc,uid,pass7(),today()));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return -1;
            JSONObject jsonData = json.getJSONObject("data");
            JSONArray array = jsonData.getJSONArray("days");
            int days = array.length();
            if(days>=6){
                return 1;
            }else if(days<6 && days >=3){
                return 2;
            }else if(days<3 && days>=1){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return 0;
    }
    /**
     * 在线时长 1痴迷 2沉迷 3入门
     * 每天在线时间≥8小时为痴迷；在线时间<8小时但≥3小时为沉迷；在线时间<3小时为入门；过去7天中有登录的天数的在线时间总和除登录天数
     */
    public static String onlineTime(Long uid){
//        try {
//            String acc = "act/getLoginDays?userId=%d&from=%s&to=%s";
//            String resp = getDate(String.format(acc,uid,pass7(),today()));
//            JSONObject json = new JSONObject(resp);
//            JSONObject jsonData = json.getJSONObject("data");
//            JSONArray array = jsonData.getJSONArray("days");
//            int days = array.length();
//            if(days>=6){
//                return 1;
//            }else if(days<6 && days >=3){
//                return 2;
//            }else if(days<3 && days>=1){
//                return 3;
//            }
//        }catch (Exception e){
//            logger.error(e);
//        }
        return "-";
    }
    /**
     * 登陆时间
     * 当天首次上线时间在AM6:00~AM11:59为早；PM12:00~PM5:59为中；PM6:00~PM21:59为晚；PM22:00~AM5:59为凌晨；取过去7天中在某一时间段登陆次数最多自动判定为该标签
     */
    public static String loginTime(Long uid){
        return "-";
    }
    /**
     * 7天充值维度 1重点关注 2持续关注 3待关注
     * 7天内累计充值金额≥5000为重点关注；累计<5000但≥1000为持续关注；累计<1000为待关注
     */
    public static Integer payVd7(Long uid){
        try {
            String acc = "act/getPeriodPayAmount?userId=%d&from=%s&to=%s";
            String resp = getDate(String.format(acc,uid,pass7(),today()));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return -1;
            JSONObject jsonData = json.getJSONObject("data");
            double amount = jsonData.getDouble("amount");
            if(amount>=5000){
                return 1;
            }else if(amount<5000 && amount >=1000){
                return 2;
            }else if(amount<1000 ){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }
    /**
     * 7天最高单笔
     */
    public static String payHighest7(Long uid){
        return "-";
    }

    /**
     * 7天平均充值
     */
    public static String payAvg7(Long uid){
        try {
            String acc = "act/getPeriodPayAmount?userId=%d&from=%s&to=%s";
            String resp = getDate(String.format(acc,uid,pass7(),today()));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return "-1";
            JSONObject jsonData = json.getJSONObject("data");
            double amount = jsonData.getDouble("amount");
            BigDecimal bd = new BigDecimal(amount);
            return bd.divide(new BigDecimal(7), 2, BigDecimal.ROUND_HALF_UP).toString();
        }catch (Exception e){
            logger.error(e);
        }
        return "0";
    }

    /**
     * 登陆状态 0未流失 1已流失
     * 未登录≥3天为不玩了
     */
    public static Integer loginStatus(Long uid){
        try {
            String acc = "act/getLastTime?userId=%d";
            String resp = getDate(String.format(acc,uid));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return -1;
            JSONObject jsonData = json.getJSONObject("data");
            String lastLoginTime = jsonData.getString("lastLoginTime");
            long day = DateUtil.compareTime(lastLoginTime,today2());
            if(day>=3){
                return 1;
            }else{
                return 0;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }
    /**
     * 充值状态 0未流失 1已流失
     * 未充值≥7天为流逝
     */
    public static Integer payStatus(Long uid){
        try {
            String acc = "act/getLastPayTime?userId=%d";
            String resp = getDate(String.format(acc,uid));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return -1;
            JSONObject jsonData = json.getJSONObject("data");
            String lastPayTime = jsonData.getString("lastPayTime");
            long day = DateUtil.compareTime(lastPayTime,today2());
            if(day>=7){
                return 1;
            }else{
                return 0;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }
    /**
     * 充值频率
     * 7天内充值次数≥6次为频繁；充值次数<6次但≥3次为适中；充值次数<3次但≥1次为节制（当天充值记为一次）
     * 1频繁 2适中 3节制 0无
     */
    public static Integer payRate(Long uid){
        try {
            String acc = "act/getPeriodPayTimes?userId=%d&from=%s&to=%s";
            String resp = getDate(String.format(acc,uid,pass7(),today()));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return -1;
            JSONObject jsonData = json.getJSONObject("data");
            Integer times = jsonData.getInt("times");
            if(times>=6){
                return 1;
            }else if(times<6&&times>=3){
                return 2;
            }else if(times<3 && times>=1){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return 0;
    }
    /**
     * 新付费用户
     * 账号首次付费时间≥30为新付费用户
     * 0否 1是
     */
    public static Integer isNew(Long uid){
        try {
            String acc = "act/getFirstPayTime?userId=%d";
            String resp = getDate(String.format(acc,uid));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return -1;
            JSONObject jsonData = json.getJSONObject("data");
            String firstPayTime = jsonData.getString("firstPayTime");
            long day = DateUtil.compareTime(firstPayTime, today2());
            if(day>=30){
                return 1;
            }else {
                return 0;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }
    /**
     * 30天充值维度
     * 30天内累计充值金额≥20000为大R；累计<20000但≥5000为中R；累计<5000为小R
     * 1大R 2中R 3小R
     */
    public static Integer payVd30(Long uid){
        try {
            String acc = "act/getPeriodPayAmount?userId=%d&from=%s&to=%s";
            String resp = getDate(String.format(acc,uid,pass30(),today()));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return -1;
            JSONObject jsonData = json.getJSONObject("data");
            double amount = jsonData.getDouble("amount");
            if(amount>=20000){
                return 1;
            }else if(amount<20000 && amount >=5000){
                return 2;
            }else if(amount<5000 ){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }
    /**
     * 30天最高单笔
     */
    public static String payHighest30(Long uid){
        return "-";
    }
    /**
     * 30天平均充值
     */
    public static String payAvg30(Long uid){
        try {
            String acc = "act/getPeriodPayAmount?userId=%d&from=%s&to=%s";
            String resp = getDate(String.format(acc,uid,pass30(),today()));
            JSONObject json = new JSONObject(resp);
            if(!"0".equals(json.getString("rtn")))return "-1";
            JSONObject jsonData = json.getJSONObject("data");
            double amount = jsonData.getDouble("amount");
            BigDecimal bd = new BigDecimal(amount);
            return bd.divide(new BigDecimal(30), 2, BigDecimal.ROUND_HALF_UP).toString();
        }catch (Exception e){
            logger.error(e);
        }
        return "-1";
    }
    
    /**
     * 
     */
    public static JSONObject queryTags(Long uid){
    	JSONObject jsonData = null;
    	try {
    		String url = String.format(URL_TAG,uid);
    		String resp = HttpClientUtil.get(url);
    		logger.info("[queryTags],url:"+url+",resp:"+resp);
    		JSONObject json = new JSONObject(resp);
    		if(!"true".equals(json.getString("found")))return jsonData;
    		jsonData = json.getJSONObject("_source");
    		return jsonData;
    	}catch (Exception e){
    		logger.error(e);
    	}
    	return jsonData;
    }
    

    /**
     * 登陆天数 1活跃 2一般 3不稳定 0无
     * 过去7天内上线天数≥6天为活跃；上线天数<6天但≥3天为一般；上线天数<3天但≥1天为不稳定
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer loginDays7_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return 0;
    	}
    	
        try {
            int days = jsonData.getJSONObject("login_tags").getInt("lately7day_logindays");
            if(days>=6){
                return 1;
            }else if(days<6 && days >=3){
                return 2;
            }else if(days<3 && days>=1){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return 0;
    }

    /**
     * 在线时长 1痴迷 2沉迷 3入门
     * 每天在线时间≥8小时为痴迷；在线时间<8小时但≥3小时为沉迷；在线时间<3小时为入门；过去7天中有登录的天数的在线时间总和除登录天数 
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer onlineTime_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return 0;
    	}
    	
        try {
            double days = jsonData.getJSONObject("login_tags").getDouble("lately7day_dayavghour");
            if(days>=6){
                return 1;
            }else if(days<6 && days >=3){
                return 2;
            }else if(days<3 && days>=1){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return 0;
    }
    
    /**
     * 登陆时间
     * 当天首次上线时间在AM6:00~AM11:59为早；PM12:00~PM5:59为中；PM6:00~PM21:59为晚；PM22:00~AM5:59为凌晨；取过去7天中在某一时间段登陆次数最多自动判定为该标签
     *
     * V2版本，一次性查询再判断
     */
    public static Integer loginTime_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return 0;
    	}
    	
    	try {
    		JSONObject json = jsonData.getJSONObject("login_tags").getJSONObject("lately7day_logintimequantum");
    		int hour_6_11 = 0;//早
    		int hour_12_17 = 0;//中
    		int hour_18_23 = 0;//晚
    		int hour_0_5 = 0;//凌晨
    		try{
    			hour_6_11 = json.getInt("hour_6_11");
    		}catch(Exception e){
        		logger.error(e);
    		}
    		
    		try{
    			hour_12_17 = json.getInt("hour_12_17");
    		}catch(Exception e){
        		logger.error(e);
    		}
    		
    		try{
    			hour_18_23 = json.getInt("hour_18_23");
    		}catch(Exception e){
        		logger.error(e);
    		}
    		
    		try{
    			hour_0_5 = json.getInt("hour_0_5");
    		}catch(Exception e){
        		logger.error(e);
    		}
    		
    		if(hour_6_11 >= hour_12_17 && hour_6_11 >= hour_18_23 && hour_6_11 >= hour_0_5 ){
    			return 1;
    		}else if(hour_12_17 >= hour_6_11 && hour_12_17 >= hour_18_23 && hour_12_17 >= hour_0_5 ){
    			return 2;
    		}else if(hour_18_23 >= hour_6_11 && hour_18_23 >= hour_12_17 && hour_18_23 >= hour_0_5 ){
    			return 3;
    		}else if(hour_0_5 >= hour_6_11 && hour_0_5 >= hour_12_17 && hour_0_5 >= hour_18_23 ){
    			return 4;
    		}
    	}catch (Exception e){
    		logger.error(e);
    	}
    	return 0;
    }
    
    /**
     * 7天充值维度 1重点关注 2持续关注 3待关注
     * 7天内累计充值金额≥5000为重点关注；累计<5000但≥1000为持续关注；累计<1000为待关注
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer payVd7_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return -1;
    	}
    	
    	try {
            double amount = jsonData.getJSONObject("pay_tags").getDouble("lately7day_payamount");
            if(amount>=5000){
                return 1;
            }else if(amount<5000 && amount >=1000){
                return 2;
            }else if(amount<1000 ){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }
    

    /**
     * 7天最高单笔
     * 
     * V2版本，一次性查询再判断
     */
    public static Double payHighest7_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return 0.0D;
    	}
    	
    	try {
            double amount = jsonData.getJSONObject("pay_tags").getDouble("lately7day_highestpay");
            return amount;
        }catch (Exception e){
            logger.error(e);
        }
        return 0.0D;
    }

    /**
     * 7天平均充值
     * 
     * V2版本，一次性查询再判断
     */
    public static String payAvg7_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return "0.0";
    	}
    	
    	try {
            double amount = jsonData.getJSONObject("pay_tags").getDouble("lately7day_payamount");
            BigDecimal bd = new BigDecimal(amount);
            return bd.divide(new BigDecimal(7), 2, BigDecimal.ROUND_HALF_UP).toString();
        }catch (Exception e){
            logger.error(e);
        }
        return "0.0";
    }

    /**
     * VIP状态
     * 0未流失 1已流失
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer vipStatus_v2(JSONObject jsonData){
        int log = loginStatus_v2(jsonData);
        int pay = payStatus_v2(jsonData);
        if(log==0&&pay==0){
            return 0;
        }
        else if (log==-1 || pay == -1){
            return -1;
        }
        else{
            return 1;
        }
    }
    
    /**
     * 登陆状态 0未流失 1已流失
     * 未登录≥3天为不玩了
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer loginStatus_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return -1;
    	}
    	
    	try {
            String lastLoginTime = jsonData.getJSONObject("login_tags").getString("last_logindate");
            long day = DateUtil.compareTime(lastLoginTime,today2());
            if(day>=3){
                return 1;
            }else{
                return 0;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }
    
    /**
     * 充值状态 0未流失 1已流失
     * 未充值≥7天为流逝
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer payStatus_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return -1;
    	}
    	
    	try {
            String lastPayTime = jsonData.getJSONObject("pay_tags").getString("last_paydate");
            long day = DateUtil.compareTime(lastPayTime,today2());
            if(day>=7){
                return 1;
            }else{
                return 0;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }

    /**
     * 充值频率
     * 7天内充值次数≥6次为频繁；充值次数<6次但≥3次为适中；充值次数<3次但≥1次为节制（当天充值记为一次）
     * 1频繁 2适中 3节制 0无
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer payRate_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return 0;
    	}
    	
    	try {
    		Integer times = jsonData.getJSONObject("pay_tags").getInt("lately7day_paytimes");
            if(times>=6){
                return 1;
            }else if(times<6&&times>=3){
                return 2;
            }else if(times<3 && times>=1){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return 0;
    }

    /**
     * 新付费用户
     * 账号首次付费时间≥30为新付费用户
     * 0否 1是
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer isNew_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return -1;
    	}
    	
    	try {
            String firstPayTime = jsonData.getJSONObject("pay_tags").getString("first_paydate");
            long day = DateUtil.compareTime(firstPayTime, today2());
            if(day>=30){
                return 1;
            }else {
                return 0;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }

    /**
     * 30天充值维度
     * 30天内累计充值金额≥20000为大R；累计<20000但≥5000为中R；累计<5000为小R
     * 1大R 2中R 3小R
     * 
     * V2版本，一次性查询再判断
     */
    public static Integer payVd30_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return -1;
    	}
    	
    	try {
            double amount = jsonData.getJSONObject("pay_tags").getDouble("lately30day_payamount");
            if(amount>=20000){
                return 1;
            }else if(amount<20000 && amount >=5000){
                return 2;
            }else if(amount<5000 ){
                return 3;
            }
        }catch (Exception e){
            logger.error(e);
        }
        return -1;
    }

    /**
     * 30天最高单笔
     * 
     * V2版本，一次性查询再判断
     */
    public static Double payHighest30_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return 0.0D;
    	}
    	
    	try {
            return jsonData.getJSONObject("pay_tags").getDouble("lately30day_highestpay");
        }catch (Exception e){
            logger.error(e);
        }
        return 0.0D;
    }

    /**
     * 30天平均充值
     * 
     * V2版本，一次性查询再判断
     */
    public static String payAvg30_v2(JSONObject jsonData){
    	if(jsonData == null){
    		return "0.0";
    	}
    	
    	try {
            double amount = jsonData.getJSONObject("pay_tags").getDouble("lately30day_payamount");
            BigDecimal bd = new BigDecimal(amount);
            return bd.divide(new BigDecimal(30), 2, BigDecimal.ROUND_HALF_UP).toString();
        }catch (Exception e){
            logger.error(e);
        }
        return "0.0";
    }
    
    private static String today(){
        return DateUtil.formatNow("yyyyMMdd");
    }
    private static String today2(){
        return DateUtil.formatNow("yyyy-MM-dd");
    }

    private static String pass7(){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DATE,-7);
        return DateUtil.format(calendar.getTime(),"yyyyMMdd");
    }
    private static String pass30(){
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DATE,-30);
        return DateUtil.format(calendar.getTime(),"yyyyMMdd");
    }

    private static String getDate(String acc){
        System.out.println("~~~"+URL+acc);
        String r= HttpClientUtil.get(URL+acc);
        System.out.println("~~~#"+r);
        return r;
    }


}
