package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.PayDetailOK;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.vipgame.dto.SmsRecordDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.*;
import com.xunlei.niux.data.vipgame.vo.vic.*;
import com.xunlei.niux.data.vipgame.vo.customer.CustomerGift;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.proxy.BigDataDqProxy;
import com.xunlei.niux.manager.web.proxy.GameUserInfoProxy;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;
import com.xunlei.server.common.exception.XLException;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 客户查询业务处理类
 */
public class CustomerQueryManagedBean extends BaseManagedBean {

    private Long sessionUid;
    private Map<String,Object> basicInfoMap = new HashMap<String, Object>();
    private PersonInfo personInfo = new PersonInfo();
    private CustomizeTags customizeTags = new CustomizeTags();
    private Map<String,Object> uidTagsMap = new HashMap<String, Object>();
    private List<Treatment> treatmentsList = new ArrayList<Treatment>();
    private List<PayDetailOK> payDetailOKList = new ArrayList<PayDetailOK>();
    private List<CallRecord> callRecordList = new ArrayList<CallRecord>();
    private List<RebateApply> rebateApplyList = new ArrayList<RebateApply>();
    private List<CustomerGift> customerGiftList = new ArrayList<CustomerGift>();
    private List<SmsRecordDTO> smsApplyList = new ArrayList<SmsRecordDTO>();
    private RebatePlan rebatePlanForGame = new RebatePlan();

	public CustomerQueryManagedBean(){
	}


    public String cleanSession(){
        sessionUid = 0L;
        basicInfoMap.clear();
        personInfo = new PersonInfo();
        customizeTags = new CustomizeTags();
        uidTagsMap.clear();
        treatmentsList.clear();
        payDetailOKList.clear();
        callRecordList.clear();
        rebateApplyList.clear();
        customerGiftList.clear();
        smsApplyList.clear();
        rebatePlanForGame = new RebatePlan();
        return "";
    }

    /**
     * 基本信息
     */
    public String queryBasicInfo(){
        try {
            basicInfoMap.clear();
            Long uid = getUid();
            if(uid==0)return "";
            String account = getAccount(uid);
            String registerdate = getUserInfoSec(uid+"").getRegisterdate();
            Long jinzuanDays = getDaysOfJinZuan(uid);

            //暂时使用老的逻辑 customerdetailquery：VIP等级，最后登陆时间，最后充值时间，充值总金额，最后充值游戏，最后外呼时间，专属经理，最后充值游戏
            CustomerDetailQuery cdq = getCdq(uid);
            if(cdq==null)return "";

            int loginStatus = diffNow(cdq.getLastLoginTime())<-3?2:1;
            int payStatus = diffNow(cdq.getLastPayTime())<-7?2:1;
            int vipStatus = 1;
            if(loginStatus==2&&payStatus==2){
                vipStatus=2;
            }

            String firstPayTime = BigDataDqProxy.getFirstPayTime(uid);

            //最高充值金额

            basicInfoMap.put("uid", uid);
            basicInfoMap.put("account", account);
            basicInfoMap.put("registerdate", registerdate);
            basicInfoMap.put("jinzuanDays", jinzuanDays);
            basicInfoMap.put("vipGrade", cdq.getVipGrade());
            basicInfoMap.put("vipStatus", vipStatus);
            basicInfoMap.put("loginStatus", loginStatus);
            basicInfoMap.put("payStatus", payStatus);
            basicInfoMap.put("livePayTotalAmt", cdq.getLivePayTotalAmt());
            basicInfoMap.put("firstPayTime", firstPayTime);
            basicInfoMap.put("lastPayTime", cdq.getLastPayTime());
            basicInfoMap.put("lastLoginTime", cdq.getLastLoginTime());
            basicInfoMap.put("biggestPay", "-");
            basicInfoMap.put("lastCallTime", cdq.getLastCallTime());
            basicInfoMap.put("lastCaller", cdq.getLastCaller());
            basicInfoMap.put("customerService", cdq.getCustomerService());
            basicInfoMap.put("payGameId", cdq.getPayGameId());
            

            PayDetailOK queryPay = new PayDetailOK();
            queryPay.setToinneruserid(String.valueOf(uid));
            queryPay.setDsname("3");
            PayDetailOK sumPay = IFacade.INSTANCE.findMaxPayDetailOK(queryPay);
            basicInfoMap.put("biggestPay", sumPay.getTotalmoney());
        }catch (Exception e){
            logger.error("queryBasicInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }



    /**
     * 玩家个人信息
     */
    public String queryPersonInfo(){
        try {
            Long uid = useSessionUid();
            personInfo = new PersonInfo();
            PersonInfo queryPi = new PersonInfo();
            queryPi.setUid(uid);
            PersonInfo p = FacadeFactory.INSTANCE.getBaseSo().findObject(queryPi);

            if(p!=null && StringUtils.isNotEmpty(p.getMobileNumber()) && StringUtils.isNotEmpty(p.getQqNumber())){
                personInfo=p;
                return "";
            }

            if(p==null){
                p = new PersonInfo();
            }

            //兼容老数据
            CustomerInfo query = new CustomerInfo();
            query.setUid(uid+"");
            CustomerDetailQuery query1 = new CustomerDetailQuery();
            query1.setUid(uid+"");
            CustomerInfo ci = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            CustomerDetailQuery cdq = FacadeFactory.INSTANCE.getBaseSo().findObject(query1);
            if(cdq==null)return "";
            if(ci==null){
                p.setMobileNumber(cdq.getContactNumber());
                p.setQqNumber(cdq.getQq());
            }else{
                if(StringUtils.isNotEmpty(ci.getPhone())){
                    p.setMobileNumber(ci.getPhone());
                }else {
                    p.setMobileNumber(cdq.getContactNumber());
                }
                if(StringUtils.isNotEmpty(ci.getQq())){
                    p.setQqNumber(ci.getQq());
                }else {
                    p.setQqNumber(cdq.getQq());
                }
                p.setRealName(ci.getUsername());
                p.setSex(ci.getSex());
                p.setAge(ci.getAge());
                p.setBirthday(ci.getBirthday());
                p.setAddress(ci.getAddress());
                p.setDegree(ci.getDegree());
                p.setJob(ci.getProfession());
                p.setAnnualSalary(ci.getAnnualSalary());
                p.setPlaceCity(ci.getArea());
                p.setFamily(ci.getFamily());
                p.setLostPay(ci.getLostPay());
                p.setLostLogin(ci.getLostLogin());
            }

            personInfo=p;
        }catch (Exception e){
            logger.error("queryPersonInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * 自定义标签
     */
    public String queryCustomizeTagsInfo(){
        try {
            Long uid = useSessionUid();
            customizeTags = new CustomizeTags();
            CustomizeTags query = new CustomizeTags();
            query.setUid(uid);
            CustomizeTags result = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(result!=null)customizeTags = result;
        }catch (Exception e){
            logger.error("queryCustomizeTagsInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * 玩家标签
     */
    public String queryUidTagsInfo(){
        try {
            Long uid = useSessionUid();
            uidTagsMap.clear();
            JSONObject jsonData = CustomerQueryUtil.queryTags(uid);
            uidTagsMap.put("vipstatus", CustomerQueryUtil.vipStatus_v2(jsonData));
            uidTagsMap.put("logindays", CustomerQueryUtil.loginDays7_v2(jsonData));
            uidTagsMap.put("onlinetime", CustomerQueryUtil.onlineTime_v2(jsonData));
            uidTagsMap.put("logintime", CustomerQueryUtil.loginTime_v2(jsonData));
            uidTagsMap.put("payvd7", CustomerQueryUtil.payVd7_v2(jsonData));
            uidTagsMap.put("payhighest7", CustomerQueryUtil.payHighest7_v2(jsonData));
            uidTagsMap.put("payavg7", CustomerQueryUtil.payAvg7_v2(jsonData));
            uidTagsMap.put("loginstatus", CustomerQueryUtil.loginStatus_v2(jsonData));
            uidTagsMap.put("paystatus", CustomerQueryUtil.payStatus_v2(jsonData));
            uidTagsMap.put("payrate", CustomerQueryUtil.payRate_v2(jsonData));
            uidTagsMap.put("isnew", CustomerQueryUtil.isNew_v2(jsonData));
            uidTagsMap.put("payvd30", CustomerQueryUtil.payVd30_v2(jsonData));
            uidTagsMap.put("payhighest30", CustomerQueryUtil.payHighest30_v2(jsonData));
            uidTagsMap.put("payavg30", CustomerQueryUtil.payAvg30_v2(jsonData));
        }catch (Exception e){
            logger.error("queryCustomizeTagsInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * 充值概况
     */
    public String queryPayInfo(){
        try {
            Long uid = useSessionUid();
            payDetailOKList.clear();
            rebatePlanForGame = new RebatePlan();
            PayDetailOK query = new PayDetailOK();
            query.setFrominneruserid(uid + "");
            query.setDsname("3");
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(5);
            page.addOrder("successtime", OrderType.DESC);
            PagedFliper fliper = new PagedFliper();
            fliper.setSortColumn(" successtime desc ");
            fliper.setPageNo(1);
            fliper.setPageSize(5);
            com.xunlei.common.util.Sheet<PayDetailOK> sheet = IFacade.INSTANCE.queryPayDetailOK(query,fliper);
            if(com.xunlei.common.util.Sheet.EMPTY==sheet){
                return "";
            }
            payDetailOKList = new ArrayList<PayDetailOK>(sheet.getDatas());
            for(PayDetailOK pdo:payDetailOKList){
                pdo.setGameid("0"+pdo.getGameid());
            }

            if(payDetailOKList!=null && payDetailOKList.size()>0 && StringUtils.isNotEmpty(payDetailOKList.get(0).getGameid())){
                queryRebatePlanByGameId(payDetailOKList.get(0).getGameid());
            }
        }catch (Exception e){
            logger.error("queryPayInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }


    /**
     * 方案查询
     */
    private String queryRebatePlanByGameId(String gameid){
        try {
            rebatePlanForGame = new RebatePlan();
            if(StringUtils.isEmpty(gameid))return "";
            RebatePlan query = new RebatePlan();
            query.setGameid(gameid);
            RebatePlan  result = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(result!=null)rebatePlanForGame = result;
        }catch (Exception e){
            logger.error("queryRebatePlanByGameId Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }


    /**
     * 重要问题处理
     */
    public String queryTreatmentInfo(){
        try {
            Long uid = useSessionUid();
            treatmentsList.clear();
            Treatment query = new Treatment();
            query.setUid(uid);
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(5);
            page.addOrder("inputTime", OrderType.DESC);
            treatmentsList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
        }catch (Exception e){
            logger.error("queryTreatmentInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * 外呼记录
     */
    public String queryCallInfo(){
        try {
            Long uid = useSessionUid();
            callRecordList.clear();
            CallRecord query = new CallRecord();
            query.setUid(uid+"");
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(5);
            page.addOrder("callTime", OrderType.DESC);
            callRecordList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
        }catch (Exception e){
            logger.error("queryCallInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * 短信发送记录
     */
    public String queryMsgInfo(){
        try {
            Long uid = useSessionUid();
            smsApplyList.clear();
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(5);
            page.addOrder("applyTime", OrderType.DESC);
            smsApplyList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getSmsSendApplyBo().getUidSmsRecord(uid);
        }catch (Exception e){
            logger.error("queryMsgInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * 返利申请记录
     */
    public String queryRebateRInfo(){
        try {
            Long uid = useSessionUid();
            rebateApplyList.clear();
            RebateApply query = new RebateApply();
            query.setUid(uid+"");
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(5);
            page.addOrder("applyTime", OrderType.DESC);
            rebateApplyList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
        }catch (Exception e){
            logger.error("queryRebateRInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * 礼包发放记录
     */
    public String queryGiftInfo(){
        try {
            Long uid = useSessionUid();
            customerGiftList.clear();
            CustomerGift query = new CustomerGift();
            query.setUserId(uid+"");
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(5);
            page.addOrder("inputTime", OrderType.DESC);
            customerGiftList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
        }catch (Exception e){
            logger.error("queryGiftInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * 个人信息更新
     */
    public String updatePersonInfo(){
        try {
            Long uid = useSessionUid();
            PersonInfo query = new PersonInfo();
            query.setUid(uid);
            if(FacadeFactory.INSTANCE.getBaseSo().findObject(query)==null){
                PersonInfo newpi = getPersonInfo();
                newpi.setUid(uid);
                FacadeFactory.INSTANCE.getBaseSo().addObject(newpi);
            }else {
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(getPersonInfo());
            }

            //update to cdq and ci
            updateCdqNCi(getPersonInfo(),uid+"");

            queryPersonInfo();
        }catch (Exception e){
            logger.error("updatePersonInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    private void updateCdqNCi(PersonInfo p,String uid) {
        CustomerInfo query = new CustomerInfo();
        query.setUid(uid);
        CustomerDetailQuery query1 = new CustomerDetailQuery();
        query1.setUid(uid);
        CustomerInfo ci = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        CustomerDetailQuery cdq = FacadeFactory.INSTANCE.getBaseSo().findObject(query1);
        cdq.setContactNumber(p.getMobileNumber());
        cdq.setQq(p.getQqNumber());
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(cdq);

        if(ci!=null){
            ci.setUsername(p.getRealName());
            ci.setPhone(p.getMobileNumber());
            ci.setQq(p.getQqNumber());
            ci.setSex(p.getSex());
            ci.setAge(p.getAge());
            ci.setBirthday(p.getBirthday());
            ci.setAddress(p.getAddress());
            ci.setDegree(p.getDegree());
            ci.setProfession(p.getJob());
            ci.setAddress(p.getAddress());
            ci.setAnnualSalary(p.getAnnualSalary());
            ci.setArea(p.getPlaceCity());
            ci.setFamily(p.getFamily());
            ci.setLostPay(p.getLostPay());
            ci.setLostLogin(p.getLostLogin());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(ci);
        }
    }

    /**
     * 自定义标签更新
     */
    public String updateCustomizeTagsInfo(){
        try {
            Long uid = useSessionUid();
            CustomizeTags query = new CustomizeTags();
            query.setUid(uid);
            if(FacadeFactory.INSTANCE.getBaseSo().findObject(query)==null){
                CustomizeTags newct = getCustomizeTags();
                newct.setUid(uid);
                FacadeFactory.INSTANCE.getBaseSo().addObject(newct);
            }else {
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(getCustomizeTags());
            }
            queryCustomizeTagsInfo();
        }catch (Exception e){
            logger.error("updateCustomizeTagsInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }
    /**
     * 新增重要问题处理
     */
    public String addTreatmentInfo(){
        try {
            Long uid = useSessionUid();
            String inputTime = findParameter("treatment_inputTime");
            String problem = findParameter("treatment_problem");
            String result = findParameter("treatment_result");
            Treatment treatment = new Treatment();
            treatment.setUid(uid);
            treatment.setInputTime(inputTime);
            treatment.setProblem(problem);
            treatment.setResult(result);
            treatment.setInputBy(this.currentUserLogo());
            FacadeFactory.INSTANCE.getBaseSo().addObject(treatment);
            queryTreatmentInfo();
        }catch (Exception e){
            logger.error("addTreatmentInfo Exception",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }


    /**
     * ----------------------------------------------------------------------  for business ----------------------------------------------------------------------------
     */

    private Long getUid() throws XLException{
        Long uid=0L;

        String uidStc = findParameter("uid");
        if(StringUtils.isEmpty(uidStc)){
            String account = findParameter("account");
            if(StringUtils.isEmpty(account)){
                return 0L;
            }else{
                uid  = GameUserInfoProxy.getUidByAccount(account);
            }
        }else {
            try {
                uid = Long.valueOf(uidStc);
            } catch (NumberFormatException e) {
                logger.error("Customerdetail getUid",e);
            }
        }
        setSessionUid(uid);
        return getSessionUid();
    }

    private Long useSessionUid() throws XLException{
        Long tmpUid = getSessionUid();
        if(tmpUid==null||tmpUid==0){
            throw new XLException("session uid已失效，请重新查询uid");
        }
        return tmpUid;
    }

    private String getAccount(Long uid) {
        String account = findParameter("account");
        if(StringUtils.isEmpty(account)){
            return GameUserInfoProxy.getAccountByUid(uid);
        }else{
            return account;
        }
    }

    private Resp_getuserinfo_base getUserInfoBase(String uid){
        return ProxyFactory.getInstance().getUserInfoProxy().getuserinfo_base(uid, (byte) 2);
    }
    private Resp_getuserinfo_sec getUserInfoSec(String uid){
        return ProxyFactory.getInstance().getUserInfoProxy().getuserinfo_sec(uid, (byte)2);
    }

    private Long getDaysOfJinZuan(Long uid){
        MemberShip query = new MemberShip();
        query.setUserId(uid);
        MemberShip memberShip = com.xunlei.niux.data.jinzuan.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if(memberShip==null){
            return 0L;
        }
        if("0".equals(memberShip.getMemberStatus())){
            return 0L;
        }
        return DateUtil.compareTime(memberShip.getMemberExpireDate(),now());
    }


    private CustomerDetailQuery getCdq(Long uid) {
        CustomerDetailQuery query = new CustomerDetailQuery();
        query.setUid(uid+"");
        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private Long diffNow(String srcDate){
        if(StringUtils.isEmpty(srcDate))return -999L;
        String now = DateUtil.formatNowByDefault();
        return DateUtil.compareTime(srcDate, now);
    }

    private String getFirstDate(Long uid){
        return null;
    }

    private String getLoginDays(Long uid, Integer passDays){
        return null;
    }

    private Integer getPayTimesByNow(Long uid, Integer passDays){

        return 0;
    }
    private Integer getPayAmountByNow(Long uid, Integer passDays){

        return 0;
    }


    /**
     * ----------------------------------------------------------------------  getter/setter ----------------------------------------------------------------------------
     */

    public Map<String, Object> getBasicInfoMap() {
        return basicInfoMap;
    }

    public void setBasicInfoMap(Map<String, Object> basicInfoMap) {
        this.basicInfoMap = basicInfoMap;
    }

    public PersonInfo getPersonInfo() {
        return personInfo;
    }

    public void setPersonInfo(PersonInfo personInfo) {
        this.personInfo = personInfo;
    }

    public CustomizeTags getCustomizeTags() {
        return customizeTags;
    }

    public void setCustomizeTags(CustomizeTags customizeTags) {
        this.customizeTags = customizeTags;
    }

    public List<Treatment> getTreatmentsList() {
        return treatmentsList;
    }

    public void setTreatmentsList(List<Treatment> treatmentsList) {
        this.treatmentsList = treatmentsList;
    }

    public Long getSessionUid() {
        return sessionUid;
    }

    public void setSessionUid(Long sessionUid) {
        this.sessionUid = sessionUid;
    }

    public List<CallRecord> getCallRecordList() {
        return callRecordList;
    }

    public List<CustomerGift> getCustomerGiftList() {
        return customerGiftList;
    }

    public List<PayDetailOK> getPayDetailOKList() {
        return payDetailOKList;
    }

    public List<RebateApply> getRebateApplyList() {
        return rebateApplyList;
    }

    public List<SmsRecordDTO> getSmsApplyList() {
        return smsApplyList;
    }

    public RebatePlan getRebatePlanForGame() {
        return rebatePlanForGame;
    }

    public Map<String, Object> getUidTagsMap() {
        return uidTagsMap;
    }
}
