package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.pay.bo.PayDetailOkBo;
import com.xunlei.niux.data.pay.vo.PayDetailOK;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.RebateOrder;
import com.xunlei.niux.data.vipgame.vo.vic.NotUsedOrderIgnore;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.dto.CustomerCallPayRecord;
import com.xunlei.niux.manager.web.dto.CustomerNotUsedOrder;
import com.xunlei.niux.manager.web.dto.MCallRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.util.StringTools;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.util.CollectionUtils;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class CustomerPersonNotUsedOrderManagedBean extends BaseManagedBean
{
    private BaseSo baseSo;
    private static final Logger logger = Logger.getLogger(CustomerPersonNotUsedOrderManagedBean.class.getName());
    private static final List<Object> queryList = new ArrayList();
    private static final Page queryPage = new Page();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String fromDay;
    private String toDay;
    private static Map<String, String> orderTypeMap;
    private PayDetailOkBo payDetailOkBo;

    static
    {
        if (orderTypeMap == null) {
            orderTypeMap = new HashMap();
            orderTypeMap.put("0", "普通订单");
            orderTypeMap.put("1", "返利订单");
            orderTypeMap.put("2", "代金券订单");
        }
    }

    public CustomerPersonNotUsedOrderManagedBean()
    {
        this.baseSo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo();
        this.payDetailOkBo = com.xunlei.niux.data.pay.facade.FacadeFactory.INSTANCE.getPayDetailOkBo();
    }

    private List<PayDetailOK> findResult(List<PayDetailOK> pdoList, Set<String> roSet)
    {
        List<NotUsedOrderIgnore> ignoreList = FacadeFactory.INSTANCE.getBaseSo().findObjects(new NotUsedOrderIgnore(),new Page());
        Set<String> ignores = new HashSet<String>();
        for(NotUsedOrderIgnore ignore:ignoreList){
            ignores.add(ignore.getOrderid());
        }

        List result = new ArrayList();
        for (PayDetailOK pdo : pdoList) {
            if (!roSet.contains(pdo.getOrderid()) && !ignores.contains(pdo.getOrderid())) {
                result.add(pdo);
            }
        }
        return result;
    }

    public List<CustomerNotUsedOrder> getQueryCustomerNotUsedOrderList()
    {
        logger.info("开始指定日期内在返利申请中未使用的订单查询");
        authenticateRun();
        String queryGameidGameId = findParameter("query_gameid");
        String queryMinMoneyMinMoney = findParameter("query_min_money");
        String queryUidid = findParameter("query_uid");
        String beginpaytime = findParameter("beginpaytime");
        String endpaytime = findParameter("endpaytime");
        String queryactno = findParameter("query_actno");

        if(StringUtils.isNotEmpty(queryMinMoneyMinMoney)){
            try{
                Integer.valueOf(queryMinMoneyMinMoney);
            }catch (NumberFormatException e){
                throw new XLRuntimeException("最小金额必须为数字");
            }
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.MONTH,-1);
        calendar.add(Calendar.DATE,-1);
        String startDate =  sdf.format(calendar.getTime());


        List ccprlist = new ArrayList();
        String callsql = "select * from customerdetailquery where lastCaller = '" + this.currentUserInfo().getTrueName() + "'";
        List<CustomerDetailQuery> list = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(CustomerDetailQuery.class, callsql, queryList);
        if (CollectionUtils.isEmpty(list)) return ccprlist;
        StringBuilder sb = new StringBuilder("(");
        for (CustomerDetailQuery cdq : list) {
            sb.append("'").append(cdq.getUid()).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        StringBuilder rebateOrderSql = new StringBuilder();
        rebateOrderSql.append("select * from rebateorder where isvalid = 1");
        if(StringUtils.isNotEmpty(beginpaytime)){
            rebateOrderSql.append(" and orderTime>='" + beginpaytime + " 00:00:00'");
        }
        if(StringUtils.isNotEmpty(endpaytime)){
            rebateOrderSql.append(" and orderTime<='" + endpaytime + " 23:59:59'");
        }
        if(StringUtils.isEmpty(beginpaytime)&&StringUtils.isEmpty(endpaytime)){
            rebateOrderSql.append(" and orderTime>='" + startDate + " 00:00:00'");
        }
        System.out.println("rebateOrderSql:" + rebateOrderSql);
        List<RebateOrder> roList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(RebateOrder.class, rebateOrderSql.toString(), new ArrayList());
        Set<String> roSet = new HashSet<String>();
        for(RebateOrder ror:roList){
            roSet.add(ror.getOrderid());
        }
        String ordersql = "select * from paydetailok   where  ToInnerUserid in " + sb + " and GiftFlag!='1' ";

        if(StringUtils.isNotEmpty(beginpaytime)){
            ordersql = ordersql + " and  SuccessTime >= '" +beginpaytime + " 00:00:00' ";
        }
        if(StringUtils.isNotEmpty(endpaytime)){
            ordersql = ordersql + " and  SuccessTime <= '" +endpaytime + " 23:59:59' ";
        }
        if(StringUtils.isEmpty(beginpaytime)&&StringUtils.isEmpty(endpaytime)){
            ordersql = ordersql + " and  SuccessTime >= '" +startDate + " 00:00:00' ";
        }

        if(StringUtils.isNotEmpty(queryMinMoneyMinMoney)){
            ordersql = ordersql + " and PayMondey >="+queryMinMoneyMinMoney;
        }
        if(StringUtils.isNotEmpty(queryGameidGameId)){
            ordersql = ordersql + " and gameid='"+queryGameidGameId.substring(1)+"' ";
        }
        if(StringUtils.isNotEmpty(queryUidid)){
            ordersql = ordersql + " and Toinneruserid = '"+queryUidid+"' ";
        }
        if(StringUtils.isNotEmpty(queryactno)){
            if("1".equals(queryactno)){
                ordersql = ordersql + " and niuxactno = 'niuxzfzx' ";
            }else if("2".equals(queryactno)){
                ordersql = ordersql + " and niuxactno <> 'niuxzfzx' ";
            }
        }
        ordersql = ordersql + " order by SuccessTime desc";
        System.out.println("ordersql:" + ordersql);
        List<PayDetailOK> pdolist = this.payDetailOkBo.executeQuery(PayDetailOK.class, ordersql);
        pdolist = findResult(pdolist, roSet);
        if (CollectionUtils.isEmpty(pdolist)) return ccprlist;
        Map vipGradeMap = getVipGradeMap(pdolist);
        for (PayDetailOK pdo : pdolist) {
            CustomerNotUsedOrder record = new CustomerNotUsedOrder();
            record.setUserId(pdo.getToinneruserid());
            record.setActno(pdo.getNiuxactno()==null?"":pdo.getNiuxactno());
            Object vipGrade = vipGradeMap.get(record.getUserId());
            record.setVipGrade(vipGrade == null ? "0" : String.valueOf(vipGrade));
            record.setOrderId(pdo.getOrderid());
            record.setOrderTime(pdo.getSuccesstime());
            record.setServerId(pdo.getServerid());
            record.setPayMoney(String.valueOf(pdo.getPayMondey()));
            record.setOrderMoney(pdo.getTotalmoney());
            String gameId = pdo.getGameid();
            if (gameId.length() == 5) {
                gameId = "0" + gameId;
            }
            Games games = GameCache.getInstance().getGameByGameId(gameId);
            record.setGameName(games == null ? "" : games.getGameName());
            ccprlist.add(record);
        }
        if (roList != null) {
            roList.clear();
        }
        if (list != null) {
            list.clear();
        }
        if (pdolist != null) {
            pdolist.clear();
        }
        int count = ccprlist.size();
        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);
        Sheet<CustomerNotUsedOrder> sheet = new Sheet<CustomerNotUsedOrder>(count, ccprlist);
        this.mergePagedDataModel(sheet, pagedFliper);
        return ccprlist;
    }

    private Map<String, String> getVipGradeMap(List<PayDetailOK> pdolist) {
        Set<String> uidSet = new HashSet<String>();
        for (PayDetailOK pdo : pdolist) {
            uidSet.add(pdo.getToinneruserid());
        }
        StringBuilder sb = new StringBuilder(" (");
        for (String uid : uidSet) {
            sb.append("'").append(uid).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        String sql = "select * from customerdetailquery where uid in " + sb;
        List<CustomerDetailQuery> cdqList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(CustomerDetailQuery.class, sql, queryList);
        Map result = new HashMap();
        if (CollectionUtils.isEmpty(cdqList)) return result;
        for (CustomerDetailQuery cdq : cdqList) {
            result.put(cdq.getUid(), cdq.getLiveVipGrade());
        }
        uidSet.clear();
        uidSet = null;
        cdqList.clear();
        cdqList = null;
        return result;
    }

    public void addToIgnore(){
            String orderid = findParameter("ignore_orderid");
            NotUsedOrderIgnore query = new NotUsedOrderIgnore();
            query.setOrderid(orderid);
            if (baseSo.countObject(query) == 0) {
                query.setIgnoreBy(this.currentUserLogo());
                query.setIgnoreTime(now());
                baseSo.addObject(query);
            }
    }

}