package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.vo.Page;
import com.xunlei.gamepay.facade.IFacade;
import com.xunlei.gamepay.vo.PayDetailOK;
import com.xunlei.niux.data.vipgame.dto.vic.*;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.vic.*;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;

public class CustomerKPIViewManagedBean extends BaseManagedBean {

    DecimalFormat df = new DecimalFormat("#.##");

    private Map<String,Object> reportTeamMap = new HashMap<String, Object>();
    private List<RebateReportPersonDTO> reportPersonList = new ArrayList<RebateReportPersonDTO>();
    private List<RebateReportGameDTO> reportGameList = new ArrayList<RebateReportGameDTO>();
    private List<RebateReportOldGameDTO> reportOldGameList = new ArrayList<RebateReportOldGameDTO>();
    private Map<String,List<RebateReportOldGameDetailDTO>> reportOldGameDetailMap = new HashMap<String, List<RebateReportOldGameDetailDTO>>();
    private List<RebateReportOldGameDetailDTO> reportOldGameDetail = new ArrayList<RebateReportOldGameDetailDTO>();
    private String queryStartDate;
    private String queryEndDate;

	public CustomerKPIViewManagedBean(){
	}

    public void queryTeamKpi() {
        KpiTeam query = new KpiTeam();
        query.setKpidate(queryEndDate.substring(0,7));
        KpiTeam kpiTeam = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        if(kpiTeam==null) return;

        PayDetailOK queryPay = new PayDetailOK();
        queryPay.setFromOrderTime(queryStartDate);
        queryPay.setToOrderTime(queryEndDate);
        queryPay.setDsname("3");
        PayDetailOK sumPay = IFacade.INSTANCE.queryPayDetailOKSum(queryPay);
        reportTeamMap.clear();
        reportTeamMap.put("kpi", kpiTeam.getKpi());
        reportTeamMap.put("kpi_rc", kpiTeam.getKpiRc());
        reportTeamMap.put("kpi_yj", kpiTeam.getKpiYj());
        RebateReportTeamDTO rebateReportTeamDTO = FacadeFactory.INSTANCE.getRebateReportBo().queryRebateReportByDate(queryStartDate + " 00:00:00", queryEndDate + " 23:59:59");
        if(rebateReportTeamDTO!=null){
            BigDecimal finished = new BigDecimal(rebateReportTeamDTO.getFinished());
            reportTeamMap.put("finished", finished);
            reportTeamMap.put("finished_rc", rebateReportTeamDTO.getFinishedRiChang());
            reportTeamMap.put("finished_yj", rebateReportTeamDTO.getFinishedYeJi());
            BigDecimal a = finished;
            BigDecimal b = new BigDecimal(kpiTeam.getKpi());
            reportTeamMap.put("kpiRate", a.multiply(new BigDecimal(100)).divide(b,2,BigDecimal.ROUND_HALF_UP));
            if(kpiTeam.getKpiRc()!=0){
                reportTeamMap.put("kpiRate_rc", new BigDecimal(rebateReportTeamDTO.getFinishedRiChang()).multiply(new BigDecimal(100)).divide(new BigDecimal(kpiTeam.getKpiRc()), 2, BigDecimal.ROUND_HALF_UP)+"%");
            }
            if(kpiTeam.getKpiYj()!=0){
                reportTeamMap.put("kpiRate_yj", new BigDecimal(rebateReportTeamDTO.getFinishedYeJi()).multiply(new BigDecimal(100)).divide(new BigDecimal(kpiTeam.getKpiYj()), 2, BigDecimal.ROUND_HALF_UP)+"%");
            }
            if(sumPay!=null){
                BigDecimal c = new BigDecimal(sumPay.getPayMondey());
                reportTeamMap.put("payMoney", c);
                reportTeamMap.put("payRate", a.multiply(new BigDecimal(100)).divide(c,2,BigDecimal.ROUND_HALF_UP));
            }
        }

    }

    public String queryReportPerson(){
        try {
            checkQueryDate();
            reportPersonList.clear();
            Map<String,RebateReportPersonDTO> map = FacadeFactory.INSTANCE.getRebateReportBo().queryRebateReportPersonByDate(queryStartDate + " 00:00:00", queryEndDate + " 23:59:59");
            KpiPerson query = new KpiPerson();
            query.setKpidate(queryEndDate.substring(0,7));
            List<KpiPerson> qlist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
            if(qlist!=null){
                for(KpiPerson kpiPerson:qlist){
                    RebateReportPersonDTO dto = new RebateReportPersonDTO();
                    dto.setPerson(kpiPerson.getPerson());
                    dto.setKpi(kpiPerson.getKpi());
                    dto.setKpiRc(kpiPerson.getKpiRc());
                    dto.setKpiYj(kpiPerson.getKpiYj());
                    RebateReportPersonDTO value =map.get(kpiPerson.getPerson());
                    if(value!=null&&value.getFinished()!=null){
                        Double finished =  value.getFinished();
                        dto.setFinished(finished);
                        dto.setFinishedRiChang(value.getFinishedRiChang());
                        dto.setFinishedYeJi(value.getFinishedYeJi());
                        BigDecimal a = new BigDecimal(finished);
                        BigDecimal b = new BigDecimal(kpiPerson.getKpi());
                        dto.setKpirate(a.multiply(new BigDecimal(100)).divide(b,2,BigDecimal.ROUND_HALF_UP).doubleValue());
                        if(kpiPerson.getKpiRc()!=0){
                            dto.setKpirateRc(new BigDecimal(value.getFinishedRiChang()).multiply(new BigDecimal(100)).divide(new BigDecimal(kpiPerson.getKpiRc()), 2, BigDecimal.ROUND_HALF_UP).doubleValue());
                        }
                        if(kpiPerson.getKpiYj()!=0){
                            dto.setKpirateYj(new BigDecimal(value.getFinishedYeJi()).multiply(new BigDecimal(100)).divide(new BigDecimal(kpiPerson.getKpiYj()), 2, BigDecimal.ROUND_HALF_UP).doubleValue());
                        }
                    }
                    reportPersonList.add(dto);
                }
            }
            queryTeamKpi();
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String queryReportGame(){
        try {
            checkQueryDate();
            reportGameList.clear();
            Map<String,Double> map = FacadeFactory.INSTANCE.getRebateReportBo().queryRebateReportGameByDate(queryStartDate + " 00:00:00", queryEndDate + " 23:59:59");
            KpiGame query = new KpiGame();
            query.setKpidate(queryEndDate.substring(0,7));
            List<KpiGame> glist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
            Map<String, BigDecimal> payMap = getGamePay();
            for(KpiGame kpiGame:glist){
                RebateReportGameDTO dto = new RebateReportGameDTO();
                dto.setGameid(kpiGame.getGameid());
                dto.setKpisale(kpiGame.getKpisale());
                dto.setKpiincome(kpiGame.getKpiincome());
                Double finished = map.get(kpiGame.getGameid());
                if(finished!=null){
                    dto.setFinished(finished);
                    BigDecimal a = new BigDecimal(finished);
                    BigDecimal b = new BigDecimal(kpiGame.getKpisale());
                    dto.setSalerate(a.multiply(new BigDecimal(100)).divide(b, 2, BigDecimal.ROUND_HALF_UP).doubleValue());
                }

                BigDecimal payMoney = payMap.get(dto.getGameid());
                if(payMoney!=null && payMoney.compareTo(BigDecimal.ZERO)!=0){
                    dto.setIncome(payMoney.doubleValue());
                    if(kpiGame.getKpiincome()!=0){
                        BigDecimal b = new BigDecimal(kpiGame.getKpiincome());
                        dto.setIncomerate(payMoney.multiply(new BigDecimal(100)).divide(b, 2, BigDecimal.ROUND_HALF_UP).doubleValue());
                    }
                }

                if(finished!=null&&payMoney!=null && payMoney.compareTo(BigDecimal.ZERO)!=0){
                    BigDecimal a = new BigDecimal(finished);
                    dto.setSaleincomerate(a.multiply(new BigDecimal(100)).divide(payMoney, 2, BigDecimal.ROUND_HALF_UP).doubleValue());
                }

                reportGameList.add(dto);

            }
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }
    public String queryReportOldGame(){
        try {
            checkQueryDate();
            reportOldGameList.clear();
            reportOldGameDetailMap.clear();
            RebateReportOldGameConfig query = new RebateReportOldGameConfig();
            query.setKpiDate(queryEndDate.substring(0, 7));
            List<RebateReportOldGameConfig> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());

            //sum of gamepay group by person
            Map<String, BigDecimal> payMap = getGamePay();
            Map<String, BigDecimal> payByPersonMap = new HashMap<String, BigDecimal>();
            for(RebateReportOldGameConfig og:list){
                BigDecimal hasPaid = payMap.get(og.getGameid());
                if(hasPaid==null)hasPaid=BigDecimal.ZERO;

                RebateReportOldGameDetailDTO dto = new RebateReportOldGameDetailDTO();
                dto.setGameid(og.getGameid());
                dto.setFinished(hasPaid);
                if(og.getKpi()!=null && og.getKpi()>0){
                    dto.setKpi(new BigDecimal(og.getKpi()));
                    dto.setKpirate(hasPaid.multiply(new BigDecimal(100)).divide(dto.getKpi(), 2, BigDecimal.ROUND_HALF_UP));
                }
                if(reportOldGameDetailMap.containsKey(og.getPerson())){
                    List<RebateReportOldGameDetailDTO> dtolist = reportOldGameDetailMap.get(og.getPerson());
                    dtolist.add(dto);
                    reportOldGameDetailMap.put(og.getPerson(),dtolist);
                }else{
                    List<RebateReportOldGameDetailDTO> dtolist = new ArrayList<RebateReportOldGameDetailDTO>();
                    dtolist.add(dto);
                    reportOldGameDetailMap.put(og.getPerson(),dtolist);
                }


                if(payByPersonMap.containsKey(og.getPerson())){
                    BigDecimal finish = payByPersonMap.get(og.getPerson());
                    payByPersonMap.put(og.getPerson(),finish.add(hasPaid));
                }else{
                    payByPersonMap.put(og.getPerson(),hasPaid);
                }
            }

            List<RebateReportOldGameDTO> oglist = FacadeFactory.INSTANCE.getRebateReportBo().queryOldGameKpiSumForPerson(queryEndDate.substring(0,7));

            for(RebateReportOldGameDTO dto:oglist){
                BigDecimal finish = payByPersonMap.get(dto.getPerson());
                if(finish!=null){
                    dto.setFinished(finish);
                    BigDecimal b = dto.getKpitotal();
                    dto.setKpirate(finish.multiply(new BigDecimal(100)).divide(b, 2, BigDecimal.ROUND_HALF_UP));
                }

                reportOldGameList.add(dto);
            }
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String queryReportOldGameDetail(){
        try {
            reportOldGameDetail.clear();
            String detailPerson = findParameter("one_person");
            if(StringUtils.isEmpty(detailPerson))return "";
            List<RebateReportOldGameDetailDTO> list = reportOldGameDetailMap.get(detailPerson);
            RebateReportOldGameDetailDTO sumDto = new RebateReportOldGameDetailDTO();
            sumDto.setGameid("0");
            sumDto.setFinished(BigDecimal.ZERO);
            sumDto.setKpi(BigDecimal.ZERO);
            for(RebateReportOldGameDetailDTO dto:list){
                sumDto.setKpi(sumDto.getKpi().add(dto.getKpi()));
                sumDto.setFinished(sumDto.getFinished().add(dto.getFinished()));
            }
            sumDto.setKpirate(sumDto.getFinished().multiply(new BigDecimal(100)).divide(sumDto.getKpi(), 2, BigDecimal.ROUND_HALF_UP));
            reportOldGameDetail.add(sumDto);
            reportOldGameDetail.addAll(list);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    private Map<String, BigDecimal> getGamePay() throws Exception{
        PayDetailOK queryPay = new PayDetailOK();
        queryPay.setFromOrderTime(queryStartDate + " 00:00:00");
        queryPay.setToOrderTime(queryEndDate + " 23:59:59");
        queryPay.setDsname("3");
        return IFacade.INSTANCE.getEachGamePaySum(queryPay);
    }

    private void checkQueryDate(){
        if(StringUtils.isEmpty(queryStartDate)){
            queryStartDate = now().substring(0,10);
        }
        if(StringUtils.isEmpty(queryEndDate)){
            queryEndDate = now().substring(0,10);
        }
    }

    public String getQueryEndDate() {
        return queryEndDate;
    }

    public void setQueryEndDate(String queryEndDate) {
        this.queryEndDate = queryEndDate;
    }

    public String getQueryStartDate() {
        return queryStartDate;
    }

    public void setQueryStartDate(String queryStartDate) {
        this.queryStartDate = queryStartDate;
    }

    public List<RebateReportGameDTO> getReportGameList() {
        return reportGameList;
    }

    public void setReportGameList(List<RebateReportGameDTO> reportGameList) {
        this.reportGameList = reportGameList;
    }

    public List<RebateReportOldGameDTO> getReportOldGameList() {
        return reportOldGameList;
    }

    public void setReportOldGameList(List<RebateReportOldGameDTO> reportOldGameList) {
        this.reportOldGameList = reportOldGameList;
    }

    public List<RebateReportPersonDTO> getReportPersonList() {
        return reportPersonList;
    }

    public Map<String, Object> getReportTeamMap() {
        return reportTeamMap;
    }

    public void setReportTeamMap(Map<String, Object> reportTeamMap) {
        this.reportTeamMap = reportTeamMap;
    }

    public Map<String, List<RebateReportOldGameDetailDTO>> getReportOldGameDetailMap() {
        return reportOldGameDetailMap;
    }

    public List<RebateReportOldGameDetailDTO> getReportOldGameDetail() {
        return reportOldGameDetail;
    }
}
