package com.xunlei.niux.manager.web.model.customer;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerUser;
import com.xunlei.niux.data.vipgame.vo.vic.KpiGame;
import com.xunlei.niux.data.vipgame.vo.vic.KpiPerson;
import com.xunlei.niux.data.vipgame.vo.vic.KpiTeam;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerKPIManagedBean extends BaseManagedBean {

    private List<KpiTeam> kpiTeamList = new ArrayList<KpiTeam>();
    private List<KpiPerson> kpiPersonList = new ArrayList<KpiPerson>();
    private List<KpiGame> kpiGameList = new ArrayList<KpiGame>();
    private Map<String,Object> customerUserNameMap = new HashMap<String, Object>();

    private String queryDate;

	public CustomerKPIManagedBean(){
        updateCustomerUserNameMap();
	}

    /**
     * **************************************** Team KPI ***********************************************************
     */
    public String getQueryTeamKpi(){
        try {
            checkQueryDate();
            KpiTeam query = new KpiTeam();
            query.setKpidate(queryDate);

            kpiTeamList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String addTeamKpi(){
        try {
            KpiTeam kpiTeam = findBean(KpiTeam.class, "kpiteam");
            kpiTeam.setInputBy(this.currentUserLogo());
            kpiTeam.setInputTime(now());
            FacadeFactory.INSTANCE.getBaseSo().addObject(kpiTeam);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String editTeamKpi(){
        try {
            KpiTeam kpiTeam = findBean(KpiTeam.class, "kpiteam");
            kpiTeam.setInputBy(this.currentUserLogo());
            kpiTeam.setInputTime(now());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(kpiTeam);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }


    /**
     * **************************************** Person KPI ***********************************************************
     */
    public String getQueryPersonKpi(){
        updateCustomerUserNameMap();
        try {
            checkQueryDate();
            KpiPerson query = new KpiPerson();
            query.setKpidate(queryDate);
            kpiPersonList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String addPersonKpi(){
        try {
            KpiPerson kpiPerson = findBean(KpiPerson.class, "kpiperson");
            kpiPerson.setInputBy(this.currentUserLogo());
            kpiPerson.setInputTime(now());
            FacadeFactory.INSTANCE.getBaseSo().addObject(kpiPerson);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String editPersonKpi(){
        try {
            KpiPerson kpiPerson = findBean(KpiPerson.class, "kpiperson");
            kpiPerson.setInputBy(this.currentUserLogo());
            kpiPerson.setInputTime(now());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(kpiPerson);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }


    /**
     * **************************************** Game KPI ***********************************************************
     */
    public String getQueryGameKpi(){
        try {
            checkQueryDate();
            KpiGame query = new KpiGame();
            query.setKpidate(queryDate);
            kpiGameList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String addGameKpi(){
        try {
            KpiGame kpiGame = findBean(KpiGame.class, "kpigame");
            kpiGame.setInputBy(this.currentUserLogo());
            kpiGame.setInputTime(now());
            FacadeFactory.INSTANCE.getBaseSo().addObject(kpiGame);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    public String editGameKpi(){
        try {
            KpiGame kpiGame = findBean(KpiGame.class, "kpigame");
            kpiGame.setInputBy(this.currentUserLogo());
            kpiGame.setInputTime(now());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(kpiGame);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

    /**
     * **************************************** BUS ***********************************************************
     */
    private void checkQueryDate(){
        if(StringUtils.isEmpty(queryDate)){
            queryDate = now().substring(0,7);
        }
    }

    public List<SelectItem> getQueryCustomerUser(){
        List<SelectItem> list=new ArrayList<SelectItem>();
        List<CustomerUser> culist=com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(new CustomerUser(),new Page());
        for(CustomerUser cu:culist){
            list.add(new SelectItem(cu.getUserName(),cu.getTrueName()));
        }
        return list;
    }

    public String updateCustomerUserNameMap(){
        List<CustomerUser> culist=com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(new CustomerUser(),new Page());
        customerUserNameMap.clear();
        for(CustomerUser cu:culist){
            customerUserNameMap.put(cu.getUserName(), cu.getTrueName());
        }
        return "";
    }

    public List<KpiGame> getKpiGameList() {
        return kpiGameList;
    }

    public void setKpiGameList(List<KpiGame> kpiGameList) {
        this.kpiGameList = kpiGameList;
    }

    public List<KpiPerson> getKpiPersonList() {
        return kpiPersonList;
    }

    public void setKpiPersonList(List<KpiPerson> kpiPersonList) {
        this.kpiPersonList = kpiPersonList;
    }

    public List<KpiTeam> getKpiTeamList() {
        return kpiTeamList;
    }

    public void setKpiTeamList(List<KpiTeam> kpiTeamList) {
        this.kpiTeamList = kpiTeamList;
    }

    public Map<String, Object> getCustomerUserNameMap() {
        return customerUserNameMap;
    }

    public void setCustomerUserNameMap(Map<String, Object> customerUserNameMap) {
        this.customerUserNameMap = customerUserNameMap;
    }

    public String getQueryDate() {
        return queryDate;
    }

    public void setQueryDate(String queryDate) {
        this.queryDate = queryDate;
    }
}
