package com.xunlei.niux.manager.web.model.customer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.vo.KeyBatch;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.customer.CustomerGameGift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.util.StringTools;


/**
 * 游戏和礼包业务处理类
 * @author lisu
 * 2015-02-12
 */
public class CustomerGameGiftManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CustomerGameGiftManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    
	public CustomerGameGiftManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
	}	
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询游戏礼包
	 * @return
	 */
	public String getQueryCustomerGameGiftList(){		
	    logger.info("开始游戏礼包查询");
        this.authenticateRun();//验证运行权限
        CustomerGameGift CustomerGameGift = findBean(CustomerGameGift.class, "customergamegift");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(CustomerGameGift);
        pagedFliper.setRecordCount(count);
        List<CustomerGameGift> list = new ArrayList<CustomerGameGift>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(CustomerGameGift, page);
        } 
        Sheet<CustomerGameGift> sheet = new Sheet<CustomerGameGift>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	
	private String getGiftContent(String gameId,String batId){
    	if(StringTools.isEmpty(gameId)||StringTools.isEmpty(batId)){    	
    		return "";
    	}
    	KeyBatch batch =  KeyRuleProxy.getInstance().getBatch(gameId, batId);
    	if(batch==null){
    		return "";
    	}else{
    		return batch.getGiftcontent();
    	}
	}
	
	/**
	 * 获得配置游戏下的礼包列表
	 */
	public List<SelectItem> getGifts(){
		String gameId = this.findParameter("one_gameId");
		String queryGameId = this.findParameter("niux_gamecontent_gameFK111");
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(StringTools.isEmpty(gameId)){
			if(StringTools.isEmpty(queryGameId)){
				return siList;
			}else{
				gameId = queryGameId;
			}			
		}
		CustomerGameGift query = new CustomerGameGift();
		query.setGameId(gameId);
		List<CustomerGameGift> cggList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		for(CustomerGameGift cgg:cggList){
			siList.add(new SelectItem(cgg.getBatId(), cgg.getGiftName())); 	
		}
		return siList;
	}
	
	
	/**
	 * 新增游戏礼包
	 * @return
	 */
	public String add(){
		logger.info("开始游戏礼包信息添加");
		this.authenticateAdd();//添加权限
		CustomerGameGift customerGameGift=this.findBean(CustomerGameGift.class,"customergamegift");				
		try{
			if(customerGameGift==null){
				logger.info("游戏礼包信息为空");
				throw new XLRuntimeException("游戏礼包信息为空");
			}
			CustomerGameGift query = new CustomerGameGift();
            query.setGameId(customerGameGift.getGameId());
            query.setBatId(customerGameGift.getBatId());
            CustomerGameGift mylevel = baseSo.findObject(query);
            if(mylevel != null){
            	logger.info("该游戏该批次的礼包已经存在");
				throw new XLRuntimeException("该游戏该批次的礼包已经存在");
            }
			customerGameGift.setInputBy(this.currentUserLogo());
			customerGameGift.setInputTime(now());	
			customerGameGift.setGiftContent(getGiftContent(customerGameGift.getGameId(),customerGameGift.getBatId()));
			baseSo.addObject(customerGameGift);			
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	

	/**
	 * 修改成长体系等级信息
	 * @return
	 */
	public String edit(){
		logger.info("开始成长体系等级信息修改");
		this.authenticateEdit();//编辑权限
		CustomerGameGift customerGameGift=this.findBean(CustomerGameGift.class,"customergamegift");			
		try{
			if(customerGameGift==null){
				logger.info("游戏礼包信息为空");
				throw new XLRuntimeException("游戏礼包信息为空");
			}
			CustomerGameGift query = new CustomerGameGift();
            query.setGameId(customerGameGift.getGameId());
            query.setBatId(customerGameGift.getBatId());
            CustomerGameGift mylevel = baseSo.findObject(query);
            if(mylevel != null){
            	if(mylevel.getSeqId() != customerGameGift.getSeqId()){
                	logger.info("该游戏礼包已经存在");
    				throw new XLRuntimeException("该游戏礼包已经存在");
            	}
            }
            customerGameGift.setEditTime(now());
            customerGameGift.setEditBy(this.currentUserLogo());
            customerGameGift.setGiftContent(getGiftContent(customerGameGift.getGameId(),customerGameGift.getBatId()));
			baseSo.updateObjectById(customerGameGift);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除游戏礼包信息
	 * @return
	 */
	public String delete(){
		logger.info("开始游戏礼包信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(CustomerGameGift.class, id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
