package com.xunlei.niux.manager.web.model.coin;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.coin.bo.LotteryInfoRecordBo;
import com.xunlei.niux.data.coin.facade.FacadeFactory;
import com.xunlei.niux.data.coin.vo.LotteryInfoRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
* 欢乐券博弈抽奖处理类
* @author ljm
*  2015-11-10
*/
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LOTTERY_COIN)
public class LotteryInfoRecordManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LotteryInfoRecordManagedBean.class.getName());
	private LotteryInfoRecordBo lotteryInfoRecordBo;
	private int rownum = 0;

	public LotteryInfoRecordManagedBean(){
		lotteryInfoRecordBo = FacadeFactory.INSTANCE.getLotteryInfoRecordBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}


	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询博弈抽奖信息
	 * @return
	 */
	public String getQueryLotteryInfoRecordList(){
		logger.info("开始博弈抽奖信息查询");
        this.authenticateRun();//验证运行权限
        LotteryInfoRecord bizInfo = findBean(LotteryInfoRecord.class, "lotteryinforecord");
        
        if("".equals(bizInfo.getEditBy())){
        	bizInfo.setEditBy(null);
        }
        
        if(bizInfo.getCoin() == 0){
        	bizInfo.setCoin(null);
        }
        
        PagedFliper pagedFliper = this.getFliper();
        int count = lotteryInfoRecordBo.count(bizInfo);
        pagedFliper.setRecordCount(count);
        List<LotteryInfoRecord> list = new ArrayList<LotteryInfoRecord>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("editTime", OrderType.DESC);
            list = lotteryInfoRecordBo.find(bizInfo, page);
        }
        Sheet<LotteryInfoRecord> sheet = new Sheet<LotteryInfoRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}


}
