package com.xunlei.niux.manager.web.model.coin;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.coin.bo.LotteryInfoBo;
import com.xunlei.niux.data.coin.bo.LotteryInfoRecordBo;
import com.xunlei.niux.data.coin.facade.FacadeFactory;
import com.xunlei.niux.data.coin.vo.LotteryInfo;
import com.xunlei.niux.data.coin.vo.LotteryInfoRecord;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
* 欢乐券博弈抽奖处理类
* @author ljm
*  2015-10-27
*/
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LOTTERY_COIN)
public class LotteryInfoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(LotteryInfoManagedBean.class.getName());
	private static String updateCacheURL = "http://coin.niu.xunlei.com:7080/updatelotteryinfocache.do";
	private static String queryCashURL = "http://dy.niu.xunlei.com/league/getniuxcash.do";//代金券、现金券查询
	private LotteryInfoBo bizInfoBo;
	private LotteryInfoRecordBo lotteryInfoRecordBo;
	private int rownum = 0;

	public LotteryInfoManagedBean(){
		bizInfoBo = FacadeFactory.INSTANCE.getLotteryInfoBo();
		lotteryInfoRecordBo = FacadeFactory.INSTANCE.getLotteryInfoRecordBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}


	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询博弈抽奖信息
	 * @return
	 */
	public String getQueryLotteryInfoList(){
		logger.info("开始博弈抽奖信息查询");
        this.authenticateRun();//验证运行权限
        LotteryInfo bizInfo = findBean(LotteryInfo.class, "lotteryinfo");
        
        if("".equals(bizInfo.getEditBy())){
        	bizInfo.setEditBy(null);
        }
        
        if(bizInfo.getCoin() == 0){
        	bizInfo.setCoin(null);
        }
        
        PagedFliper pagedFliper = this.getFliper();
        int count = bizInfoBo.count(bizInfo);
        pagedFliper.setRecordCount(count);
        List<LotteryInfo> list = new ArrayList<LotteryInfo>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = bizInfoBo.find(bizInfo, page);
        }
        Sheet<LotteryInfo> sheet = new Sheet<LotteryInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	/**
	 * 新增博弈抽奖信息
	 * @return
	 */
	public String add(){
		logger.info("开始博弈抽奖信息添加");
		this.authenticateAdd();//添加权限
		LotteryInfo bizinfo = this.findBean(LotteryInfo.class,"lotteryinfo");
        try{
			if(bizinfo==null){
				logger.info("抽奖信息为空");
				throw new XLRuntimeException("抽奖信息为空");
			}
			bizinfo.setInputBy(currentUserLogo());
			bizinfo.setInputTime(now());
			
			initCashMoney(bizinfo);
			
			bizInfoBo.insert(bizinfo);
			
			LotteryInfoRecord lotteryInfoRecord = getLotteryInfoRecord(bizinfo);
			
			lotteryInfoRecordBo.insert(lotteryInfoRecord);
			
			String r = HttpClientUtil.get(updateCacheURL);
			if(r.indexOf("\"code\":\"00\"") == -1){
				logger.info("更新抽奖信息缓存失败");
				throw new XLRuntimeException("更新抽奖信息缓存失败");
			}

		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	

	/**
	 * 修改博弈抽奖信息
	 * @return
	 */
	public String edit(){
		logger.info("开始博弈抽奖信息修改");
		this.authenticateEdit();//编辑权限
		LotteryInfo bizinfo=this.findBean(LotteryInfo.class,"lotteryinfo");
		try{
			if(bizinfo==null){
				logger.info("博弈抽奖为空");
				throw new XLRuntimeException("抽奖信息为空");
			}
			bizinfo.setEditBy(this.currentUserLogo());
			bizinfo.setEditTime(now());

			initCashMoney(bizinfo);
			
			bizInfoBo.update(bizinfo);

			LotteryInfoRecord lotteryInfoRecord = getLotteryInfoRecord(bizinfo);
			
			lotteryInfoRecordBo.insert(lotteryInfoRecord);
			
			String r = HttpClientUtil.get(updateCacheURL);
			if(r.indexOf("\"code\":\"00\"") == -1){
				logger.info("更新抽奖信息缓存失败");
				throw new XLRuntimeException("更新抽奖信息缓存失败");
			}
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}


	/**
	 * 删除抽奖活动
	 * @return
	 */
	public String delete(){	
		logger.info("开始博弈抽奖信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				bizInfoBo.deleteById(id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}

	
	private LotteryInfoRecord getLotteryInfoRecord(LotteryInfo bizinfo){
		
		LotteryInfoRecord lotteryInfoRecord = new LotteryInfoRecord();
		if(bizinfo != null){
			lotteryInfoRecord.setCoin(bizinfo.getCoin());
			lotteryInfoRecord.setEditBy(currentUserLogo());
			lotteryInfoRecord.setEditTime(now());
			lotteryInfoRecord.setFailCash(bizinfo.getFailCash());
			lotteryInfoRecord.setFailCashMoney(bizinfo.getFailCashMoney());
			lotteryInfoRecord.setFailVoucher(bizinfo.getFailVoucher());
			lotteryInfoRecord.setFailVoucherLimitMoney(bizinfo.getFailVoucherLimitMoney());
			lotteryInfoRecord.setFailVoucherMoney(bizinfo.getFailVoucherMoney());
			lotteryInfoRecord.setSuccsessCash(bizinfo.getSuccsessCash());
			lotteryInfoRecord.setSuccsessCashMoney(bizinfo.getSuccsessCashMoney());
			lotteryInfoRecord.setSuccsessRate(bizinfo.getSuccsessRate());
			lotteryInfoRecord.setSuccsessVoucher(bizinfo.getSuccsessVoucher());
			lotteryInfoRecord.setSuccsessVoucherLimitMoney(bizinfo.getSuccsessVoucherLimitMoney());
			lotteryInfoRecord.setSuccsessVoucherMoney(bizinfo.getSuccsessVoucherMoney());
		}
		
		return lotteryInfoRecord;
	}


	/**
	 * 初始化各现金券和代金券的金额
	 * @param bizinfo
	 */
	private void initCashMoney(LotteryInfo bizinfo) {
		//查询各个代金券和现金券金额
		int succMoney = 0;
		int succCashMoney = 0;
		int succVouMoney = 0;
		int succsessVoucherLimitMoney = 0;
		int failMoney = 0;
		int failCashMoney = 0;
		int failVouMoney = 0;
		int failVoucherLimitMoney = 0;
		
		try{
			//callback({“rtn”:0,”data”:{“groupNo”:1000,”expireDate”:“2015-06-30”,”parValue”:100.0,”minPayMoney”:100.0,”limitNo”:“1”,”cashStatus”:“0”,”cashNo”:“0000004SSY9541B9AC9”}})
			if(!StringUtils.isEmpty(bizinfo.getSuccsessCash())){
				
				String resp = HttpClientUtil.get(queryCashURL+"?cashNo="+bizinfo.getSuccsessCash());
				if(resp!= null && resp.indexOf("callback(") != -1){
					resp = resp.substring("callback(".length(), resp.length() - 1);
					JSONObject json = new JSONObject(resp);
					if(json.getInt("rtn") == 0){
						succCashMoney = json.getInt("parValue");
						
					}
				}
			}
		}catch(Exception e){
			
		}
		

		try{
			//callback({“rtn”:0,”data”:{“groupNo”:1000,”expireDate”:“2015-06-30”,”parValue”:100.0,”minPayMoney”:100.0,”limitNo”:“1”,”cashStatus”:“0”,”cashNo”:“0000004SSY9541B9AC9”}})
			if(!StringUtils.isEmpty(bizinfo.getSuccsessVoucher())){
				
				String resp = HttpClientUtil.get(queryCashURL+"?cashNo="+bizinfo.getSuccsessVoucher());
				if(resp!= null && resp.indexOf("callback(") != -1){
					resp = resp.substring("callback(".length(), resp.length() - 1);
					JSONObject json = new JSONObject(resp);
					if(json.getInt("rtn") == 0){
						succVouMoney = json.getInt("parValue");
						succsessVoucherLimitMoney = json.getInt("minPayMoney");
					}
				}
			}
		}catch(Exception e){
			
		}

		try{
			//callback({“rtn”:0,”data”:{“groupNo”:1000,”expireDate”:“2015-06-30”,”parValue”:100.0,”minPayMoney”:100.0,”limitNo”:“1”,”cashStatus”:“0”,”cashNo”:“0000004SSY9541B9AC9”}})
			if(!StringUtils.isEmpty(bizinfo.getFailCash())){
				
				String resp = HttpClientUtil.get(queryCashURL+"?cashNo="+bizinfo.getFailCash());
				if(resp!= null && resp.indexOf("callback(") != -1){
					resp = resp.substring("callback(".length(), resp.length() - 1);
					JSONObject json = new JSONObject(resp);
					if(json.getInt("rtn") == 0){
						failCashMoney = json.getInt("parValue");
						
					}
				}
			}
		}catch(Exception e){
			
		}
		
		try{
			//callback({“rtn”:0,”data”:{“groupNo”:1000,”expireDate”:“2015-06-30”,”parValue”:100.0,”minPayMoney”:100.0,”limitNo”:“1”,”cashStatus”:“0”,”cashNo”:“0000004SSY9541B9AC9”}})
			if(!StringUtils.isEmpty(bizinfo.getFailVoucher())){
				
				String resp = HttpClientUtil.get(queryCashURL+"?cashNo="+bizinfo.getFailVoucher());
				if(resp!= null && resp.indexOf("callback(") != -1){
					resp = resp.substring("callback(".length(), resp.length() - 1);
					JSONObject json = new JSONObject(resp);
					if(json.getInt("rtn") == 0){
						failVouMoney = json.getInt("parValue");
						failVoucherLimitMoney = json.getInt("minPayMoney");
					}
				}
			}
		}catch(Exception e){
			
		}

		//计算总金额
		succMoney = succCashMoney + succVouMoney;
		failMoney = failCashMoney + failVouMoney;
		
		bizinfo.setSuccsessMoney(""+succMoney);
		bizinfo.setSuccsessCashMoney(""+succCashMoney);
		bizinfo.setSuccsessVoucherMoney(""+succVouMoney);
		bizinfo.setSuccsessVoucherLimitMoney(""+succsessVoucherLimitMoney);
		bizinfo.setFailMoney(""+failMoney);
		bizinfo.setFailCashMoney(""+failCashMoney);
		bizinfo.setFailVoucherMoney(""+failVouMoney);
		bizinfo.setFailVoucherLimitMoney(""+failVoucherLimitMoney);
	}

}
