package com.xunlei.niux.manager.web.model.coin;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.coin.facade.FacadeFactory;
import com.xunlei.niux.data.coin.vo.CoinTrans;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_COINTRANS)
public class CoinTransManagedBean extends BaseManagedBean{
	public String getQueryCoinTransList(){
		this.authenticateRun();//验证运行权限
		CoinTrans query=findBean(CoinTrans.class,"cointrans");
		PagedFliper pagedFliper = this.getFliper();
		Page page=new Page();
		page.setPageNo(pagedFliper.getPageNo());
		page.setPageSize(pagedFliper.getPageSize());
		page.addOrder("transTime", OrderType.DESC);
		int count=FacadeFactory.INSTANCE.getCoinTransBo().count(query);
		List<CoinTrans> list=null;
		if(count>0){
			list=FacadeFactory.INSTANCE.getCoinTransBo().find(query, page);
		}
		if(list==null){
			list=new ArrayList<CoinTrans>();
		}
		Sheet<CoinTrans> sheet = new Sheet<CoinTrans>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
}
