package com.xunlei.niux.manager.web.model.coin;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.coin.bo.BizInfoBo;
import com.xunlei.niux.data.coin.facade.FacadeFactory;
import com.xunlei.niux.data.coin.vo.BizInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
* 欢乐券业务处理类
* @author ljm
*  2015-10-27
*/
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_BIZINFO_COIN)
public class CoinBiziInfoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CoinBiziInfoManagedBean.class.getName());
	private static String updateCacheURL = "http://coin.niu.xunlei.com:7080/updatebizinfocache.do";
	private BizInfoBo bizInfoBo;
	private int rownum = 0;

	public CoinBiziInfoManagedBean(){
		bizInfoBo = FacadeFactory.INSTANCE.getBizInfoBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}


	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询业务信息
	 * @return
	 */
	public String getQueryBiziInfoList(){
		logger.info("开始业务信息查询");
        this.authenticateRun();//验证运行权限
        BizInfo bizInfo = findBean(BizInfo.class, "coinbizinfo");
        PagedFliper pagedFliper = this.getFliper();
        int count = bizInfoBo.count(bizInfo);
        pagedFliper.setRecordCount(count);
        List<BizInfo> list = new ArrayList<BizInfo>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = bizInfoBo.find(bizInfo, page);
        }
        Sheet<BizInfo> sheet = new Sheet<BizInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	/**
	 * 新增业务信息
	 * @return
	 */
	public String add(){
		logger.info("开始业务信息添加");
		this.authenticateAdd();//添加权限
		BizInfo bizinfo = this.findBean(BizInfo.class,"coinbizinfo");
        try{
			if(bizinfo==null){
				logger.info("业务信息为空");
				throw new XLRuntimeException("业务信息为空");
			}
			bizinfo.setInputBy(currentUserLogo());
			bizinfo.setInputTime(now());

			bizInfoBo.insert(bizinfo);
			
			String r = HttpClientUtil.get(updateCacheURL);
			if(r.indexOf("\"code\":\"00\"") == -1){
				logger.info("更新抽奖信息缓存失败");
				throw new XLRuntimeException("更新抽奖信息缓存失败");
			}
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}

	/**
	 * 修改业务信息
	 * @return
	 */
	public String edit(){
		logger.info("开始业务信息修改");
		this.authenticateEdit();//编辑权限
		BizInfo bizinfo=this.findBean(BizInfo.class,"coinbizinfo");
		try{
			if(bizinfo==null){
				logger.info("业务为空");
				throw new XLRuntimeException("业务为空");
			}
			bizinfo.setEditBy(this.currentUserLogo());
			bizinfo.setEditTime(now());
			bizInfoBo.update(bizinfo);
			
			String r = HttpClientUtil.get(updateCacheURL);
			if(r.indexOf("\"code\":\"00\"") == -1){
				logger.info("更新抽奖信息缓存失败");
				throw new XLRuntimeException("更新抽奖信息缓存失败");
			}
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}



}
