package com.xunlei.niux.manager.web.model.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentServers;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 接入游戏业务处理类
 * @author lujianming
 * 2015-02-04
 */
public class AgentServersManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentServersManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
	private List<SelectItem> fenQuStatusList;
	private Map<String,String> fenQuStatusMap;
    private static final Page page = new Page();
    private String agentId;
    private String serverId;
    private String gameId;

	public String getAgentId() {
		return agentId;
	}

	public String getServerId() {
		return serverId;
	}

	public String getGameId() {
		return gameId;
	}

	public void setAgentId(String agentId) {
		this.agentId = agentId;
	}

	public void setServerId(String serverId) {
		this.serverId = serverId;
	}

	public void setGameId(String gameId) {
		this.gameId = gameId;
	}

	public AgentServersManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	public Map<String, String> getFenQuStatusMap() {
		if(fenQuStatusMap==null){
			Map<String,String> map=new HashMap<String,String>();
			map.put("0", "未开区");
			map.put("1", "已开区");
			map.put("2", "已关闭");
			map.put("3", "维护中");
			map.put("4", "测试中");
			fenQuStatusMap=map;
		}
		return fenQuStatusMap;
	}
	public void setFenQuStatusMap(Map<String, String> fenQuStatusMap) {
		this.fenQuStatusMap = fenQuStatusMap;
	}
	public List<SelectItem> getFenQuStatusList() {
		if(fenQuStatusList==null){
			Map<String,String> map=getFenQuStatusMap();
			List<SelectItem> silist=new ArrayList<SelectItem>();
			if(map!=null){
				Set<String> keySet=map.keySet();
				Iterator<String> it=keySet.iterator();
				while(it.hasNext()){
					String key=it.next();
					String value=map.get(key);
					SelectItem si=new SelectItem();
					si.setValue(key);
					si.setLabel(value);
					silist.add(si);
				}
			}
			silist=fenQuStatusList;
		}
		return fenQuStatusList;
	}
	public void setFenQuStatusList(List<SelectItem> fenQuStatusList) {
		this.fenQuStatusList = fenQuStatusList;
	}
	/**
	 * 查询接入游戏
	 * @return
	 */
	public String getQueryAgentServersList(){		
	    logger.info("开始接入游戏查询");
        this.authenticateRun();//验证运行权限
        AgentServers query = new AgentServers();//findBean(AgentServers.class, "agentservers");
        
        query.setAgentId(agentId);
        query.setGameId(gameId);
        query.setServerId(serverId);
        
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentServers> list = new ArrayList<AgentServers>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<AgentServers> sheet = new Sheet<AgentServers>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增接入游戏
	 * @return
	 */
	public String add(){
		logger.info("开始接入游戏信息添加");
		this.authenticateAdd();//添加权限
		AgentServers type = findBean(AgentServers.class, "agentservers");
		try{
			if(type==null){
				logger.info("接入游戏信息为空");
				throw new XLRuntimeException("接入游戏信息为空");
			}		
			int serverId = Integer.parseInt(type.getServerId());	
			AgentServers query = new AgentServers();
            query.setAgentId(type.getAgentId());
            query.setGameId(type.getGameId());
            query.setServerId(type.getServerId());
            AgentServers rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该接入区服已经存在");
				throw new XLRuntimeException("该接入区服已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
            
            if(type.getFenQuNum() == 0){
            	type.setFenQuNum(serverId);
            }
			baseSo.addObject(type);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改接入游戏
	 * @return
	 */
	public String edit(){
		logger.info("开始接入游戏信息修改");
		this.authenticateEdit();//编辑权限
		AgentServers type = findBean(AgentServers.class, "agentservers");
		try{
			if(type==null){
				logger.info("接入游戏信息为空");
				throw new XLRuntimeException("接入游戏信息为空");
			}
			int serverId = Integer.parseInt(type.getServerId());
			AgentServers query = new AgentServers();
			query.setGameId(type.getGameId());
			AgentServers myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该接入游戏已经存在");
    				throw new XLRuntimeException("该接入游戏已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
            
            if(type.getFenQuNum() == 0){
            	type.setFenQuNum(serverId);
            }
            
			baseSo.updateObjectById(type);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除接入游戏
	 * @return
	 */
	public String delete(){
		logger.info("开始接入游戏信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(AgentServers.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
