package com.xunlei.niux.manager.web.model.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentPlatform;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 接入平台业务处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentPlatformManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentPlatformManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();
    private static Map<String,String> agentPlatformMap;
    private static List<SelectItem> agentPlatformList;
      	
	public AgentPlatformManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	public Map<String, String> getAgentPlatformMap() {
		if(agentPlatformMap == null){
			initAgentPlatformMap();
		}
      
		return agentPlatformMap;
	}
	
	public void initAgentPlatformMap(){
		   Map<String,String> tempMap=new HashMap<String,String>();
		   AgentPlatform query=new AgentPlatform();
	        Page mypage = new Page();
	        mypage.addOrder("inputTime", OrderType.DESC);
			List<AgentPlatform> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,mypage);
	        if(bplist!=null){
	        	for(AgentPlatform type:bplist){
	        		tempMap.put(type.getPlatformNo(), type.getPlatformName()); 	
				}
	        }
	        agentPlatformMap=tempMap;
	}
	
	public List<SelectItem> getAgentPlatformList(){
		if(agentPlatformList == null){
			initAgentPlatformList();
		}		
		return agentPlatformList;
	}
	
	private void initAgentPlatformList(){		
		AgentPlatform query=new AgentPlatform();
		List<AgentPlatform> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(AgentPlatform type:bplist){
			siList.add(new SelectItem(type.getPlatformNo(), type.getPlatformName())); 	
		}
		agentPlatformList = siList;
	}
	
	/**
	 * 查询接入平台
	 * @return
	 */
	public String getQueryAgentPlatformList(){		
	    logger.info("开始接入平台查询");
        this.authenticateRun();//验证运行权限
        AgentPlatform query = findBean(AgentPlatform.class, "agentplatform");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentPlatform> list = new ArrayList<AgentPlatform>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<AgentPlatform> sheet = new Sheet<AgentPlatform>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增接入平台
	 * @return
	 */
	public String add(){
		logger.info("开始接入平台信息添加");
		this.authenticateAdd();//添加权限
		AgentPlatform type = findBean(AgentPlatform.class, "agentplatform");
		try{
			if(type==null){
				logger.info("接入平台信息为空");
				throw new XLRuntimeException("接入平台信息为空");
			}		
			AgentPlatform query = new AgentPlatform();
            query.setPlatformNo(type.getPlatformNo());
            AgentPlatform rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该接入平台已经存在");
				throw new XLRuntimeException("该接入平台已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
			initAgentPlatformMap();
			initAgentPlatformList();
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改接入平台
	 * @return
	 */
	public String edit(){
		logger.info("开始接入平台信息修改");
		this.authenticateEdit();//编辑权限
		AgentPlatform type = findBean(AgentPlatform.class, "agentplatform");
		try{
			if(type==null){
				logger.info("接入平台信息为空");
				throw new XLRuntimeException("接入平台信息为空");
			}
			AgentPlatform query = new AgentPlatform();
			query.setPlatformNo(type.getPlatformNo());
			AgentPlatform myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该接入平台已经存在");
    				throw new XLRuntimeException("该接入平台已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);		
			initAgentPlatformMap();
			initAgentPlatformList();
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除接入平台
	 * @return
	 */
	public String delete(){
		logger.info("开始接入平台信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(AgentPlatform.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
