package com.xunlei.niux.manager.web.model.business;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.*;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.DataFormatUtil;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.MoneyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * 营收月结处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentMonthIncomeManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(AgentMonthIncomeManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();
    private static Map<Integer,String> agentMap;
    static{
        if(agentMap==null){
            agentMap  = new HashMap<Integer,String>();
            agentMap.put(1, "研发方");
            agentMap.put(2, "接入平台");
        }
    }

    public AgentMonthIncomeManagedBean(){
        baseSo = FacadeFactory.INSTANCE.getBaseSo();
        //初始化行号
        int pageNo=this.getFliper().getPageNo();
        int pageSize=this.getFliper().getPageSize();
        rownum=rownum+(pageNo-1)*pageSize+1;
    }

    public int getRownum() {
        return rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    private String getAgentId(AgentMonthIncome income,int systemType){
        String gameId = income.getGameId();
        if(systemType==1){//研发方
            AgentDevelopmentGames query = new AgentDevelopmentGames();
            query.setGameId(gameId);
            AgentDevelopmentGames games = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(games==null)return null;
            return games.getDevelopNo();
        }else{//接入平台
            return income.getPlatformNo();
        }
    }
    /**
     * 对账账单
     */
    public void exportCheck() {
        HttpServletResponse response = (HttpServletResponse) FacesContext.getCurrentInstance().getExternalContext()
                .getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        String seqid = findParameter("seqid");
        String companyType = findParameter("companyType");
        AgentMonthIncome income = baseSo.findById(AgentMonthIncome.class, seqid);
        AgentGamesManagedBean games = new AgentGamesManagedBean();
        String gameName =  games.getAgentGamesMap().get(income.getGameId());
        String month = income.getMonth().substring(0, 4) + "年" + income.getMonth().substring(5) + "月";
        String fileName = gameName + month + "对账单";

        //合作方公司名
        AgentForum cpTemp = new AgentForum();
        int systemType =Integer.parseInt(companyType);
        String agentId = getAgentId(income,systemType);
        cpTemp.setCompanyType(systemType);
        cpTemp.setAgentId(agentId);
        AgentForum forum = baseSo.findObject(cpTemp);//合作方信息
        if(forum==null){
            throw new XLRuntimeException(("1".equals(companyType)?"研发方":"接入平台")+"公司信息为空");
        }

        String simpleName = forum.getSimpleName();
        fileName = simpleName+"_"+fileName;
        try {
            fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
        } catch (UnsupportedEncodingException e) {
        }

        response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
        InputStream inp = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream("/excel/agentcheck.xls");

        try {
            Workbook wb = WorkbookFactory.create(inp);
            wb.setSheetName(0, month + "结算确认函");
            org.apache.poi.ss.usermodel.Sheet sheet = wb.getSheetAt(0);

            String compareName = forum.getCompareName();
            sheet.getRow(5).getCell(4).setCellValue(compareName);
            //合作方简称
            sheet.getRow(6).getCell(8).setCellValue(simpleName);
            //月份
            sheet.getRow(7).getCell(0).setCellValue(month);

            //游戏名称
            sheet.getRow(7).getCell(2).setCellValue(gameName);

            //收入总额
            sheet.getRow(7).getCell(4).setCellValue(income.getTotalMoney());
            //迅雷分成
            sheet.getRow(7).getCell(6).setCellValue(income.getXunleiMoney());

            if("1".equals(companyType)){//研发方
                //合作方分成
                sheet.getRow(7).getCell(8).setCellValue(income.getDevelopMoney());

                //支付金额
                sheet.getRow(8).getCell(1).setCellValue(income.getDevelopMoney());
                sheet.getRow(8).getCell(6).setCellValue(MoneyUtil.toChinese(income.getDevelopMoney()+""));
                sheet.getRow(9).getCell(1).setCellValue("");
                sheet.getRow(9).getCell(3).setCellValue("");

            }else{//接入平台
                sheet.getRow(7).getCell(8).setCellValue(income.getParterMoney());

                //支付金额
                sheet.getRow(8).getCell(1).setCellValue(income.getXunleiMoney());
                sheet.getRow(8).getCell(6).setCellValue(MoneyUtil.toChinese(income.getXunleiMoney()+""));

                //测试账号
                AgentTestIncome testIncome = new AgentTestIncome();
                testIncome.setGameId(income.getGameId());
                testIncome.setAgentId(income.getPlatformNo());
                List<AgentTestIncome> testIncomeList =  baseSo.findObjects(testIncome, new Page());
                if (CollectionUtils.isNotEmpty(testIncomeList)) {
                    AgentTestIncome temp = testIncomeList.get(0);
                    sheet.getRow(9).getCell(1).setCellValue(temp.getAccount());
                    sheet.getRow(9).getCell(3).setCellValue(temp.getMoney());
                }else{
                    sheet.getRow(9).getCell(1).setCellValue("");
                    sheet.getRow(9).getCell(3).setCellValue("");
                }
            }



//            for(int i=0 ;i < testIncomeList.size(); i++) {
//            	AgentTestIncome temp = testIncomeList.get(i);
//                if(i <= 1) {
//                    sheet.getRow(9 + i).getCell(1).setCellValue(temp.getAccount());
//                    sheet.getRow(9 + i).getCell(3).setCellValue(temp.getMoney());
//                } else {
//                    Row targetRow = sheet.createRow(9 + i);
//                    Row defaultRow = sheet.getRow(9);
//                    copyStyle(targetRow, defaultRow, 0).setCellValue("测试账号" + i + 1);
//                    copyStyle(targetRow, defaultRow, 1).setCellValue(temp.getAccount());
//                    copyStyle(targetRow, defaultRow, 2).setCellValue("测试账号金额" + i + 1);
//                    copyStyle(targetRow, defaultRow, 3).setCellValue(temp.getMoney());
//                }
//            }

            //分成方式说明
            sheet.getRow(9).getCell(6).setCellValue(getBalancedesc(income.getPlatformNo(),income.getGameId(),systemType));

            //甲方
            //sheet.getRow(12).getCell(1).setCellValue(compareName);

            //乙方
            sheet.getRow(12).getCell(6).setCellValue(forum.getCompareName());

            //开户银行
            sheet.getRow(13).getCell(6).setCellValue(forum.getBankName());

            //银行账号
            sheet.getRow(14).getCell(6).setCellValue(forum.getBankAccount());
            //是否为一般纳税人
            if(forum.getIsTaxer()){
                sheet.getRow(15).getCell(6).setCellValue("是（√）");
                sheet.getRow(15).getCell(7).setCellValue("否（　）");
            }else{
                sheet.getRow(15).getCell(6).setCellValue("是（ ）");
                sheet.getRow(15).getCell(7).setCellValue("否（√）");
            }
            //开票类型
            sheet.getRow(16).getCell(6).setCellValue(forum.getFaxType());
            //纳税人识别号
            sheet.getRow(17).getCell(6).setCellValue(forum.getFaxerNumber());
            //银行账户及账号
            sheet.getRow(18).getCell(6).setCellValue(forum.getBankAccountUsername());
            //注册地址
            sheet.getRow(19).getCell(6).setCellValue(forum.getRegisterAddress());
            //通信地址
            sheet.getRow(20).getCell(6).setCellValue(forum.getCommunicationAddress());
            //联系人
            sheet.getRow(21).getCell(6).setCellValue(forum.getInterfaceMan());
            //联系电话
            sheet.getRow(22).getCell(6).setCellValue(forum.getContactNumber());
            OutputStream os  = response.getOutputStream();
            wb.write(os);
        } catch (Exception e) {
            logger.error("导出excel出错", e);
            alertJS("导出excel出错,原因:" + e.getMessage());
        }

        FacesContext.getCurrentInstance().responseComplete();
    }

    private Cell copyStyle(Row targetRow, Row defaultRow, int num) {
        Cell cell = targetRow.createCell(num);
        cell.setCellStyle(defaultRow.getCell(num).getCellStyle());
        return cell;
    }


    private String getBalancedesc(String agentId,String gameId,int systemType) {
        AgentIntoSystem intoSystem = new AgentIntoSystem();
        intoSystem.setGameid(gameId);
        intoSystem.setAgentId(agentId);
        intoSystem.setSystemType(systemType);
        List<AgentIntoSystem> list = baseSo.findObjects(intoSystem, page);
        if(CollectionUtils.isNotEmpty(list)) {
            AgentIntoSystem one = list.get(0);
            if(one.getSystype().intValue()==0) {
                return "分成比例:"+agentMap.get(systemType)+"分成" + one.getIntoratio() + "%";
            } else if(!one.getNoregulartype()) {
                StringBuilder desc = new StringBuilder("不固定类型:按区间值 ");
                for (AgentIntoSystem temp : list) {
                    desc.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                            .append(", "+agentMap.get(systemType)+"分成 : ")
                            .append(temp.getIntoratio()).append("% ;");
                }
                return desc.toString();
            } else {
                StringBuilder desc = new StringBuilder("不固定类型:按区间增量值 ");
                int i = 0;
                for (AgentIntoSystem temp : list) {
                    desc.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                            .append(", "+agentMap.get(systemType)+"分成 : ( 收益 - ").append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                            .append("% ")
                            .append(descNoregulartype(list, i)).append(";");

                    i++;
                }
                return desc.toString();
            }
        }

        return null;
    }

    private String descNoregulartype(List<AgentIntoSystem> list, int i) {
        StringBuilder builder = new StringBuilder(" ");

        if (i == 0) {
            return builder.toString();
        } else {
            final AgentIntoSystem temp = list.get(i - 1);
            builder.append(" + (").append(changNum(temp.getEndmoney())).append(" - ")
                    .append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                    .append("% ");

            return builder.append(descNoregulartype(list, i - 1)).toString();
        }
    }

    private long changNum(int money) {
        return money * 10000L ;
    }

    /**
     * 查询营收月结数据
     * @return
     */
    public String getQueryAgentMonthIncomeList(){
        logger.info("开始营收月结数据查询");
        this.authenticateRun();//验证运行权限
        AgentMonthIncome query = findBean(AgentMonthIncome.class, "agentmonthincome");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentMonthIncome> list = new ArrayList<AgentMonthIncome>();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("month", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        for(AgentMonthIncome income:list){
            income.setDevelopMoney(DataFormatUtil.format(income.getDevelopMoney()));
            income.setParterMoney(DataFormatUtil.format(income.getParterMoney()));
            income.setRealMoney(DataFormatUtil.format(income.getRealMoney()));
            income.setRealTotalMoney(DataFormatUtil.format(income.getRealTotalMoney()));
            income.setTestMoney(DataFormatUtil.format(income.getTestMoney()));
            income.setTotalMoney(DataFormatUtil.format(income.getTotalMoney()));
            income.setXunleiMoney(DataFormatUtil.format(income.getXunleiMoney()));
        }
        Sheet<AgentMonthIncome> sheet = new Sheet<AgentMonthIncome>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


    /**
     * 将查询的数据导到excel中
     */
    public void export(){
        logger.info("开始营收月结导出到excel文件");
        AgentMonthIncome query = findBean(AgentMonthIncome.class, "agentmonthincome");
        Page page = new Page();
        page.addOrder("month", OrderType.DESC);
        List<AgentMonthIncome> crlist = baseSo.findObjects(query, page);
        //获得系统当前时间
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String now = sdf.format(new Date());
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
        //更新标题
        String title = "营收月结";
        AgentGamesManagedBean agmb = new AgentGamesManagedBean();
        Map<String,String> agentGamesMap = agmb.getAgentGamesMap();
        AgentPlatformManagedBean apmb = new AgentPlatformManagedBean();
        Map<String,String> agentPlatformMap = apmb.getAgentPlatformMap();
        List datas = new ArrayList();
        for(AgentMonthIncome cr:crlist){
            List list = new ArrayList();
            list.add(agentPlatformMap.get(cr.getPlatformNo()));
            list.add(agentGamesMap.get(cr.getGameId()));
            list.add(cr.getMonth());
            list.add(cr.getTotalMoney());
            list.add(cr.getTestMoney());
            list.add(cr.getRealTotalMoney());
            list.add(cr.getXunleiMoney());
            list.add(cr.getParterMoney());
            list.add(cr.getDevelopMoney());
            list.add(cr.getRealMoney());
            datas.add(list);
        }
        //生成数据到excel中
        String[] columnName = {"平台","游戏", "月份", "总营收", "测试金额","实际总营收","迅雷营收","合作方营收","研发方营收","实际收款金额"};
        String filePath = "/tmp/agentmonthincome.xls";
        long beginTime = System.currentTimeMillis();
        Workbook wb = ExcelUtil.create("营收月结",title,columnName,filePath,datas);
        long endTime = System.currentTimeMillis();
        logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");

        //弹出下载窗口
        response.setHeader("Content-disposition", "attachment;filename="+now+"_agentmonthincome.xls");
        response.setContentType("application/x-download");
        OutputStream ouputStream = null;
        try {
            ouputStream = response.getOutputStream();
            wb.write(ouputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }finally{
            if(datas != null){
                datas.clear();
                datas = null;
            }
        }
        FacesContext.getCurrentInstance().responseComplete();
    }

}
