package com.xunlei.niux.manager.web.model.business;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentIntoSystem;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.util.StringTools;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lisu
 *  2015-01-20
 */

public class AgentIntoSystemManagedBean extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(AgentIntoSystemManagedBean.class);
    private BaseSo baseSo;
    
    private static  Map<Integer,String> systemTypeMap =null;
    static{
    	if(systemTypeMap==null){
    		systemTypeMap = new HashMap<Integer,String>();
    		systemTypeMap.put(1, "研发方");
    		systemTypeMap.put(2, "接入平台");
    	}
    }
    
    public AgentIntoSystemManagedBean(){
    	baseSo = FacadeFactory.INSTANCE.getBaseSo();
    }
    private static final Page queryPage = new Page();

    private Ponit ponit1 = new Ponit();

    private Ponit ponit2 = new Ponit();

    private Ponit ponit3 = new Ponit();

    private Ponit ponit4 = new Ponit();

    private Ponit ponit5 = new Ponit();
    
    private Ponit ponit6 = new Ponit();

    private Ponit ponit7 = new Ponit();

    private Ponit ponit8 = new Ponit();

    private Ponit ponit9 = new Ponit();

    private Ponit ponit10 = new Ponit();
    private Integer mysystype;
    private Integer mypsystype;
    private Integer myintoratio;
    private Integer mypntoratio;
    private Boolean mynoregulartype;
    private Boolean mypnoregulartype;
    
    

	public Boolean getMynoregulartype() {
		return mynoregulartype;
	}

	public void setMynoregulartype(Boolean mynoregulartype) {
		this.mynoregulartype = mynoregulartype;
	}

    
	public Boolean getMypnoregulartype() {
		return mypnoregulartype;
	}

	public void setMypnoregulartype(Boolean mypnoregulartype) {
		this.mypnoregulartype = mypnoregulartype;
	}

	public Integer getMysystype() {
		return mysystype;
	}

	public Integer getMypsystype() {
		return mypsystype;
	}

	public Integer getMyintoratio() {
		return myintoratio;
	}

	public Integer getMypntoratio() {
		return mypntoratio;
	}


	public void setMysystype(Integer mysystype) {
		this.mysystype = mysystype;
	}


	public void setMypsystype(Integer mypsystype) {
		this.mypsystype = mypsystype;
	}


	public void setMyintoratio(Integer myintoratio) {
		this.myintoratio = myintoratio;
	}


	public void setMypntoratio(Integer mypntoratio) {
		this.mypntoratio = mypntoratio;
	}

	public Ponit getPonit6() {
		return ponit6;
	}

	public void setPonit6(Ponit ponit6) {
		this.ponit6 = ponit6;
	}

	public Ponit getPonit7() {
		return ponit7;
	}

	public void setPonit7(Ponit ponit7) {
		this.ponit7 = ponit7;
	}

	public Ponit getPonit8() {
		return ponit8;
	}

	public void setPonit8(Ponit ponit8) {
		this.ponit8 = ponit8;
	}

	public Ponit getPonit9() {
		return ponit9;
	}

	public void setPonit9(Ponit ponit9) {
		this.ponit9 = ponit9;
	}

	public Ponit getPonit10() {
		return ponit10;
	}

	public void setPonit10(Ponit ponit10) {
		this.ponit10 = ponit10;
	}
	private Integer num = 1;
    private Integer num2 = 1;

   
	public Integer getNum2() {
		return num2;
	}

	public void setNum2(Integer num2) {
		this.num2 = num2;
	}
	private Boolean editStatus;

    public Boolean getEditStatus() {
        return editStatus;
    }

    public void setEditStatus(Boolean editStatus) {
        this.editStatus = editStatus;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public Ponit getPonit1() {
        return ponit1;
    }

    public void setPonit1(Ponit ponit1) {
        this.ponit1 = ponit1;
    }

    public Ponit getPonit2() {
        return ponit2;
    }

    public void setPonit2(Ponit ponit2) {
        this.ponit2 = ponit2;
    }

    public Ponit getPonit3() {
        return ponit3;
    }

    public void setPonit3(Ponit ponit3) {
        this.ponit3 = ponit3;
    }

    public Ponit getPonit4() {
        return ponit4;
    }

    public void setPonit4(Ponit ponit4) {
        this.ponit4 = ponit4;
    }

    public Ponit getPonit5() {
        return ponit5;
    }

    public void setPonit5(Ponit ponit5) {
        this.ponit5 = ponit5;
    }

    public void initTwoList(List<AgentIntoSystem> list,List<AgentIntoSystem> oneList,List<AgentIntoSystem> twoList){
    	for(AgentIntoSystem out:list){
    		if(out.getSystemType().intValue()==1){
    			oneList.add(out);
    		}else{
    			twoList.add(out);
    		}
    	}
    }
    public String getQueryList() {
        this.authenticateRun();//验证运行权限
        //AgentIntoSystem system = findBean(AgentIntoSystem.class, "agentintosystem");
        AgentIntoSystem system = new AgentIntoSystem();
        String agentintosystem_gameid = this.findParameter("agentintosystem_gameid");
        String agentintosystem_agentId = this.findParameter("agentintosystem_agentId");
        if(!StringTools.isEmpty(agentintosystem_agentId)){
        	system.setAgentId(agentintosystem_agentId);
        }
        if(!StringTools.isEmpty(agentintosystem_gameid)){
        	system.setGameid(agentintosystem_gameid);
        }
        if(system.getGameid() == null) {
        	system.setGameid(GameCache.getInstance().getGameIdSelectItemList().get(0).getValue().toString());
        } 
      
        int count = baseSo.countObject(system);

        List<AgentIntoSystem> outList = new ArrayList<AgentIntoSystem>();
        
        if (count > 0) {
        	Page page = new Page();
        	page.addOrder("systemType", OrderType.ESC);
        	page.addOrder("beginmoney", OrderType.ESC);
            List<AgentIntoSystem> list = baseSo.findObjects(system, page);
            List<AgentIntoSystem> oneList = new ArrayList<AgentIntoSystem>();
            List<AgentIntoSystem> twoList = new ArrayList<AgentIntoSystem>();
            setSize(list);
            
            initTwoList(list,oneList,twoList);
            AgentIntoSystem AgentIntoSystem1 = new AgentIntoSystem();
            AgentIntoSystem one = list.get(0);
            AgentIntoSystem1.setGameid(one.getGameid());
            AgentIntoSystem1.setAgentId(one.getAgentId());            
            count = 1;
            addResult(outList,oneList,AgentIntoSystem1,1);
            addResult(outList,twoList,AgentIntoSystem1,2);
            outList.add(AgentIntoSystem1);
        }
        //resetData();
        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);

        Sheet<AgentIntoSystem> sheet = new Sheet<AgentIntoSystem>(count, outList);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }
    
    private void resetData(){
        mysystype = 0;
        mysystype = 0;
        myintoratio = 0;
        mypntoratio = 0;
        mynoregulartype = false;
        mypnoregulartype = false;
        Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
        map.put(1,ponit1);
        map.put(2,ponit2);
        map.put(3,ponit3);
        map.put(4,ponit4);
        map.put(5,ponit5);
        map.put(6,ponit6);
        map.put(7,ponit7);
        map.put(8,ponit8);
        map.put(9,ponit9);
        map.put(10,ponit10);
        for(int i=1;i<map.size();i++){
        	Ponit ponit = map.get(i);
        	ponit.setBegin("");
        	ponit.setEnd("");
        	ponit.setPonit("");
        }
        num = 0;
        num2 = 0;
    }
    
    private void setSize( List<AgentIntoSystem> list){
    	if(CollectionUtils.isEmpty(list))return;
        Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
        map.put(1,ponit1);
        map.put(2,ponit2);
        map.put(3,ponit3);
        map.put(4,ponit4);
        map.put(5,ponit5);
        Map<Integer, Ponit> map2 = new HashMap<Integer, Ponit>();
        map2.put(1,ponit6);
        map2.put(2,ponit7);
        map2.put(3,ponit8);
        map2.put(4,ponit9);
        map2.put(5,ponit10);
    	int count = 0;
    	int count2 = 0;
    	for(AgentIntoSystem s:list){
    		if(s.getSystemType().intValue()==1){
    			if(s.getSystype().intValue()==1){
    				count ++;
    				Ponit point = map.get(count);
    				if(point==null)continue;
    				point.setBegin(s.getBeginmoney()+"");
    				point.setEnd(s.getEndmoney()==0?"∞":s.getEndmoney()+"");
    				point.setPonit(s.getIntoratio()+"");
    			}
    		}
    		if(s.getSystemType().intValue()==2){
    			if(s.getSystype().intValue()==1){
    				count2 ++;
    				Ponit point = map2.get(count2);
    				if(point==null)continue;
    				point.setBegin(s.getBeginmoney()+"");
    				point.setEnd(s.getEndmoney()==0?"∞":s.getEndmoney()+"");
    				point.setPonit(s.getIntoratio()+"");
    			}
    		}
    	}
    	this.num = count;
    	this.num2 = count2;
    }
    
   
    private void addResult(List<AgentIntoSystem> outList,List<AgentIntoSystem> list,AgentIntoSystem AgentIntoSystem1,int systemType){
    	  if(CollectionUtils.isEmpty(list))return;   	 
    	  AgentIntoSystem one = list.get(0);
          final Integer systype = one.getSystype();
          final Boolean noregulartype = one.getNoregulartype();
          AgentIntoSystem1.setNoregulartype(noregulartype);
          if(systype.intValue()==0) {//固定分成
        	  if(systemType==1){
        		  AgentIntoSystem1.setDesc("分成比例:研发方分成" + one.getIntoratio() + "%");
        	  }else if(systemType==2){
        		  AgentIntoSystem1.setPdesc("分成比例:接入平台分成" + one.getIntoratio() + "%");
        	  }             
          } else  {//不固定分成
              StringBuilder desc = new StringBuilder("不固定类型:");
              if(!noregulartype) {
                  desc.append("按区间值 ");

                  for (AgentIntoSystem temp : list) {
                      desc.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                              .append(", "+systemTypeMap.get(systemType)+"分成 : ")
                              .append(temp.getIntoratio()).append("% ;");
                  }
              } else {
                  desc.append("按区间增量值 ");
                  int i = 0;
                  for (AgentIntoSystem temp : list) {
                      desc.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                              .append(", "+systemTypeMap.get(systemType)+"分成 : ( 收益 - ").append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                              .append("% ")
                              .append(descNoregulartype(list, i)).append(";");
                      i++;
                  }
              }
              if(systemType==1){
            	  AgentIntoSystem1.setDesc(desc.toString());
              }else if(systemType==2){
            	  AgentIntoSystem1.setPdesc(desc.toString());
              }   
          }
          if(systemType==1){
    		  AgentIntoSystem1.setSystype(one.getSystype());
    		  AgentIntoSystem1.setIntoratio(one.getIntoratio());
    		  AgentIntoSystem1.setNoregulartype(one.getNoregulartype());
    		  this.myintoratio = one.getIntoratio();
    		  this.mynoregulartype = one.getNoregulartype();
    		  this.mysystype = one.getSystype();
          }else if(systemType==2){
    		  AgentIntoSystem1.setPsystype(one.getSystype());
    		  AgentIntoSystem1.setPintoratio(one.getIntoratio());
    		  AgentIntoSystem1.setPnoregulartype(one.getNoregulartype());
    		  this.mypntoratio = one.getIntoratio();
    		  this.mypnoregulartype = one.getNoregulartype();
    		  this.mypsystype = one.getSystype();
          }        

    }

    private String descNoregulartype(List<AgentIntoSystem> list, int i) {
        StringBuilder builder = new StringBuilder(" ");
        if (i == 0) {
            return builder.toString();
        } else {
            final AgentIntoSystem temp = list.get(i - 1);
            builder.append(" + (").append(changNum(temp.getEndmoney())).append(" - ")
                    .append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                    .append("% ");

            return builder.append(descNoregulartype(list, i - 1)).toString();
        }
    }

    private long changNum(int money) {
        return money * 10000L ;
    }

    public String add() {
        return "agentintosystemadd";
    }

    private AgentIntoSystem collectionParams(AgentIntoSystem plaform){
    	AgentIntoSystem system = new AgentIntoSystem();
    	system.setGameid(this.findParameter("gameid"));
    	system.setAgentId(this.findParameter("agentId"));
    	system.setSystype(this.findParamInt("dividetype"));
    	system.setIntoratio(this.findParamInt("dividepercent0"));
    	system.setNoregulartype(Boolean.valueOf(this.findParameter("noregulartype")));
    	system.setSystemType(1);
    	plaform.setGameid(this.findParameter("gameid"));
    	plaform.setAgentId(this.findParameter("agentId"));
    	plaform.setSystype(this.findParamInt("pdividetype"));
    	plaform.setIntoratio(this.findParamInt("pdividepercent0"));
    	plaform.setNoregulartype(Boolean.valueOf(this.findParameter("pnoregulartype")));
    	plaform.setSystemType(2);    	
    	return system;
    }
    
    public String addInfo() {
        String returnStr = "success";
        this.authenticateAdd();//验证运行权限

        //AgentIntoSystem system = findBean(AgentIntoSystem.class, "agentintosystem");
        AgentIntoSystem plaform = new AgentIntoSystem();
        AgentIntoSystem system = collectionParams(plaform);
        if (system == null) {
            logger.debug("添加内容为空");
            alertJS("添加失败，原因：添加内容为空");
            return returnStr;
        }
        //增加记录
        UserInfo user=this.currentUserInfo();
        system.setInputby(user.getTrueName());
        system.setInputtime(DateUtil.formatNowByDefault());
       
        try {          
            AgentIntoSystem temp = new AgentIntoSystem();
            temp.setGameid(system.getGameid());
            temp.setAgentId(system.getAgentId());
            List<AgentIntoSystem> list = baseSo.findObjects(temp, queryPage);
            if(!CollectionUtils.isEmpty(list)) {
                	if (this.editStatus) {//如是执行修改操作
	                    for(AgentIntoSystem is : list) {
	                      baseSo.deleteById(AgentIntoSystem.class, is.getSeqid());
	                    }
                	}else{
                		   alertJS("添加失败，原因：该游戏的该平台已经添加过了");
                           return returnStr;
                	}
                
            }

            if(system.getSystype().intValue()==1) {//如果是非固定分成
                int size = num;
                Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
                map.put(1,ponit1);
                map.put(2,ponit2);
                map.put(3,ponit3);
                map.put(4,ponit4);
                map.put(5,ponit5);
                for (int i = 1; i <= size; i++) {
                    Ponit ponit = map.get(i);
                    system.setBeginmoney(Integer.parseInt(ponit.getBegin()));
                    if(i != size) {
                    	system.setEndmoney(Integer.parseInt(ponit.getEnd()));
                    }else {
                    	system.setEndmoney(null);
                    }
                    system.setIntoratio(Integer.parseInt(ponit.getPonit()));
                    system.setSystemType(1);
                    baseSo.addObject(system);
                }
            } else {
            	baseSo.addObject(system);
            }
            
            if(plaform.getSystype().intValue()==1) {//如果是非固定分成
                int size = num2;
                Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
                map.put(1,ponit6);
                map.put(2,ponit7);
                map.put(3,ponit8);
                map.put(4,ponit9);
                map.put(5,ponit10);
                for (int i = 1; i <= size; i++) {
                    Ponit ponit = map.get(i);
                    plaform.setBeginmoney(Integer.parseInt(ponit.getBegin()));
                    if(i != size) {
                    	plaform.setEndmoney(Integer.parseInt(ponit.getEnd()));
                    }else {
                    	plaform.setEndmoney(null);
                    }
                    plaform.setIntoratio(Integer.parseInt(ponit.getPonit()));       
                    baseSo.addObject(plaform);
                }
            } else {
            	baseSo.addObject(plaform);
            }
        } catch (Exception e) {
        	e.printStackTrace();
            logger.debug("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
            return returnStr;
        }

        if(this.editStatus) {
            alertJS("修改成功");
        } else {
            alertJS("添加成功");
        }
        return returnStr;
    }

    public String edit() {
        this.authenticateEdit();//
        AgentIntoSystem system = findBean(AgentIntoSystem.class, "agentintosystem");
        if (system == null) {
            logger.debug("编辑内容为空");
            alertJS("编辑失败，原因：编辑内容为空");
            return "";
        }

        String gameid = system.getGameid();
        if (gameid == null) {
            logger.debug("编辑内容为空");
            alertJS("编辑失败，原因：编辑内容为空");
            return "";
        }     

        AgentIntoSystem queryIs = new AgentIntoSystem();
        queryIs.setGameid(gameid);
        queryIs.setAgentId(system.getAgentId());
    	Page page = new Page();
    	page.addOrder("systemType", OrderType.ESC);
    	page.addOrder("beginmoney", OrderType.ESC);
        List<AgentIntoSystem> list = baseSo.findObjects(queryIs, page);
        List<AgentIntoSystem> oneList = new ArrayList<AgentIntoSystem>();
        List<AgentIntoSystem> twoList = new ArrayList<AgentIntoSystem>();
        initTwoList(list,oneList,twoList);
        this.num = oneList.size();
        this.num2 = twoList.size();
        if(num < 1) {
            alertJS("编辑失败，原因：编辑内容为空");
            return "";
        }
        Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
        map.put(1,ponit1);
        map.put(2,ponit2);
        map.put(3,ponit3);
        map.put(4,ponit4);
        map.put(5,ponit5);
        setPointDatas(oneList,map);
        Map<Integer, Ponit> map2 = new HashMap<Integer, Ponit>();
        map.put(1,ponit6);
        map.put(2,ponit7);
        map.put(3,ponit8);
        map.put(4,ponit9);
        map.put(5,ponit10);
        setPointDatas(twoList,map2);
//        AgentIntoSystem one = list.get(0);
//        AgentIntoSystem show = new AgentIntoSystem();
//        show.setGameid(gameid);
//        show.setIntoratio(one.getIntoratio());
//        show.setQudao(one.getQudao());
//        show.setSystype(one.getSystype());
//        show.setNoregulartype(one.getNoregulartype());
//
//        mergeBean(show, "AgentIntoSystem");
        if(!CollectionUtils.isEmpty(oneList)){
        	
        }
     

        editStatus = true;
        return "agentintosystemadd";
    }
    
    
    private void setPointDatas(List<AgentIntoSystem> list,Map<Integer, Ponit> map){
    	AgentIntoSystem one = list.get(0);
 	   if(one.getSystype().intValue()==1) {//如果是非固定分成
          
            for (int i = 1; i <= list.size(); i++) {
                Ponit p = map.get(i);
                AgentIntoSystem temp = list.get(i - 1);
                if(p==null)continue;
                p.setBegin(String.valueOf(temp.getBeginmoney()));
                if(i == list.size()) {
                    p.setEnd("∞");
                } else {
                    p.setEnd(String.valueOf(temp.getEndmoney()));
                }
                p.setPonit(String.valueOf(temp.getIntoratio()));
            }
        }
    }


    public String delete() {
        this.authenticateDel();// 添加权限
        String gameid = this.findParameter("gameid");
        try {
            logger.debug("=======gameid" + gameid);
            AgentIntoSystem AgentIntoSystem = new AgentIntoSystem();
            AgentIntoSystem.setGameid(String.valueOf(gameid));
            for(AgentIntoSystem temp : baseSo.findObjects(AgentIntoSystem, queryPage)) {
                baseSo.deleteById(AgentIntoSystem.class, temp.getSeqid());
            }
            alertJS("删除成功");
        } catch (Exception e) {
            logger.info("删除失败", e);
            alertJS("删除失败，原因：" + e.getMessage());
        }

        return "";
    }

    public static class Ponit {
        private String begin = "0";

        private String end = "∞";

        private String ponit = "0";

        public String getBegin() {
            return begin;
        }

        public void setBegin(String begin) {
            this.begin = begin;
        }

        public String getEnd() {
            return end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public String getPonit() {
            return ponit;
        }

        public void setPonit(String ponit) {
            this.ponit = ponit;
        }
    }
}
