package com.xunlei.niux.manager.web.model.business;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentIncome;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.DataFormatUtil;
import com.xunlei.niux.manager.web.util.ExcelUtil;


/**
 * 营收日结处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentIncomeManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentIncomeManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();

      	
	public AgentIncomeManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	

	/**
	 * 查询营收日结数据
	 * @return
	 */
	public String getQueryAgentIncomeList(){		
	    logger.info("开始营收日结数据查询");
        this.authenticateRun();//验证运行权限
        AgentIncome query = findBean(AgentIncome.class, "agentincome");
        if(isEmpty(query.getFromDayTime())){
			query.setFromDayTime(com.xunlei.common.util.DatetimeUtil.addDate(com.xunlei.common.util.DatetimeUtil.today(), "D", -1));
		}
		if(isEmpty(query.getToDayTime())){
			query.setToDayTime(com.xunlei.common.util.DatetimeUtil.today());
		}
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentIncome> list = new ArrayList<AgentIncome>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("dayTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        for(AgentIncome income:list){
        	income.setRealTotalMoney(DataFormatUtil.format(income.getRealTotalMoney()));
        	income.setTestMoney(DataFormatUtil.format(income.getTestMoney()));
        	income.setTotalMoney(DataFormatUtil.format(income.getTotalMoney()));
        }
        Sheet<AgentIncome> sheet = new Sheet<AgentIncome>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始营收日结导出到excel文件");
    	AgentIncome query = findBean(AgentIncome.class, "agentincome");
    	Page page = new Page();
    	page.addOrder("dayTime", OrderType.DESC);
    	List<AgentIncome> crlist = baseSo.findObjects(query, page);    	
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "营收日结";	   
 	    AgentGamesManagedBean agmb = new AgentGamesManagedBean();
 	    Map<String,String> agentGamesMap = agmb.getAgentGamesMap();
 	    AgentPlatformManagedBean apmb = new AgentPlatformManagedBean();
 	    Map<String,String> agentPlatformMap = apmb.getAgentPlatformMap();
 	    List datas = new ArrayList();
 	    for(AgentIncome cr:crlist){
 	    	List list = new ArrayList();
 	    	list.add(agentPlatformMap.get(cr.getPlatformNo()));
 	    	list.add(agentGamesMap.get(cr.getGameId()));
 	    	list.add(cr.getDayTime());
 	    	list.add(cr.getTotalMoney());
 	    	list.add(cr.getTestMoney());
 	    	list.add(cr.getRealTotalMoney());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"平台","游戏", "日期", "总营收", "测试金额","实际总营收"};
		String filePath = "/tmp/agentincome.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("营收日结",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_agentincome.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();	   
    }
	
}
