package com.xunlei.niux.manager.web.model.business;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentForum;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 业务处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentForumManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentForumManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();

	public AgentForumManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	

	/**
	 * 查询合作公司
	 * @return
	 */
	public String getQueryAgentForumList(){		
	    logger.info("开始合作公司查询");
        this.authenticateRun();//验证运行权限
        AgentForum query = findBean(AgentForum.class, "agentforum");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentForum> list = new ArrayList<AgentForum>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<AgentForum> sheet = new Sheet<AgentForum>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增合作公司
	 * @return
	 */
	public String add(){
		logger.info("开始合作公司信息添加");
		this.authenticateAdd();//添加权限
		AgentForum type = findBean(AgentForum.class, "agentforum");
		try{
			if(type==null){
				logger.info("合作公司信息为空");
				throw new XLRuntimeException("合作公司信息为空");
			}		
			AgentForum query = new AgentForum();
			query.setAgentId(type.getAgentId());
			query.setCompanyType(type.getCompanyType());
            AgentForum rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该平台的合作公司已经存在");
				throw new XLRuntimeException("该平台的合作公司已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改合作公司
	 * @return
	 */
	public String edit(){
		logger.info("开始合作公司信息修改");
		this.authenticateEdit();//编辑权限
		AgentForum type = findBean(AgentForum.class, "agentforum");
		try{
			if(type==null){
				logger.info("合作公司信息为空");
				throw new XLRuntimeException("合作公司信息为空");
			}
			AgentForum query = new AgentForum();
			query.setAgentId(type.getAgentId());     
			query.setCompanyType(type.getCompanyType());
			AgentForum myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该平台的合作公司已经存在");
    				throw new XLRuntimeException("该平台的合作公司已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除合作公司
	 * @return
	 */
	public String delete(){
		logger.info("开始合作公司信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(AgentForum.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
