package com.xunlei.niux.manager.web.model.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentDevelopment;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 研发方业务处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentDevelopmentManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentDevelopmentManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();
    private static Map<String,String> agentDevelopmentMap;
    private static List<SelectItem> agentDevelopmentList;
      	
	public AgentDevelopmentManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	public Map<String, String> getAgentDevelopmentMap() {
		if(agentDevelopmentMap == null){
			initAgentDevelopmentMap();
		}
      
		return agentDevelopmentMap;
	}
	
	public void initAgentDevelopmentMap(){
		   Map<String,String> tempMap=new HashMap<String,String>();
		   AgentDevelopment query=new AgentDevelopment();
	        Page mypage = new Page();
	        mypage.addOrder("inputTime", OrderType.DESC);
			List<AgentDevelopment> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,mypage);
	        if(bplist!=null){
	        	for(AgentDevelopment type:bplist){
	        		tempMap.put(type.getDevelopNo(), type.getDevelopName()); 	
				}
	        }
	        agentDevelopmentMap=tempMap;
	}
	
	public List<SelectItem> getAgentDevelopmentList(){
		if(agentDevelopmentList == null){
			initAgentDevelopmentList();
		}		
		return agentDevelopmentList;
	}
	
	private void initAgentDevelopmentList(){		
		AgentDevelopment query=new AgentDevelopment();
		List<AgentDevelopment> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(AgentDevelopment type:bplist){
			siList.add(new SelectItem(type.getDevelopNo(), type.getDevelopName())); 	
		}
		agentDevelopmentList = siList;
	}
	
	/**
	 * 查询接入研发方
	 * @return
	 */
	public String getQueryAgentDevelopmentList(){		
	    logger.info("开始接入研发方查询");
        this.authenticateRun();//验证运行权限
        AgentDevelopment query = findBean(AgentDevelopment.class, "agentdevelopment");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentDevelopment> list = new ArrayList<AgentDevelopment>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<AgentDevelopment> sheet = new Sheet<AgentDevelopment>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增接入研发方
	 * @return
	 */
	public String add(){
		logger.info("开始接入研发方信息添加");
		this.authenticateAdd();//添加权限
		AgentDevelopment type = findBean(AgentDevelopment.class, "agentdevelopment");
		try{
			if(type==null){
				logger.info("接入研发方信息为空");
				throw new XLRuntimeException("接入研发方信息为空");
			}		
			AgentDevelopment query = new AgentDevelopment();
            query.setDevelopNo(type.getDevelopNo());
            AgentDevelopment rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该接入研发方已经存在");
				throw new XLRuntimeException("该接入研发方已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
			initAgentDevelopmentMap();
			initAgentDevelopmentList();
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改接入研发方
	 * @return
	 */
	public String edit(){
		logger.info("开始接入研发方信息修改");
		this.authenticateEdit();//编辑权限
		AgentDevelopment type = findBean(AgentDevelopment.class, "agentdevelopment");
		try{
			if(type==null){
				logger.info("接入研发方信息为空");
				throw new XLRuntimeException("接入研发方信息为空");
			}
			AgentDevelopment query = new AgentDevelopment();
			query.setDevelopNo(type.getDevelopNo());
			AgentDevelopment myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该接入研发方已经存在");
    				throw new XLRuntimeException("该接入研发方已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);		
			initAgentDevelopmentMap();
			initAgentDevelopmentList();
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除接入研发方
	 * @return
	 */
	public String delete(){
		logger.info("开始接入研发方信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(AgentDevelopment.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
