package com.xunlei.niux.manager.web.model.business;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.AgentDevelopmentGames;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 研发方游戏业务处理类
 * @author lisu
 * 2015-01-08
 */
public class AgentDevelopmentGamesManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AgentDevelopmentGamesManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

	public AgentDevelopmentGamesManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	

	/**
	 * 查询研发方游戏
	 * @return
	 */
	public String getQueryAgentDevelopmentGamesList(){		
	    logger.info("开始研发方游戏查询");
        this.authenticateRun();//验证运行权限
        AgentDevelopmentGames query = findBean(AgentDevelopmentGames.class, "agentdevelopmentgames");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<AgentDevelopmentGames> list = new ArrayList<AgentDevelopmentGames>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<AgentDevelopmentGames> sheet = new Sheet<AgentDevelopmentGames>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增研发方游戏
	 * @return
	 */
	public String add(){
		logger.info("开始研发方游戏信息添加");
		this.authenticateAdd();//添加权限
		AgentDevelopmentGames type = findBean(AgentDevelopmentGames.class, "agentdevelopmentgames");
		try{
			if(type==null){
				logger.info("研发方游戏信息为空");
				throw new XLRuntimeException("研发方游戏信息为空");
			}		
			AgentDevelopmentGames query = new AgentDevelopmentGames();
			query.setDevelopNo(type.getDevelopNo());
            query.setGameId(type.getGameId());          
            AgentDevelopmentGames rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该平台的研发方游戏已经存在");
				throw new XLRuntimeException("该平台的研发方游戏已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改研发方游戏
	 * @return
	 */
	public String edit(){
		logger.info("开始研发方游戏信息修改");
		this.authenticateEdit();//编辑权限
		AgentDevelopmentGames type = findBean(AgentDevelopmentGames.class, "agentdevelopmentgames");
		try{
			if(type==null){
				logger.info("研发方游戏信息为空");
				throw new XLRuntimeException("研发方游戏信息为空");
			}
			AgentDevelopmentGames query = new AgentDevelopmentGames();
			query.setDevelopNo(type.getDevelopNo());
            query.setGameId(type.getGameId());        
            AgentDevelopmentGames myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该研发方游戏已经存在");
    				throw new XLRuntimeException("该研发方游戏已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除研发方游戏
	 * @return
	 */
	public String delete(){
		logger.info("开始研发方游戏信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(AgentDevelopmentGames.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
