package com.xunlei.niux.manager.web.model.boxThree;

import java.util.ArrayList;
import java.util.List;

import com.xunlei.niux.data.vipgame.dto.BoxBonusChargeDTO;
import org.apache.log4j.Logger;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;

import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;

public class BoxBonusChargeManagedBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(BoxBonusChargeManagedBean.class.getName());
    private int rownum = 0;
    private String giftType ;
    
    public BoxBonusChargeManagedBean() {
        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }
    
    public String getQueryBonusChargeList()
    {
        logger.info("开始盒子积分兑换商品记录查询");
        authenticateRun();
        BoxBonusChargeDTO query = (BoxBonusChargeDTO)findBean(BoxBonusChargeDTO.class, "boxbonuscharge");
        
        PagedFliper pagedFliper = getFliper();
        if ((query.getProductId() != null) && (query.getProductId().equals("0"))) {
            query.setProductId(null);
        }
        
        List<BoxBonusChargeDTO> list = new ArrayList<BoxBonusChargeDTO>();
        int count = FacadeFactory.INSTANCE.getBoxBonusChargeBo().getCount(query);
        list = FacadeFactory.INSTANCE.getBoxBonusChargeBo().getBonusChargeList(query, pagedFliper.getPageNo(), pagedFliper.getPageSize());
        
        Sheet<BoxBonusChargeDTO> sheet = new Sheet<BoxBonusChargeDTO>(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    
    public String getGiftType() {
		return giftType;
	}

	public void setGiftType(String giftType) {
		this.giftType = giftType;
	}

	public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

}
