package com.xunlei.niux.manager.web.model.bonus;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.dto.BonusTaskQueryDTO;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;


public class BonusTaskQueryManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(BonusTaskQueryManagedBean.class.getName());
    private String gameId;
    private String taskName;
    private String taskId;
    private String userid;
    private String fromSuccessTime;
    private String toSuccessTime;

    public String queryBonusTask(){

        String sql = " FROM ( \n" +
                "SELECT r.userid,r.recordTime,r.expireTime,r.taskconfseqid,g.task1ref AS taskid,t.gameid,t.dutydesc,gift.giftid,gift.productUnitPrice AS jfincr \n" +
                "FROM usertaskrecord r \n" +
                "LEFT JOIN taskgameconfig g ON r.taskconfseqid = g.seqid \n" +
                "LEFT JOIN taskdutyconfig t ON g.task1ref=t.seqid \n" +
                "LEFT JOIN gift ON gift.giftid = t.rewardGiftId \n" +
                "WHERE r.reward1status=1 \n" +
                "UNION ALL \n" +
                "SELECT r.userid,r.recordTime,r.expireTime,r.taskconfseqid,g.task2ref AS taskid,t.gameid,t.dutydesc,gift.giftid,gift.productUnitPrice AS jfincr \n" +
                "FROM usertaskrecord r \n" +
                "LEFT JOIN taskgameconfig g ON r.taskconfseqid = g.seqid \n" +
                "LEFT JOIN taskdutyconfig t ON g.task2ref=t.seqid \n" +
                "LEFT JOIN gift ON gift.giftid = t.rewardGiftId \n" +
                "WHERE r.reward2status=1 \n" +
                "UNION ALL \n" +
                "SELECT r.userid,r.recordTime,r.expireTime,r.taskconfseqid,g.task3ref AS taskid,t.gameid,t.dutydesc,gift.giftid,gift.productUnitPrice AS jfincr \n" +
                "FROM usertaskrecord r \n" +
                "LEFT JOIN taskgameconfig g ON r.taskconfseqid = g.seqid \n" +
                "LEFT JOIN taskdutyconfig t ON g.task3ref=t.seqid \n" +
                "LEFT JOIN gift ON gift.giftid = t.rewardGiftId \n" +
                "WHERE r.reward3status=1 \n" +
                "UNION ALL \n" +
                "SELECT r.userid,r.recordTime,r.expireTime,r.taskconfseqid,g.task4ref AS taskid,t.gameid,t.dutydesc,gift.giftid,gift.productUnitPrice AS jfincr \n" +
                "FROM usertaskrecord r \n" +
                "LEFT JOIN taskgameconfig g ON r.taskconfseqid = g.seqid \n" +
                "LEFT JOIN taskdutyconfig t ON g.task4ref=t.seqid \n" +
                "LEFT JOIN gift ON gift.giftid = t.rewardGiftId \n" +
                "WHERE r.reward4status=1) a \n" +
                "WHERE 1=1 ";

        StringBuilder sb = new StringBuilder(sql);
        if(StringUtils.isNotEmpty(gameId)){
            sb.append(" and gameid = '"+gameId+"' ");
        }
        if(StringUtils.isNotEmpty(taskName)){
            sb.append(" and dutydesc like '%"+taskName+"%' ");
        }
        if(StringUtils.isNotEmpty(taskId)){
            sb.append(" and taskid = "+taskId+" ");
        }
        if(StringUtils.isNotEmpty(userid)){
            sb.append(" and userid = '"+userid+"' ");
        }
        if(StringUtils.isNotEmpty(fromSuccessTime)){
            sb.append(" and recordTime >= '"+fromSuccessTime+"' ");
        }
        if(StringUtils.isNotEmpty(toSuccessTime)){
            sb.append(" and recordTime <= '"+toSuccessTime+" 23:59:59' ");
        }

        int count = FacadeFactory.INSTANCE.getBaseSo().count("select count(*) "+sb.toString(),null);
        PagedFliper pagedFliper = getFliper();
        pagedFliper.setRecordCount(count);


        List<BonusTaskQueryDTO> list = new ArrayList<BonusTaskQueryDTO>();
        if (count > 0) {
            sb.append(" ORDER BY recordtime DESC LIMIT ?,? ");

            List params = new ArrayList();
            params.add((pagedFliper.getPageNo()-1)*pagedFliper.getPageSize());
            params.add(pagedFliper.getPageSize());

            list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(BonusTaskQueryDTO.class, "select * "+sb.toString(), params);
        }
        Sheet<BonusTaskQueryDTO> sheet = new Sheet<BonusTaskQueryDTO>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String getFromSuccessTime() {
        return fromSuccessTime;
    }

    public void setFromSuccessTime(String fromSuccessTime) {
        this.fromSuccessTime = fromSuccessTime;
    }

    public String getGameId() {
        return gameId;
    }

    public void setGameId(String gameId) {
        this.gameId = gameId;
    }

    public static Logger getLogger() {
        return logger;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getToSuccessTime() {
        return toSuccessTime;
    }

    public void setToSuccessTime(String toSuccessTime) {
        this.toSuccessTime = toSuccessTime;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }
}