package com.xunlei.niux.manager.web.model.bonus;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.client.bonus.BonusClient;
import com.xunlei.niux.data.vipgame.bo.bonus.BonusOperateRecordBo;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusOperateRecord;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.niux.manager.web.model.BaseManagedBean;

public class BonusOperateRecordManagedBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(BonusOperateRecordManagedBean.class.getName());
	private BonusOperateRecordBo bonusOperateRecordBo;
    private int rownum = 0;
    
    public BonusOperateRecordManagedBean() {
    	bonusOperateRecordBo = FacadeFactory.INSTANCE.getBonusOperateRecordBo();
    	
        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }
    
    public String getQueryBonusOperateRecordList(){
    	try {
    		List<GameDTO> webgameList = FacadeFactory.INSTANCE.getGamesBo().getAllValidWebGames();
    		logger.info("开始积分操作记录查询");
            this.authenticateRun();//验证运行权限
            BonusOperateRecord record = findBean(BonusOperateRecord.class, "bonusoperaterecord");
            
            if(null!=record.getOperateType() && record.getOperateType()==0){
            	record.setOperateType(null);
            }
            
            if(null!=record.getUserId() && record.getUserId()==0){
            	record.setUserId(null);
            }
            
            PagedFliper pagedFliper = this.getFliper();
            int count = bonusOperateRecordBo.count(record);
            pagedFliper.setRecordCount(count);
            List<BonusOperateRecord> list = new ArrayList<BonusOperateRecord>();
            if (count > 0) {
            	rownum = 1;
            	Page page=new Page();
            	page.setPageNo(pagedFliper.getPageNo());
            	page.setPageSize(pagedFliper.getPageSize());
            	page.addOrder("recordTime", OrderType.DESC);
                list = bonusOperateRecordBo.findBonusOperateRecord(record, page);
            }
            Sheet<BonusOperateRecord> sheet = new Sheet<BonusOperateRecord>(count, list);
            this.mergePagedDataModel(sheet, pagedFliper);
           
		} catch (Exception e) {
			e.printStackTrace();
		}
    	
    	 return "";
	}
    
    public String add(){
		logger.info("开始积分操作记录添加");		
		BonusOperateRecord record = this.findBean(BonusOperateRecord.class,"bonusoperaterecord");	
		try{
			if(record==null){
				logger.info("记录为空");
				throw new XLRuntimeException("记录为空");
			}	
			
			String userIds = record.getUserIds();
			String[] uids = userIds.split(",");
			
			Integer bonusNum = record.getBonusNum();
			Integer operateType = record.getOperateType();
			String remark = record.getRemark();
			
			String balanceDate = DateUtil.format(new Date(), "yyyy-MM-dd");
			
			for(String s : uids){
				if(operateType.equals(1)){
					BonusClient.recharge(s, "", bonusNum, OrderNoUtil.getOrderNo(), balanceDate, "manualoperate");
				}else{
					BonusClient.consume(s, "", bonusNum, OrderNoUtil.getOrderNo(), balanceDate, "manualoperate", null);
				} 
				
				BonusOperateRecord operateRecord = new BonusOperateRecord();
				operateRecord.setUserId(Long.parseLong(s));
				operateRecord.setBonusNum(bonusNum);
				operateRecord.setOperateType(operateType);
				operateRecord.setOperator(currentUserLogo());
				operateRecord.setRecordTime(now());
				operateRecord.setRemark(remark);
				bonusOperateRecordBo.insert(operateRecord);
			}
			
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}

    public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }


}
