package com.xunlei.niux.manager.web.model.bonus;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.dto.BonusChargeRecordDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.ExcelUtil;

public class BonusChargeRecordManagedBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(BonusChargeRecordManagedBean.class.getName());
    private int rownum = 0;
    private Boolean isBox = false;
    

	public  Boolean getIsBox() {
		return isBox;
	}

	public  void setIsBox(Boolean isBox) {
		this.isBox = isBox;
	}

	public BonusChargeRecordManagedBean() {
        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }
    
    public String getQueryBonusChargeRecordList(){
        logger.info("开始积分兑换商品记录查询");
        authenticateRun();
        BonusChargeRecordDTO query = (BonusChargeRecordDTO)findBean(BonusChargeRecordDTO.class, "bonuschargerecord");
        String linklocid = findParameter("isBox");
        if(linklocid!=null){
        	isBox = Boolean.valueOf(linklocid);
        	query.setIsBox(isBox);
        }
        PagedFliper pagedFliper = getFliper();
        if ((query.getChargeFlag() != null) && (query.getChargeFlag().intValue() == 0)) {
            query.setChargeFlag(null);
        }
        if ((query.getUserId() != null) && (query.getUserId().longValue() == 0L)) {
            query.setUserId(null);
        }
        
        List<BonusChargeRecordDTO> list = new ArrayList<BonusChargeRecordDTO>();
        int count = FacadeFactory.INSTANCE.getBonusChargeRecordBo().getCount(query);
        list = FacadeFactory.INSTANCE.getBonusChargeRecordBo().getBonusChargeRecordList(query, pagedFliper.getPageNo(), pagedFliper.getPageSize());
        
        Sheet<BonusChargeRecordDTO> sheet = new Sheet<BonusChargeRecordDTO>(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }
    
    /**
     * 将积分兑换（虚拟和实物）名单导出到excel中
     */
    public void export(){
    	logger.info("开始名单数据导出到excel文件");
		
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "积分兑换商品名单明细";	 
    	
 	    BonusChargeRecordDTO query = (BonusChargeRecordDTO)findBean(BonusChargeRecordDTO.class, "bonuschargerecord");
 	    query.setGiftType(null);
 	    
 	    List datas = new ArrayList();
 	    datas = FacadeFactory.INSTANCE.getBonusChargeRecordBo().export(query);
 	    
 	    //生成数据到excel中
		String[] columnName = {"userid", "giftid", "giftName", "recordTime", "userName", "userRealName", "province", "city", "district", "detailAddress", "postCode", "telephone", "mobilePhone"};
		String filePath = "/tmp/bonusProductUserDetails.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("积分兑换商品名单明细", title, columnName, filePath, datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"bonusProductUserDetails.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			logger.error("积分兑换商品名单导出异常", e);
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();	   
    }

    public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

}
