package com.xunlei.niux.manager.web.model.bonus;

import java.util.ArrayList;
import java.util.List;

import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.dto.BonusChargeDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.manager.web.model.BaseManagedBean;

public class BonusChargeManagedBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(BonusChargeManagedBean.class.getName());
    private int rownum = 0;
    private boolean isBox = false;
    
    public BonusChargeManagedBean() {
        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }
    
    public String getQueryBonusChargeList()
    {
        logger.info("开始积分兑换商品记录查询");
        
        authenticateRun();
        BonusChargeDTO query = (BonusChargeDTO)findBean(BonusChargeDTO.class, "bonuscharge");
        String linklocid = findParameter("isBox");
        if(linklocid!=null){
            isBox = Boolean.valueOf(linklocid);
            query.setIsBox(isBox);
        }
        String isBoxStr = findParameter("bonuscharge_isBox");
        if(isBoxStr!=null){
            isBox = Boolean.valueOf(isBoxStr);
            query.setIsBox(isBox);
        }

        PagedFliper pagedFliper = getFliper();
        if ((query.getProductId() != null) && (query.getProductId().equals("0"))) {
            query.setProductId(null);
        }
        
        
        List<BonusChargeDTO> list = new ArrayList<BonusChargeDTO>();
        int count = FacadeFactory.INSTANCE.getBonusChargeBo().getCount(query);
        list = FacadeFactory.INSTANCE.getBonusChargeBo().getBonusChargeList(query, pagedFliper.getPageNo(), pagedFliper.getPageSize());
        
        Sheet<BonusChargeDTO> sheet = new Sheet<BonusChargeDTO>(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    public boolean getIsBox() {
		return isBox;
	}

	public void setBox(boolean isBox) {
		this.isBox = isBox;
	}

	public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

	public List<SelectItem> getIsBoxList(){
        String isBoxStr = findParameter("bonuscharge_isBox");
        if(isBoxStr!=null){
            isBox = Boolean.valueOf(isBoxStr);
        }
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(isBox){
			siList.add(new SelectItem("true", "是"));
		}else{
			siList.add(new SelectItem("false","否"));
		}
		return siList;
	}
    
}
