package com.xunlei.niux.manager.web.model.automaticservice;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.customer.AutomaticServiceComplaint;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class ComplaintManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(ComplaintManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        AutomaticServiceComplaint bean = findBean(AutomaticServiceComplaint.class,"automaticservicecomplaint");
        if(bean==null)bean = new AutomaticServiceComplaint();
        if(bean.getUid()!=null&&bean.getUid()==0)bean.setUid(null);
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);
        List<AutomaticServiceComplaint> list = new ArrayList<AutomaticServiceComplaint>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("submitTime", OrderType.DESC);

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<AutomaticServiceComplaint> sheet = new Sheet<AutomaticServiceComplaint>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String edit(){
        try {
            this.authenticateEdit();
            AutomaticServiceComplaint bean = findBean(AutomaticServiceComplaint.class,"automaticservicecomplaint");
            if(bean==null||bean.getSeqid()==null){
                throw new XLRuntimeException("bean or seqid is null");
            }
            AutomaticServiceComplaint query = new AutomaticServiceComplaint();
            query.setSeqid(bean.getSeqid());
            AutomaticServiceComplaint comp = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if(comp==null){
                throw new XLRuntimeException("not found record by seqid: "+bean.getSeqid());
            }
            comp.setEditBy(this.currentUserLogo());
            comp.setEditTime(now());
            comp.setStatusid(bean.getStatusid());
            comp.setResult(bean.getResult());
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(comp);
        }catch (Exception e){
            logger.error("数据异常",e);
            mergeJsmessage("数据异常,"+e.getMessage());
        }
        return "";
    }

}
