package com.xunlei.niux.manager.web.model.automaticservice;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.customer.AutomaticServiceBug;
import org.apache.log4j.Logger;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import java.util.ArrayList;
import java.util.List;

public class BugManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(BugManagedBean.class.getName());


    public String getQueryData(){
        this.authenticateRun();//验证运行权限
        AutomaticServiceBug bean = findBean(AutomaticServiceBug.class,"automaticservicebug");
        if(bean==null)bean=new AutomaticServiceBug();
        if(bean.getUid()!=null&&bean.getUid()==0)bean.setUid(null);
        PagedFliper pagedFliper = this.getFliper();
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(bean);
        pagedFliper.setRecordCount(count);

        List<AutomaticServiceBug> list = new ArrayList<AutomaticServiceBug>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("submitTime", OrderType.DESC);

            list = FacadeFactory.INSTANCE.getBaseSo().findObjects(bean, page);
        }
        Sheet<AutomaticServiceBug> sheet = new Sheet<AutomaticServiceBug>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


}
