package com.xunlei.niux.manager.web.model.authority;//package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;

import com.xunlei.niux.data.vipgame.bo.authority.AuthInfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.authority.AuthInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.util.PasswordUtil;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
* 业务处理类
* @author lisu
*  2013-1-15
*/
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_AUTHINFO)
public class AuthInfoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(AuthInfoManagedBean.class.getName());
	private AuthInfoBo authInfoBo;
	private int rownum = 0;

	public AuthInfoManagedBean(){
        authInfoBo = FacadeFactory.INSTANCE.getAuthInfoBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}


	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询业务信息
	 * @return
	 */
	public String getQueryAuthInfoList(){
		logger.info("开始业务信息查询");
        this.authenticateRun();//验证运行权限
        AuthInfo authInfo = findBean(AuthInfo.class, "authinfo");
        PagedFliper pagedFliper = this.getFliper();
        int count = authInfoBo.count(authInfo);
        pagedFliper.setRecordCount(count);
        List<AuthInfo> list = new ArrayList<AuthInfo>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = authInfoBo.find(authInfo, page);
        }
        Sheet<AuthInfo> sheet = new Sheet<AuthInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	/**
	 * 新增业务信息
	 * @return
	 */
	public String add(){
		logger.info("开始业务信息添加");
		this.authenticateAdd();//添加权限
        AuthInfo authInfo = this.findBean(AuthInfo.class,"authinfo");
        try{
			if(authInfo==null){
				logger.info("业务信息为空");
				throw new XLRuntimeException("业务信息为空");
			}
            authInfo.setInputBy(currentUserLogo());
            authInfo.setInputTime(now());
            String pwd = PasswordUtil.genRandomPassword(15);
            authInfo.setAuthKey(pwd);

			authInfoBo.insert(authInfo);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}

	/**
	 * 修改业务信息
	 * @return
	 */
	public String edit(){
		logger.info("开始业务信息修改");
		this.authenticateEdit();//编辑权限
        AuthInfo authInfo=this.findBean(AuthInfo.class,"authinfo");
		try{
			if(authInfo==null){
				logger.info("业务为空");
				throw new XLRuntimeException("业务为空");
			}
            authInfo.setEditBy(this.currentUserLogo());
            authInfo.setEditTime(now());
			authInfoBo.update(authInfo);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}



}
