package com.xunlei.niux.manager.web.model.activity;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.activity.bo.BaseSo;
import com.xunlei.niux.data.activity.facade.FacadeFactory;
import com.xunlei.niux.data.activity.vo.Activity;
import com.xunlei.niux.data.activity.vo.Photo;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.dto.ActivityData;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.proxy.JRedisProxy;
import com.xunlei.niux.manager.web.util.FileUtil;
import com.xunlei.util.StringTools;


/**
 * 牛x平台所有活动的图片处理类
 * @author lisu
 * 2014-06-12
 */
public class PhotoManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PhotoManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;	
	private static final String activityPath = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("activityPath");	
	private static final String activityCmd = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("wholePeopleGuestCmd");	 
	private static final SimpleDateFormat Monthsdf = new SimpleDateFormat("yyyy-MM"); 
	private static final SimpleDateFormat nowsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
	
	
	public PhotoManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询活动的图片
	 * @return
	 */
	public String getQueryPhotoList(){		
	    logger.info("开始活动的图片查询");
        this.authenticateRun();//验证运行权限
        Photo query = findBean(Photo.class, "activity_photo");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<Photo> list = new ArrayList<Photo>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
          	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("displayOrder", OrderType.DESC);
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<Photo> sheet = new Sheet<Photo>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增活动的图片
	 * @return
	 */
	public String add(){
		logger.info("开始活动添加");
		this.authenticateAdd();//添加权限
		Photo photo = findBean(Photo.class, "activity_photo");
		try{
			if(photo==null){
				logger.info("活动的图片信息为空");
				throw new XLRuntimeException("活动的图片信息为空");
			}
            String actNo = photo.getActNo();
            String actLoc = photo.getActLocation();
            if(!"userCenter".equals(actLoc)){
                if(StringTools.isEmpty(actNo)){
                    throw new XLRuntimeException("无效的活动编号");
                }
                checkActNo(actNo);
            }
			photo.setInputTime(now());
			photo.setInputBy(this.currentUserLogo());
			baseSo.addObject(photo);
			//makeFile(photo);
			//addCache(photo);//添加缓存			
			//sync();//同步数据
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	private String toString(List<ActivityData> datalist) throws Exception{
		sort(datalist);//先排序，按活动开始时间逆序
		StringBuffer sb = new StringBuffer();
		for(ActivityData data:datalist){
			sb.append(data.getActStat()).append("_")
			.append(data.getEndTime()).append("_")
			.append(data.getEndTimeStamp()).append("_")
			.append(data.getGameId()).append("_")
			.append(data.getGameNo()).append("_")
			.append(data.getPic()).append("_")
			.append(data.getStartTime()).append("_")
			.append(data.getStartTimeStamp()).append("_")
			.append(data.getTitle()).append("_")
			.append(data.getUrl())
			.append("|");
		}
		return sb.toString();
	}
	
	private List<ActivityData>  toActivityData(String datas){
		if(StringTools.isEmpty(datas))return null;
		String acts [] = datas.split("|");
		List<ActivityData> result = new ArrayList<ActivityData>();
		for(String act:acts){
			if(StringTools.isEmpty(act))continue;
			String subact [] = act.split("_");
			ActivityData actdata = new ActivityData();
			actdata.setActStat(Integer.parseInt(subact[0]));
			actdata.setEndTime(subact[1]);
			actdata.setEndTimeStamp(Long.parseLong(subact[2]));
			actdata.setGameId(subact[3]);
			actdata.setGameNo(subact[4]);
			actdata.setPic(subact[5]);
			actdata.setStartTime(subact[6]);
			actdata.setStartTimeStamp(Long.parseLong(subact[7]));
			actdata.setTitle(subact[8]);
			actdata.setUrl(subact[9]);
			result.add(actdata);
		}
		return result;
	}
	
	
	/**
	 * 按活动开始时间逆序
	 * @param list
	 * @return
	 */
	private void sort(List<ActivityData> list) throws Exception{
		for(int i=0;i<list.size();i++){
			for(int j=0;j<list.size();j++){
				ActivityData idata = list.get(i);
				ActivityData jdata = list.get(j);
				if(DateUtil.compareTime(idata.getStartTime(), jdata.getStartTime())<0){
					ActivityData data = list.get(i);
					list.set(i, list.get(j));
					list.set(j, data);
				}
			}
		}
	}
	
	private void delCache(Activity activity) throws Exception{
		String month = activity.getStarttime().substring(0, 7);
		String actdata = JRedisProxy.getInstance().get((month+"_activity"));	   
		if(StringTools.isEmpty(actdata))return;
		List<ActivityData> list =  toActivityData(actdata);
		for(ActivityData data:list){
			if(data.getActNo().equals(activity.getActno())){
				list.remove(data);//删除该活动记录
			}
		}
		String datas = toString(list);
		JRedisProxy.getInstance().set(month+"_activity", datas, Integer.MAX_VALUE);//重新放入缓存
	}
	
	private void addCache(Photo photo) throws Exception{
		String actLocation = photo.getActLocation();
		if(actLocation==null||!"actLocation".equals(actLocation)){
			return ;			
		}
		Activity activity = getActivity(photo.getActNo());
		if(activity == null)return ;
		String startTime = activity.getStarttime();
		String month = startTime.substring(0,7);
		ActivityData data = new ActivityData();
    	data.setActStat(Integer.parseInt(activity.getActstatus()));
    	data.setStartTime(activity.getStarttime());
    	data.setEndTime(activity.getEndtime());
    	data.setGameId(activity.getGameid());
    	String gameId = data.getGameId();
    	if(gameId!=null&&!"000000".equals(gameId)){
    		Games games = GameCache.getInstance().getGameByGameId(gameId);
    		data.setGameNo(games.getGameNo());
    	}else{
    		data.setGameNo("");
    	}
    	data.setPic(photo.getPhoto());
    	data.setTitle(photo.getActDesc());
    	data.setUrl(photo.getLinkUrl());
		String actdata = JRedisProxy.getInstance().get((month+"_activity"));	   
		String datas = null;
        if(StringTools.isEmpty(actdata)){//如果之前没存到缓存
        	List<ActivityData> newlist = new ArrayList<ActivityData>();        
        	newlist.add(data);
        	datas = toString(newlist);
        }else{//如果之前已经存了缓存        	
        	List<ActivityData> list =  toActivityData(actdata);
        	list.add(data);      	
        	datas = toString(list);
        }       
    	JRedisProxy.getInstance().set(month+"_activity", datas, Integer.MAX_VALUE);
	}
	
	
	private Activity getActivity(String actNo){
		Activity query = new Activity();
	    query.setActno(actNo);
		return baseSo.findObject(query);
	}
	
	
	private void checkActNo(String actNo) throws Exception{		
		Activity query = new Activity();
		query.setActno(actNo);
		Activity activity = baseSo.findObject(query);
		if(activity == null){
			throw new XLRuntimeException("无效的活动编号");
		}
	}
	
	
	/**
	 * 修改活动的图片
	 * @return
	 */
	public String edit(){
		logger.info("开始活动的图片信息修改");
		this.authenticateEdit();//编辑权限
		Photo photo = findBean(Photo.class, "activity_photo");
		try{
			if(photo==null){
				logger.info("活动的图片信息为空");
				throw new XLRuntimeException("活动的图片信息为空");
			}
			String actNo = photo.getActNo();
			if(StringTools.isEmpty(actNo)){
				throw new XLRuntimeException("无效的活动编号");
			}
			checkActNo(actNo);
            photo.setEditTime(now());
            photo.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(photo);	
			//makeFile(photo);
			//addCache(photo);//添加缓存			
			//sync();//同步数据
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	 public void sync(){
		 try {
			 logger.info("开始同步活动页文件,地址:/usr/local/bin/"+activityCmd);
			 Runtime.getRuntime().exec("/usr/local/bin/"+activityCmd);			
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	 }
	
	/**
	 * 删除活动的图片信息
	 * @return
	 */
	public String delete(){
		logger.info("开始活动的图片信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 //Photo photo = baseSo.findById(Photo.class, id);
				 baseSo.deleteById(Photo.class, id);
				 //makeFile(photo);
				 //删除相应的缓存
				 //delCache(activity);
			}
			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	private void makeFile(Photo photo) throws Exception{
		 Activity query = new Activity();
		 query.setActno(photo.getActNo());
		 Activity activity = baseSo.findObject(query);
		 String starttime = activity.getStarttime();
		 String endtime = activity.getEndtime();
		 String month = starttime.substring(0,7);
		 String emonth = endtime.substring(0,7);
		 Photo pquery = new Photo();
		 List<Photo> alllist = baseSo.findObjects(pquery, new Page());
		 Calendar cal = Calendar.getInstance();
		 while(DateUtil.compareTime(month+"-01", emonth+"-01")<=0){
			 makeFile(month,alllist);			 
			 cal.setTime(Monthsdf.parse(month));
			 cal.add(Calendar.MONTH,1);
			 month = Monthsdf.format(cal.getTime());
		 }
	}
	
	private String formatTime(String time){
		if(StringTools.isEmpty(time))return "";
		if(time.length()>10){
			time = time.substring(0,10);
		}
		String datas[] = time.split("-");
		return (datas[0]+"年"+datas[1]+"月"+datas[2]+"日");
	}
	
	private void makeFile(String month,List<Photo> alllist) throws Exception{
		List<ActivityData> actdatalist = new ArrayList<ActivityData>();
		String sql = "SELECT * FROM activity_activity WHERE LEFT(starttime,7)<= '"+month+"' AND LEFT(endtime,7)>= '"+month+"'  order by starttime desc ;";
		List<Activity> actlist = baseSo.executeQuery(Activity.class, sql, new ArrayList<String>());
		System.out.println("actlist.size:"+actlist.size());
		System.out.println("actlist:"+actlist);
		System.out.println("actlist.alllist:"+alllist.size());
		System.out.println("actlist:"+alllist);
		for(Activity act:actlist){
			for(Photo photo:alllist){
				if(act.getActno().equals(photo.getActNo())){
					ActivityData data = new ActivityData();
					data.setActNo(act.getActno());
			    	data.setActStat(Integer.parseInt(act.getActstatus()));
			    	data.setStartTime(act.getStarttime().split(" ")[0]);
			    	data.setStartTimeStamp(nowsdf.parse(act.getStarttime()).getTime());
			    	data.setEndTime(act.getEndtime().split(" ")[0]);
			    	data.setEndTimeStamp(nowsdf.parse(act.getEndtime()).getTime());
			    	data.setGameId(act.getGameid());
			    	String gameId = data.getGameId();
			    	if(gameId!=null&&!"000000".equals(gameId)){
			    		Games games = GameCache.getInstance().getGameByGameId(gameId);
			    		data.setGameNo(games.getGameNo());
			    	}else{
			    		data.setGameNo("");
			    	}
			    	data.setPic(act.getPicUrl());
			    	data.setTitle(photo.getActDesc());
			    	data.setUrl(photo.getLinkUrl());
			    	actdatalist.add(data);
				}
			}			
		}
		String jsonStr=JsonObjectUtil.getDataJsonObject(actdatalist);
		jsonStr = "var ACTLIST = "+jsonStr;
		jsonStr += ";";
		File file = FileUtil.createFile(activityPath,month+".js");
		FileUtil.writeByChar(file, jsonStr);
	}
	
	
}
