package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.YyQuestion;
import com.xunlei.niux.manager.web.util.PageUtil;

public class YyQuestionManagedBean extends BaseManagedBean{
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private int rownum = 0;
	private Long thisParentSeqId=0L;
	public Long getThisParentSeqId() {
		return thisParentSeqId;
	}
	public void setThisParentSeqId(Long thisParentSeqId) {
		this.thisParentSeqId = thisParentSeqId;
	}
	public String add(){
		this.authenticateAdd();
		
		YyQuestion yyQuestion=findBean(YyQuestion.class,"yyquestion");
		//添加人信息
		Date now=new Date();
		UserInfo user=this.currentUserInfo();
		yyQuestion.setInputBy(user.getTrueName());
		yyQuestion.setInputTime(sdf.format(now));
		yyQuestion.setEditBy(user.getTrueName());
		yyQuestion.setEditTime(sdf.format(now));
		
		try{
			FacadeFactory.INSTANCE.getYyQuestionBo().insert(yyQuestion);
		}catch(Exception e){
			logger.error("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	public String delete() {
	       this.authenticateRun();
	       String paramseqids = findParameter("delseqids");
	       String[] params = paramseqids.split(",");
	       try{
	           for(String id : params) {
	        	   if("1".equals(id)){
	        		   continue;
	        	   }
	               FacadeFactory.INSTANCE.getYyQuestionBo().delete(Integer.valueOf(id));
	           }
	       } catch (Exception e) {
	           logger.error("删除失败", e);
	           alertJS("删除失败，原因：" + e);
	       }
	       return "";
	}
	public String edit(){
		this.authenticateEdit();
		YyQuestion yyQuestion=findBean(YyQuestion.class,"yyquestion");
		//添加人信息
		Date now=new Date();
		UserInfo user=this.currentUserInfo();
		yyQuestion.setEditBy(user.getTrueName());
		yyQuestion.setEditTime(sdf.format(now));
		
		try{
			FacadeFactory.INSTANCE.getYyQuestionBo().update(yyQuestion);
		}catch(Exception e){
			logger.error("编辑失败", e);
            alertJS("编辑失败，原因：" + e.getMessage());
		}
		return "";
	}
	public String getQueryYyQuestionList(){
		this.authenticateRun();
		YyQuestion yyQuestion=findBean(YyQuestion.class,"yyquestion");
		PagedFliper fliper=this.getFliper();
		if(yyQuestion.getSeqId()==null){
			yyQuestion.setSeqId(1L);
		}
		List<YyQuestion> list=new ArrayList<YyQuestion>();
		YyQuestion yy=FacadeFactory.INSTANCE.getYyQuestionBo().find(yyQuestion.getSeqId());
		if(yy==null){
			Sheet<YyQuestion> sheet=new Sheet<YyQuestion>(0, list);
			this.mergePagedDataModel(sheet, fliper);
			return "";
		}
		list.add(yy);
		this.thisParentSeqId=yy.getSeqId();
		//获取回答的问题
		YyQuestion qyy=new YyQuestion();
		qyy.setParentSeqId(yy.getSeqId());
		int count=FacadeFactory.INSTANCE.getYyQuestionBo().count(yyQuestion);
		if(count>0){
			Page page=PageUtil.formatPage(fliper, "displaySort","asc");
			List<YyQuestion> templist=FacadeFactory.INSTANCE.getYyQuestionBo().find(qyy, page);
			if(templist!=null&&templist.size()>0){
				list.addAll(templist);
			}
		}
		Sheet<YyQuestion> sheet=new Sheet<YyQuestion>(count, list);
		this.mergePagedDataModel(sheet, fliper);
		return "";
	}
}
