package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.workflow.WorkUser;


/**
 * 审核人业务处理类
 * @author lisu
 *  2013-11-18
 */

public class WorkUserManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(WorkUserManagedBean.class.getName());   
    private BaseSo baseSo;
	private int rownum = 0;	
	
	public WorkUserManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	
	/**
	 * 查询审核人
	 * @return
	 */
	public String getQueryWorkUserList(){
		logger.info("开始审核人查询");
        this.authenticateRun();//验证运行权限
        WorkUser user = findBean(WorkUser.class, "workuser");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(user);
        pagedFliper.setRecordCount(count);
        List<WorkUser> list = new ArrayList<WorkUser>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(user, page);
        }
        Sheet<WorkUser> sheet = new Sheet<WorkUser>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增审核人
	 * @return
	 */
	public String add(){
		logger.info("开始审核人添加");		
		WorkUser user = findBean(WorkUser.class, "workuser");
		try{
			if(user==null){
				logger.info("审核人信息为空");
				throw new XLRuntimeException("审核人信息为空");
			}		
			WorkUser mp = new WorkUser();
			mp.setFlowNo(user.getFlowNo());
			mp.setAccount(user.getAccount());
			List<WorkUser> mplist = baseSo.findObjects(mp, new Page());
			if(mplist != null&&mplist.size()>0){
				throw new XLRuntimeException("流程编号为："+user.getFlowNo()+"的审核人："+user.getAccount()+"，已存在，请不要重复添加");
			}
			user.setInputBy(this.currentUserLogo());
			user.setInputTime(now());			
			baseSo.addObject(user);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改审核人
	 * @return
	 */
	public String edit(){
		logger.info("开始审核人信息修改");
		this.authenticateEdit();//编辑权限
		WorkUser user = findBean(WorkUser.class, "workuser");
		try{
			if(user==null){
				logger.info("审核人信息为空");
				throw new XLRuntimeException("审核人信息为空");
			}					
			user.setEditBy(this.currentUserLogo());
			user.setEditTime(now());
			baseSo.updateObjectById(user);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除审核人
	 * @return
	 */
	public String delete(){	
		logger.info("开始审核人信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(WorkUser.class, id);	
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
