package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.workflow.WorkRecord;


/**
 * 审核记录业务处理类
 * @author lisu
 *  2013-11-12
 */

public class WorkRecordManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(WorkRecordManagedBean.class.getName());
	private BaseSo baseSo;
	private int rownum = 0;
	public WorkRecordManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询审核记录
	 * @return
	 */
	public String getQueryWorkRecordList(){
		logger.info("开始审核记录查询");
        this.authenticateRun();//验证运行权限
        WorkRecord record = findBean(WorkRecord.class, "workrecord");
        String qtype = this.findParameter("qtype");
        String aporderid = this.findParameter("one_aporderid");
        if(aporderid == null){
        	record.setWporderid("-1");
        	if(qtype != null&& "1".equals(qtype)){
        		record.setWporderid(null);
        	}
        }else{
        	record.setWporderid(aporderid);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(record);
        pagedFliper.setRecordCount(count);
        List<WorkRecord> list = new ArrayList<WorkRecord>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.addOrder("checkTime", OrderType.ESC);
            list = baseSo.findObjects(record, page);
        }
        Sheet<WorkRecord> sheet = new Sheet<WorkRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	public String getQueryRecordList(){
		logger.info("开始审核记录查询");
        this.authenticateRun();//验证运行权限
        WorkRecord record = findBean(WorkRecord.class, "workrecord");
        PagedFliper pagedFliper = this.getFliper();
        String workrecord_isvalid = this.findParameter("workrecord_isvalid");
        if(workrecord_isvalid != null){
        	if("-1".equals(workrecord_isvalid)){
        		record.setIsvalid(null);
        	}else if("1".equals(workrecord_isvalid)){
        		record.setIsvalid(true);
        	}else if("0".equals(workrecord_isvalid)){
        		record.setIsvalid(false);
        	}
        }
        int count = baseSo.countObject(record);
        pagedFliper.setRecordCount(count);
        List<WorkRecord> list = new ArrayList<WorkRecord>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.addOrder("checkTime", OrderType.DESC);
        	page.setPageNo(getFliper().getPageNo());
        	page.setPageSize(getFliper().getPageSize());
            list = baseSo.findObjects(record, page);
        }
        Sheet<WorkRecord> sheet = new Sheet<WorkRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
		
}
